/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.marker.MethodMarker;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.lib.profiler.utils.formatting.Formattable;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatter;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.profiler.AbstractProjectTypeProfiler;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ProfilerIDESettings;
import org.netbeans.modules.profiler.actions.JavaPlatformSelector;
import org.netbeans.modules.profiler.j2ee.LoadGenPanel;
import org.netbeans.modules.profiler.j2ee.ServletUriPanel;
import org.netbeans.modules.profiler.j2ee.WebProjectUtils;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.stp.DefaultSettingsConfigurator;
import org.netbeans.modules.profiler.ui.stp.SelectProfilingTask;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class J2EEProjectTypeProfiler
extends AbstractProjectTypeProfiler {
    private static final String MODIFY_BUILDSCRIPT_CAPTION = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_ModifyBuildScriptCaption");
    private static final String MODIFY_BUILDSCRIPT_MSG = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_ModifyBuildScriptMsg");
    private static final String REGENERATE_BUILDSCRIPT_MSG = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_RegenerateBuildScriptMsg");
    private static final String CANNOT_FIND_BUILDSCRIPT_MSG = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_CannotFindBuildScriptMsg");
    private static final String CANNOT_BACKUP_BUILDSCRIPT_MSG = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_CannotBackupBuildScriptMsg");
    private static final String MODIFY_BUILDSCRIPT_MANUALLY_MSG = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_ModifyBuildScriptManuallyMsg");
    private static final String PROFILING_NOT_SUPPORTED_MSG = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_ProfilingNotSupportedMsg");
    private static final String SKIP_BUTTON_NAME = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_SkipButtonName");
    private static final String NO_SERVER_FOUND_MSG = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_NoServerFoundMsg");
    private static final String PROJECT_CATEGORY = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_ProjectCategory");
    private static final String WEB_CONTAINER_CATEGORY = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_WebContainerCategory");
    private static final String SOAP_CATEGORY = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_SOAPCategory");
    private static final String SOAP_PROTOCOL_PARSING_CATEGORY = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_SOAPProtocolParsingCategory");
    private static final String SOAP_SERIALIZATION_CATEGORY = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_SOAPSerialization");
    private static final String SOAP_ENDPOINT_CATEGORY = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_SOAPEndpointCategory");
    private static final String SOAP_REPLY_CATEGORY = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_SOAPReplyCategory");
    private static final String LIFECYCLE_CATEGORY = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_LifecycleCategory");
    private static final String EXECUTIVE_CATEGORY = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_ExecutiveCategory");
    private static final String JSP_CATEGORY = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_JspCategory");
    private static final String TAGS_CATEGORY = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_TagsCategory");
    private static final String SERVLETS_CATEGORY = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_ServletsCategory");
    private static final String FILTERS_CATEGORY = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_FiltersCategory");
    private static final String LISTENERS_CATEGORY = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_ListenersCategory");
    private static final String EJB_CONTAINER_CATEGORY = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_EjbContainerCategory");
    private static final String POOLING_CATEGORY = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_PoolingCategory");
    private static final String CONTAINER_CALLBACKS_CATEGORY = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_ContainerCallbacksCategory");
    private static final String PERSISTENCE_CATEGORY = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_PersistenceCategory");
    private static final String JDBC_CATEGORY = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_JdbcCategory");
    private static final String CONNECTION_MGMT_CATEGORY = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_ConnectionMgmtCategory");
    private static final String STATEMENTS_CATEGORY = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_StatementsCategory");
    private static final String JPA_CATEGORY = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_JpaCategory");
    private static final String HIBERNATE_CATEGORY = NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"J2EEProjectTypeProfiler_HibernateCategory");
    public static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.profiler.j2ee");
    private static final String J2EE_WEBPROJECT_NAMESPACE_40 = "http://www.netbeans.org/ns/web-project/1";
    private static final String J2EE_WEBPROJECT_NAMESPACE_4x = "http://www.netbeans.org/ns/web-project/2";
    private static final String J2EE_WEBPROJECT_NAMESPACE_41 = "http://www.netbeans.org/ns/web-project/3";
    private static final String J2EE_WEBPROJECT_NAMESPACE_50 = "http://www.netbeans.org/ns/web-project/3";
    private static final String J2EE_EJBJARPROJECT_NAMESPACE_50 = "http://www.netbeans.org/ns/j2ee-ejbjarproject/3";
    private static final String J2EE_EARPROJECT_NAMESPACE_50 = "http://www.netbeans.org/ns/j2ee-earproject/2";
    private static final String STANDARD_IMPORT_STRING = "<import file=\"nbproject/build-impl.xml\"/>";
    private static final String PROFILER_IMPORT_STRING = "<import file=\"nbproject/profiler-build-impl.xml\"/>";
    private static final String PROFILE_VERSION_ATTRIBUTE = "version";
    private static final String VERSION_NUMBER = "0.4";
    private static int lastAgentID = -1;
    private static int lastAgentPort = 5140;
    private SelectProfilingTask.SettingsConfigurator configurator;
    private LoadGenPanel loadGenConfig = null;
    private String loadGenPath = null;
    private PropertyChangeListener pcl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("org.netbeans.modules.profiler.j2ee.LoadGenPanel#path")) {
                J2EEProjectTypeProfiler.this.loadGenPath = (String)propertyChangeEvent.getNewValue();
            }
        }
    };

    public static boolean isEjbProject(Project project) {
        AuxiliaryConfiguration auxiliaryConfiguration = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        Element element = auxiliaryConfiguration.getConfigurationFragment("data", J2EE_EJBJARPROJECT_NAMESPACE_50, true);
        return element != null;
    }

    public static boolean isEnterpriseAppProject(Project project) {
        AuxiliaryConfiguration auxiliaryConfiguration = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        Element element = auxiliaryConfiguration.getConfigurationFragment("data", J2EE_EARPROJECT_NAMESPACE_50, true);
        return element != null;
    }

    public static int getLastAgentID() {
        return lastAgentID;
    }

    public static int getLastAgentPort() {
        return lastAgentPort;
    }

    public static String getServerInstanceID(Project project) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider == null) {
            return null;
        }
        return j2eeModuleProvider.getServerInstanceID();
    }

    public static boolean isSupportedProject(Project project) {
        return J2EEProjectTypeProfiler.isWebProject(project) || J2EEProjectTypeProfiler.isEjbProject(project) || J2EEProjectTypeProfiler.isEnterpriseAppProject(project);
    }

    public static boolean isWebProject(Project project) {
        AuxiliaryConfiguration auxiliaryConfiguration = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        Element element = auxiliaryConfiguration.getConfigurationFragment("data", "http://www.netbeans.org/ns/web-project/3", true);
        if (element == null) {
            element = auxiliaryConfiguration.getConfigurationFragment("data", J2EE_WEBPROJECT_NAMESPACE_40, true);
        }
        if (element == null) {
            element = auxiliaryConfiguration.getConfigurationFragment("data", J2EE_WEBPROJECT_NAMESPACE_4x, true);
        }
        if (element == null) {
            element = auxiliaryConfiguration.getConfigurationFragment("data", "http://www.netbeans.org/ns/web-project/3", true);
        }
        return element != null;
    }

    public String getProfilerTargetName(Project project, FileObject fileObject, int n, FileObject fileObject2) {
        switch (n) {
            case 1: {
                return "profile-j2ee";
            }
            case 3: {
                return null;
            }
            case 4: {
                return "profile-test-single";
            }
        }
        return null;
    }

    public boolean isProfilingSupported(Project project) {
        return J2EEProjectTypeProfiler.isSupportedProject(project);
    }

    public JavaPlatform getProjectJavaPlatform(Project project) {
        String string = J2EEProjectTypeProfiler.getServerInstanceID(project);
        if (string == null) {
            return null;
        }
        return J2EEProjectTypeProfiler.getServerJavaPlatform(string);
    }

    public static JavaPlatform getServerJavaPlatform(String string) {
        J2eePlatform j2eePlatform = J2EEProjectTypeProfiler.getJ2eePlatform(string);
        if (j2eePlatform == null) {
            return null;
        }
        return j2eePlatform.getJavaPlatform();
    }

    public JComponent getAdditionalConfigurationComponent(Project project) {
        if (this.loadGenConfig == null) {
            this.loadGenConfig = new LoadGenPanel();
            this.loadGenConfig.addPropertyChangeListener("org.netbeans.modules.profiler.j2ee.LoadGenPanel#path", WeakListeners.propertyChange((PropertyChangeListener)this.pcl, (Object)this.loadGenConfig));
        }
        this.loadGenConfig.attach(project);
        return this.loadGenConfig;
    }

    public SelectProfilingTask.SettingsConfigurator getSettingsConfigurator() {
        if (this.configurator == null) {
            this.configurator = new DefaultSettingsConfigurator(){

                public LoadGenPanel getCustomSettingsPanel() {
                    if (this.isAttach() || this.isModify()) {
                        return null;
                    }
                    if (J2EEProjectTypeProfiler.this.loadGenConfig == null) {
                        J2EEProjectTypeProfiler.this.loadGenConfig = new LoadGenPanel();
                        J2EEProjectTypeProfiler.this.loadGenConfig.addPropertyChangeListener("org.netbeans.modules.profiler.j2ee.LoadGenPanel#path", WeakListeners.propertyChange((PropertyChangeListener)J2EEProjectTypeProfiler.this.pcl, (Object)J2EEProjectTypeProfiler.this.loadGenConfig));
                    }
                    J2EEProjectTypeProfiler.this.loadGenConfig.attach(this.getProject());
                    return J2EEProjectTypeProfiler.this.loadGenConfig;
                }

                public void loadCustomSettings(Properties properties) {
                    if (J2EEProjectTypeProfiler.this.loadGenConfig != null) {
                        J2EEProjectTypeProfiler.this.loadGenConfig.loadCustomSettings(properties);
                    }
                }

                public void storeCustomSettings(Properties properties) {
                    if (J2EEProjectTypeProfiler.this.loadGenConfig != null) {
                        J2EEProjectTypeProfiler.this.loadGenConfig.storeCustomSettings(properties);
                    }
                }
            };
        }
        return this.configurator;
    }

    public boolean checkProjectCanBeProfiled(Project project, FileObject fileObject) {
        if (!this.isProfilingSupported(project)) {
            return false;
        }
        J2eePlatform j2eePlatform = J2EEProjectTypeProfiler.getJ2eePlatform(project);
        if (j2eePlatform == null) {
            NetBeansProfiler.getDefaultNB().displayError(NO_SERVER_FOUND_MSG);
            return false;
        }
        if (!j2eePlatform.supportsProfiling()) {
            ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PROFILING_NOT_SUPPORTED_MSG, 2));
            return false;
        }
        if (fileObject == null) {
            return true;
        }
        return this.isFileObjectSupported(project, fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkProjectIsModifiedForProfiler(Project project) {
        String string;
        if (ProjectUtilities.isProfilerIntegrated((Project)project)) {
            return true;
        }
        String string2 = ProjectUtils.getInformation((Project)project).getDisplayName();
        String string3 = MessageFormat.format(MODIFY_BUILDSCRIPT_CAPTION, string2);
        String string4 = MessageFormat.format(MODIFY_BUILDSCRIPT_MSG, string2, "build-before-profiler.xml");
        if (ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor((Object)string4, string3, 2, 1, new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION}, NotifyDescriptor.OK_OPTION)) != NotifyDescriptor.OK_OPTION) {
            return false;
        }
        Element element = XMLUtil.createDocument((String)"ignore", null, null, null).createElementNS("http://www.netbeans.org/ns/profiler/1", "data");
        element.setAttribute(PROFILE_VERSION_ATTRIBUTE, VERSION_NUMBER);
        ProjectUtils.getAuxiliaryConfiguration((Project)project).putConfigurationFragment(element, false);
        try {
            ProjectManager.getDefault().saveProject(project);
        }
        catch (IOException iOException) {
            err.notify((Throwable)iOException);
            ProfilerLogger.log((Exception)iOException);
            return false;
        }
        GeneratedFilesHelper generatedFilesHelper = new GeneratedFilesHelper(project.getProjectDirectory());
        int n = generatedFilesHelper.getBuildScriptState("nbproject/profiler-build-impl.xml", J2EEProjectTypeProfiler.class.getResource("profiler-build-impl.xsl"));
        if ((n & 2) != 0 || (n & 0x10) != 0) {
            try {
                if ((n & 4) != 0 && ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)MessageFormat.format(REGENERATE_BUILDSCRIPT_MSG, "profiler-build-impl.xml"), 2)) != NotifyDescriptor.OK_OPTION) {
                    return false;
                }
                generatedFilesHelper.generateBuildScriptFromStylesheet("nbproject/profiler-build-impl.xml", J2EEProjectTypeProfiler.class.getResource("profiler-build-impl.xsl"));
            }
            catch (IOException iOException) {
                err.notify(16, (Throwable)iOException);
                return false;
            }
        }
        if ((string = ProjectUtilities.getProjectBuildScript((Project)project)) == null) {
            ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(CANNOT_FIND_BUILDSCRIPT_MSG, "build.xml"), 0));
            return false;
        }
        if (!ProjectUtilities.backupBuildScript((Project)project) && ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)CANNOT_BACKUP_BUILDSCRIPT_MSG, 2, 2)) != NotifyDescriptor.OK_OPTION) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 200);
        int n2 = string.indexOf(STANDARD_IMPORT_STRING);
        if (n2 == -1) {
            ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(MODIFY_BUILDSCRIPT_MANUALLY_MSG, "build.xml", PROFILER_IMPORT_STRING), 2));
            return false;
        }
        String string5 = "";
        for (int i = n2 - 1; i >= 0; --i) {
            if (string.charAt(i) == ' ') {
                string5 = " " + string5;
                continue;
            }
            if (string.charAt(i) != '\t') break;
            string5 = "\t" + string5;
        }
        stringBuffer.append(string.substring(0, n2 + STANDARD_IMPORT_STRING.length() + 1));
        stringBuffer.append("\n");
        stringBuffer.append(string5);
        stringBuffer.append(PROFILER_IMPORT_STRING);
        stringBuffer.append(string.substring(n2 + STANDARD_IMPORT_STRING.length() + 1));
        FileObject fileObject = this.getProjectBuildScript(project);
        FileLock fileLock = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            fileLock = fileObject.lock();
            outputStreamWriter = new OutputStreamWriter(fileObject.getOutputStream(fileLock), "UTF-8");
            outputStreamWriter.write(stringBuffer.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            err.notify((Throwable)fileNotFoundException);
            ProfilerLogger.log((Exception)fileNotFoundException);
        }
        catch (IOException iOException) {
            err.notify((Throwable)iOException);
            ProfilerLogger.log((Exception)iOException);
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public void configurePropertiesForProfiling(Properties properties, Project project, FileObject fileObject) {
        Object object;
        String string;
        J2EEProjectTypeProfiler.initAntPlatform(project, properties);
        properties.setProperty("profiler.j2ee.serverForceRestart", "true");
        properties.setProperty("profiler.j2ee.serverStartupTimeout", "300000");
        properties.setProperty("profiler.j2ee.agentID", "-Dnbprofiler.agentid=" + new Integer(J2EEProjectTypeProfiler.generateAgentID()).toString());
        String string2 = properties.getProperty("profiler.info.jvmargs");
        if (string2 != null && string2.trim().length() > 0) {
            properties.setProperty("profiler.info.jvmargs.extra", string2);
        }
        JavaPlatform javaPlatform = J2EEProjectTypeProfiler.getJavaPlatformFromAntName(project, properties);
        properties.setProperty("profiler.info.javaPlatform", (String)javaPlatform.getProperties().get("platform.ant.name"));
        String string3 = IDEUtils.getPlatformJDKVersion((JavaPlatform)javaPlatform);
        String string4 = IntegrationUtils.getLocalPlatform((int)IDEUtils.getPlatformArchitecture((JavaPlatform)javaPlatform));
        if (string3.equals("jdk15")) {
            properties.setProperty("profiler.info.jvmargs.agent", IntegrationUtils.getProfilerAgentCommandLineArgs((String)string4, (String)IntegrationUtils.PLATFORM_JAVA_50, (boolean)false, (int)ProfilerIDESettings.getInstance().getPortNo()));
        } else {
            properties.setProperty("profiler.info.jvmargs.agent", IntegrationUtils.getProfilerAgentCommandLineArgs((String)string4, (String)IntegrationUtils.PLATFORM_JAVA_60, (boolean)false, (int)ProfilerIDESettings.getInstance().getPortNo()));
        }
        J2EEProjectTypeProfiler.generateAgentPort();
        if (this.loadGenPath != null) {
            properties.setProperty("profiler.loadgen.path", this.loadGenPath);
        }
        if (fileObject == null) {
            return;
        }
        if (WebProjectUtils.isJSP(fileObject)) {
            properties.put("client.urlPart", WebProjectUtils.getJSPFileContext(project, fileObject, false));
        } else if (WebProjectUtils.isHttpServlet(fileObject)) {
            Object object2;
            Document document;
            string = null;
            object = WebProjectUtils.getDeploymentDescriptorDocuments(project, true);
            Object object3 = object.iterator();
            while (object3.hasNext()) {
                document = object3.next();
                object2 = WebProjectUtils.getServletMapping(fileObject, document);
                if (object2 == null || ((String)object2).length() <= 0) continue;
                string = object2;
                break;
            }
            if (string != null) {
                object3 = new ServletUriPanel(string);
                document = new DialogDescriptor(object3, NbBundle.getMessage(J2EEProjectTypeProfiler.class, (String)"TTL_setServletExecutionUri"), true, new Object[]{DialogDescriptor.OK_OPTION, new JButton(SKIP_BUTTON_NAME){

                    @Override
                    public Dimension getPreferredSize() {
                        return new Dimension(super.getPreferredSize().width + 16, super.getPreferredSize().height);
                    }
                }}, DialogDescriptor.OK_OPTION, 0, null, null);
                object2 = ProfilerDialogs.notify((NotifyDescriptor)document);
                if (object2.equals(NotifyDescriptor.YES_OPTION)) {
                    string = ((ServletUriPanel)object3).getServletUri();
                }
                properties.put("client.urlPart", string);
            }
        }
        string = SourceUtils.getToplevelClassName((FileObject)fileObject);
        properties.setProperty("profile.class", string);
        object = FileUtil.getRelativePath((FileObject)ProjectUtilities.getRootOf((FileObject[])ProjectUtilities.getSourceRoots((Project)project), (FileObject)fileObject), (FileObject)fileObject);
        properties.setProperty("javac.includes", (String)object);
    }

    public static int generateAgentID() {
        int n = J2EEProjectTypeProfiler.generateAgentNumber();
        while (n == lastAgentID) {
            n = J2EEProjectTypeProfiler.generateAgentNumber();
        }
        lastAgentID = n;
        return J2EEProjectTypeProfiler.getLastAgentID();
    }

    public static JavaPlatform generateAgentJavaPlatform(String string) {
        JavaPlatform javaPlatform = IDEUtils.getJavaPlatformByName((String)ProfilerIDESettings.getInstance().getJavaPlatformForProfiling());
        JavaPlatform javaPlatform2 = J2EEProjectTypeProfiler.getServerJavaPlatform(string);
        if (!(javaPlatform != null || (javaPlatform = javaPlatform2) != null && MiscUtils.isSupportedJVM((Map)javaPlatform.getSystemProperties()) || (javaPlatform = JavaPlatformSelector.getDefault().selectPlatformToUse()) != null)) {
            return null;
        }
        return javaPlatform;
    }

    public static int generateAgentPort() {
        lastAgentPort = ProfilerIDESettings.getInstance().getPortNo();
        return J2EEProjectTypeProfiler.getLastAgentPort();
    }

    public void setupProjectSessionSettings(Project project, SessionSettings sessionSettings) {
        PropertyEvaluator propertyEvaluator = this.getProjectProperties(project);
        sessionSettings.setMainClass("");
        String string = propertyEvaluator.getProperty("application.args");
        sessionSettings.setMainArgs(string != null ? string : "");
        String string2 = propertyEvaluator.getProperty("build.classes.dir");
        sessionSettings.setMainClassPath(string2 != null ? MiscUtils.getAbsoluteFilePath((String)string2, (String)FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsolutePath()) : "");
        sessionSettings.setJVMArgs("");
        sessionSettings.setWorkingDir("");
    }

    public boolean supportsSettingsOverride() {
        return true;
    }

    public boolean supportsUnintegrate(Project project) {
        return true;
    }

    public void unintegrateProfiler(Project project) {
        ProjectUtilities.unintegrateProfiler((Project)project);
    }

    private static J2eePlatform getJ2eePlatform(Project project) {
        String string = J2EEProjectTypeProfiler.getServerInstanceID(project);
        if (string == null) {
            return null;
        }
        return J2EEProjectTypeProfiler.getJ2eePlatform(string);
    }

    private static J2eePlatform getJ2eePlatform(String string) {
        return Deployment.getDefault().getJ2eePlatform(string);
    }

    private static JavaPlatform getJavaPlatformFromAntName(Project project, Properties properties) {
        String string = properties.getProperty("profiler.info.javaPlatform");
        JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
        if (string.equals("default_platform")) {
            return javaPlatformManager.getDefaultPlatform();
        }
        JavaPlatform[] javaPlatformArray = javaPlatformManager.getPlatforms(null, new Specification("j2se", null));
        for (int i = 0; i < javaPlatformArray.length; ++i) {
            JavaPlatform javaPlatform = javaPlatformArray[i];
            String string2 = (String)javaPlatform.getProperties().get("platform.ant.name");
            if (!string2.equals(string)) continue;
            return javaPlatform;
        }
        return null;
    }

    private static int generateAgentNumber() {
        return (int)(Math.random() * 2.147483648E9);
    }

    private static void initAntPlatform(Project project, Properties properties) {
        String string = properties.getProperty("profiler.info.javaPlatform");
        if (string == null) {
            JavaPlatform javaPlatform = null;
            J2eePlatform j2eePlatform = J2EEProjectTypeProfiler.getJ2eePlatform(project);
            javaPlatform = j2eePlatform == null ? JavaPlatformManager.getDefault().getDefaultPlatform() : j2eePlatform.getJavaPlatform();
            properties.setProperty("profiler.info.javaPlatform", (String)javaPlatform.getProperties().get("platform.ant.name"));
        }
    }

    private PropertyEvaluator getProjectProperties(Project project) {
        final Properties properties = new Properties();
        final Properties properties2 = new Properties();
        final Properties properties3 = new Properties();
        final FileObject fileObject = project.getProjectDirectory().getFileObject("nbproject/private/private.properties");
        final FileObject fileObject2 = project.getProjectDirectory().getFileObject("nbproject/project.properties");
        final File file = InstalledFileLocator.getDefault().locate("build.properties", null, false);
        ProjectManager.mutex().readAccess(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InputStream inputStream;
                if (fileObject != null) {
                    try {
                        inputStream = fileObject.getInputStream();
                        try {
                            properties.load(inputStream);
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        err.notify(1, (Throwable)iOException);
                    }
                }
                if (fileObject2 != null) {
                    try {
                        inputStream = fileObject2.getInputStream();
                        try {
                            properties2.load(inputStream);
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        err.notify(1, (Throwable)iOException);
                    }
                }
                if (file != null) {
                    try {
                        inputStream = new BufferedInputStream(new FileInputStream(file));
                        try {
                            properties3.load(inputStream);
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        err.notify(1, (Throwable)iOException);
                    }
                }
            }
        });
        PropertyEvaluator propertyEvaluator = PropertyUtils.sequentialPropertyEvaluator(null, (PropertyProvider[])new PropertyProvider[]{new MyPropertyProvider(properties), new MyPropertyProvider(properties3), new MyPropertyProvider(properties2)});
        return propertyEvaluator;
    }

    private void addJspMarker(MethodMarker methodMarker, Mark mark, Project project) {
        ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = WebProjectUtils.getJSPRootMethods(project, true);
        if (sourceCodeSelectionArray != null) {
            for (int i = 0; i < sourceCodeSelectionArray.length; ++i) {
                methodMarker.addMethodMark(sourceCodeSelectionArray[i].getClassName(), sourceCodeSelectionArray[i].getMethodName(), sourceCodeSelectionArray[i].getMethodSignature(), mark);
            }
        }
    }

    private static class MyPropertyProvider
    implements PropertyProvider {
        private Properties props;

        private MyPropertyProvider(Properties properties) {
            this.props = properties;
        }

        public Map getProperties() {
            return this.props;
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }
    }

    private static class JSPNameFormatter
    implements MethodNameFormatter {
        private JSPNameFormatter() {
        }

        public Formattable formatMethodName(final ClientUtils.SourceCodeSelection sourceCodeSelection) {
            return new Formattable(){

                public String toFormatted() {
                    String string = WebProjectUtils.getJSPPath(sourceCodeSelection);
                    return string;
                }
            };
        }

        public Formattable formatMethodName(final String string, final String string2, final String string3) {
            return new Formattable(){

                public String toFormatted() {
                    ClientUtils.SourceCodeSelection sourceCodeSelection = new ClientUtils.SourceCodeSelection(string, string2, string3);
                    String string4 = WebProjectUtils.getJSPPath(sourceCodeSelection);
                    return string4;
                }
            };
        }
    }
}

