/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.php.project.SourceRoots;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.queries.SharabilityQueryImplementation;
import org.openide.util.Mutex;

public class PhpSharabilityQuery
implements SharabilityQueryImplementation,
PropertyChangeListener {
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sources;
    private final SourceRoots tests;
    private final SourceRoots selenium;
    private volatile SharabilityQueryImplementation delegate;

    PhpSharabilityQuery(AntProjectHelper helper, PropertyEvaluator evaluator, SourceRoots sources, SourceRoots tests, SourceRoots selenium) {
        assert (helper != null);
        assert (evaluator != null);
        assert (sources != null);
        assert (tests != null);
        assert (selenium != null);
        this.helper = helper;
        this.evaluator = evaluator;
        this.sources = sources;
        this.tests = tests;
        this.selenium = selenium;
        this.sources.addPropertyChangeListener(this);
        this.tests.addPropertyChangeListener(this);
        this.selenium.addPropertyChangeListener(this);
    }

    public int getSharability(final File file) {
        assert (file != null);
        return (Integer)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer run() {
                PhpSharabilityQuery phpSharabilityQuery = PhpSharabilityQuery.this;
                synchronized (phpSharabilityQuery) {
                    if (PhpSharabilityQuery.this.delegate == null) {
                        PhpSharabilityQuery.this.delegate = PhpSharabilityQuery.this.createDelegate();
                    }
                    return PhpSharabilityQuery.this.delegate.getSharability(file);
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (SourceRoots.PROP_ROOTS.equals(evt.getPropertyName())) {
            this.delegate = null;
        }
    }

    private SharabilityQueryImplementation createDelegate() {
        String[] srcProps = this.sources.getRootProperties();
        String[] testProps = this.tests.getRootProperties();
        String[] seleniumProps = this.tests.getRootProperties();
        int size = srcProps.length;
        size += testProps.length;
        ArrayList<String> props = new ArrayList<String>(size += seleniumProps.length);
        for (String src : srcProps) {
            props.add("${" + src + "}");
        }
        for (String test : testProps) {
            props.add("${" + test + "}");
        }
        for (String test : seleniumProps) {
            props.add("${" + test + "}");
        }
        return this.helper.createSharabilityQuery(this.evaluator, props.toArray(new String[props.size()]), new String[0]);
    }
}

