/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.services;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.navigation.services.HierarchyModel;

class HierarchyModelImpl
implements HierarchyModel {
    private Map<CsmClass, Set<CsmClass>> myMap;
    private Action[] actions;
    private Action close;

    public HierarchyModelImpl(CsmClass cls, Action[] actions, boolean subDirection, boolean plain, boolean recursive) {
        Set<CsmClass> result;
        this.actions = actions;
        this.myMap = subDirection ? this.buildSubHierarchy(cls) : this.buildSuperHierarchy(cls);
        if (!recursive) {
            result = this.myMap.get(cls);
            if (result == null) {
                result = new HashSet<CsmClass>();
            }
            this.myMap = new HashMap<CsmClass, Set<CsmClass>>();
            this.myMap.put(cls, result);
        }
        if (plain) {
            result = new HashSet<CsmClass>();
            this.gatherList(cls, result, this.myMap);
            this.myMap = new HashMap<CsmClass, Set<CsmClass>>();
            this.myMap.put(cls, result);
        }
    }

    @Override
    public Map<CsmClass, Set<CsmClass>> getModel() {
        return this.myMap;
    }

    private void gatherList(CsmClass cls, Set<CsmClass> result, Map<CsmClass, Set<CsmClass>> map) {
        Set<CsmClass> set = map.get(cls);
        if (set == null) {
            return;
        }
        for (CsmClass c : set) {
            if (result.contains(c)) continue;
            result.add(c);
            this.gatherList(c, result, map);
        }
    }

    private Map<CsmClass, Set<CsmClass>> buildSuperHierarchy(CsmClass cls) {
        HashMap<CsmClass, Set<CsmClass>> aMap = new HashMap<CsmClass, Set<CsmClass>>();
        this.buildSuperHierarchy(cls, aMap);
        return aMap;
    }

    private CsmClass getClassDeclaration(CsmInheritance inh) {
        CsmOffsetableDeclaration d;
        CsmClass c = CsmInheritanceUtilities.getCsmClass((CsmInheritance)inh);
        if (CsmKindUtilities.isInstantiation((CsmObject)c) && CsmKindUtilities.isClass((CsmObject)(d = ((CsmInstantiation)c).getTemplateDeclaration()))) {
            c = (CsmClass)d;
        }
        return c;
    }

    private void buildSuperHierarchy(CsmClass cls, Map<CsmClass, Set<CsmClass>> map) {
        Set<CsmClass> back = map.get(cls);
        if (back != null) {
            return;
        }
        back = new HashSet<CsmClass>();
        map.put(cls, back);
        Collection list = cls.getBaseClasses();
        if (list != null && list.size() > 0) {
            for (CsmInheritance inh : list) {
                CsmClass c = this.getClassDeclaration(inh);
                if (c == null) continue;
                back.add(c);
                this.buildSuperHierarchy(c, map);
            }
        }
    }

    private Map<CsmClass, Set<CsmClass>> buildSubHierarchy(CsmClass cls) {
        HashMap<CsmClass, Set<CsmClass>> aMap = new HashMap<CsmClass, Set<CsmClass>>();
        CsmProject prj = cls.getContainingFile().getProject();
        this.buildSubHierarchy(prj.getGlobalNamespace(), aMap);
        return aMap;
    }

    private void buildSubHierarchy(CsmNamespace ns, Map<CsmClass, Set<CsmClass>> map) {
        Iterator it = ns.getNestedNamespaces().iterator();
        while (it.hasNext()) {
            this.buildSubHierarchy((CsmNamespace)it.next(), map);
        }
        for (CsmDeclaration decl : ns.getDeclarations()) {
            if (!CsmKindUtilities.isClass((CsmObject)decl)) continue;
            this.buildSubHierarchy(map, (CsmClass)decl);
        }
    }

    private void buildSubHierarchy(Map<CsmClass, Set<CsmClass>> map, CsmClass cls) {
        Collection list = cls.getBaseClasses();
        if (list != null && list.size() > 0) {
            for (CsmInheritance inh : list) {
                CsmClass c = this.getClassDeclaration(inh);
                if (c == null) continue;
                Set<CsmClass> back = map.get(c);
                if (back == null) {
                    back = new HashSet<CsmClass>();
                    map.put(c, back);
                }
                back.add(cls);
            }
        }
        for (CsmMember member : cls.getMembers()) {
            if (!CsmKindUtilities.isClass((CsmObject)member)) continue;
            this.buildSubHierarchy(map, (CsmClass)member);
        }
    }

    @Override
    public Action[] getDefaultActions() {
        return this.actions;
    }

    @Override
    public Action getCloseWindowAction() {
        return this.close;
    }

    @Override
    public void setCloseWindowAction(Action close) {
        this.close = close;
    }
}

