/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.jaxwssettings.panel;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.api.jaxws.project.config.WsimportOption;
import org.netbeans.modules.websvc.api.jaxws.project.config.WsimportOptions;
import org.netbeans.modules.websvc.customization.jaxwssettings.panel.WsimportOptionsPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class OptionsPanel
extends JPanel {
    private List<String> reservedOptions;
    private Object[] columnNames;
    private List<WsimportOption> options;
    private OptionsTableModel optionsTableModel;
    private AddButtonActionListener addListener;
    private RemoveButtonActionListener removeListener;
    private WsimportOptions wsimportOptions;
    private JButton addBtn;
    private JScrollPane jScrollPane1;
    private JTable optionsTable;
    private JButton removeBtn;

    public OptionsPanel() {
        this(new String[]{"", ""}, new ArrayList<WsimportOption>(), new ArrayList<String>(), null);
    }

    public OptionsPanel(Object[] objectArray, List<WsimportOption> list, List<String> list2, WsimportOptions wsimportOptions) {
        this.initComponents();
        this.reservedOptions = list2;
        this.columnNames = objectArray;
        this.options = list;
        this.wsimportOptions = wsimportOptions;
        this.optionsTableModel = new OptionsTableModel(objectArray, list);
        this.optionsTable.setModel(this.optionsTableModel);
        this.optionsTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        ListSelectionListenerImpl listSelectionListenerImpl = new ListSelectionListenerImpl();
        this.optionsTable.getSelectionModel().addListSelectionListener(listSelectionListenerImpl);
        this.optionsTable.getColumnModel().getSelectionModel().addListSelectionListener(listSelectionListenerImpl);
        this.addListener = new AddButtonActionListener();
        ActionListener actionListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.addListener, (Object)this.addBtn);
        this.addBtn.addActionListener(actionListener);
        this.removeListener = new RemoveButtonActionListener();
        ActionListener actionListener2 = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.removeListener, (Object)this.removeBtn);
        this.removeBtn.addActionListener(actionListener2);
        this.removeBtn.setEnabled(false);
    }

    private void updateButtons() {
        boolean bl = this.optionsTable.getSelectedRowCount() == 1;
        this.removeBtn.setEnabled(bl);
    }

    private int getSelectedRow() {
        ListSelectionModel listSelectionModel = this.optionsTable.getSelectionModel();
        if (listSelectionModel.isSelectionEmpty()) {
            return -1;
        }
        return listSelectionModel.getMinSelectionIndex();
    }

    public void setReservedOptions(List<String> list) {
        this.reservedOptions = list;
    }

    public void setColumnNames(String[] stringArray) {
        this.columnNames = stringArray;
        this.optionsTableModel.setColumnIdentifiers(stringArray);
    }

    public void setOptions(List<WsimportOption> list) {
        this.options = list;
        for (WsimportOption wsimportOption : list) {
            this.optionsTableModel.addRow(new String[]{wsimportOption.getWsimportOptionName(), wsimportOption.getWsimportOptionValue()});
        }
    }

    public List<WsimportOption> getOptions() {
        return this.optionsTableModel.getOptions();
    }

    public TableModel getOptionsTableModel() {
        return this.optionsTableModel;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.optionsTable = new JTable();
        this.addBtn = new JButton();
        this.removeBtn = new JButton();
        this.jScrollPane1.setViewportView(this.optionsTable);
        this.addBtn.setText("Add");
        this.addBtn.setToolTipText(NbBundle.getMessage(OptionsPanel.class, (String)"HINT_Add"));
        this.removeBtn.setText("Remove");
        this.removeBtn.setToolTipText(NbBundle.getMessage(OptionsPanel.class, (String)"HINT_Remove"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jScrollPane1, -2, 351, -2).add(26, 26, 26).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.removeBtn, -1, 124, Short.MAX_VALUE).add((Component)this.addBtn, -1, 124, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 165, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addBtn).addPreferredGap(1).add((Component)this.removeBtn))).addContainerGap()));
        Mnemonics.setLocalizedText((AbstractButton)this.addBtn, (String)NbBundle.getMessage(OptionsPanel.class, (String)"Add_DotDotDot_label"));
        this.addBtn.getAccessibleContext().setAccessibleName(NbBundle.getMessage(OptionsPanel.class, (String)"Add_DotDotDot_label"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeBtn, (String)NbBundle.getMessage(OptionsPanel.class, (String)"Remove_label"));
        this.removeBtn.getAccessibleContext().setAccessibleName(NbBundle.getMessage(OptionsPanel.class, (String)"Remove_label"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(OptionsPanel.class, (String)"Remove_label"));
    }

    class OptionsTableModel
    extends DefaultTableModel {
        private List<WsimportOption> options;
        private String[] columnNames;

        public OptionsTableModel(Object[] objectArray, List<WsimportOption> list) {
            super(objectArray, list.size());
            this.columnNames = (String[])objectArray;
            this.options = list;
        }

        public Class getColumnClass(int n) {
            return super.getColumnClass(n);
        }

        public List<WsimportOption> getOptions() {
            return this.options;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        private String generateUniqueName(String string) {
            String string2 = string;
            int n = 1;
            HashSet<String> hashSet = new HashSet<String>();
            for (WsimportOption wsimportOption : this.options) {
                hashSet.add(wsimportOption.getWsimportOptionName());
            }
            while (hashSet.contains(string2)) {
                string2 = string + ++n;
            }
            return string2;
        }

        public int addOption() {
            String string = this.generateUniqueName(NbBundle.getMessage(OptionsPanel.class, (String)"DEFAULT_OPTION_NAME"));
            int n = this.options.size();
            String string2 = NbBundle.getMessage(OptionsPanel.class, (String)"DEFAULT_VALUE");
            this.addRow(new String[]{string, string2});
            WsimportOption wsimportOption = OptionsPanel.this.wsimportOptions.newWsimportOption();
            wsimportOption.setWsimportOptionName(string);
            wsimportOption.setWsimportOptionValue(string2);
            this.options.add(wsimportOption);
            this.fireTableRowsInserted(n, n);
            return n;
        }

        public void removeOption(int n) {
            this.options.remove(n);
            this.removeRow(n);
            this.fireTableRowsDeleted(n, n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String string = null;
            if (n >= 0) {
                WsimportOption wsimportOption = this.options.get(n);
                switch (n2) {
                    case 0: {
                        string = wsimportOption.getWsimportOptionName();
                        break;
                    }
                    case 1: {
                        string = wsimportOption.getWsimportOptionValue();
                    }
                }
            }
            return string;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            WsimportOption wsimportOption = null;
            String string = (String)object;
            String string2 = (String)this.getValueAt(n, 1);
            if (n2 == 0) {
                String string3 = (String)this.getValueAt(n, 0);
                if (string3.equals(string)) {
                    return;
                }
                if (OptionsPanel.this.reservedOptions != null) {
                    for (String string4 : OptionsPanel.this.reservedOptions) {
                        if (!string.trim().equals(string4)) continue;
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WsimportOptionsPanel.class, (String)"ERR_RESERVED_OPTION", (Object)string));
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                        WsimportOption wsimportOption2 = OptionsPanel.this.wsimportOptions.newWsimportOption();
                        wsimportOption2.setWsimportOptionName(string3);
                        wsimportOption2.setWsimportOptionValue(string2);
                        this.options.set(n, wsimportOption2);
                        this.fireTableCellUpdated(n, n2);
                        return;
                    }
                }
                wsimportOption = OptionsPanel.this.wsimportOptions.newWsimportOption();
                wsimportOption.setWsimportOptionName(string);
                wsimportOption.setWsimportOptionValue((String)this.getValueAt(n, 1));
            } else if (n2 == 1) {
                if (string2 != null && string2.equals(string)) {
                    return;
                }
                wsimportOption = OptionsPanel.this.wsimportOptions.newWsimportOption();
                wsimportOption.setWsimportOptionName((String)this.getValueAt(n, 0));
                wsimportOption.setWsimportOptionValue(string);
            }
            this.options.set(n, wsimportOption);
            this.fireTableCellUpdated(n, n2);
        }
    }

    private class ListSelectionListenerImpl
    implements ListSelectionListener {
        private ListSelectionListenerImpl() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            OptionsPanel.this.optionsTable.editCellAt(OptionsPanel.this.optionsTable.getSelectedRow(), OptionsPanel.this.optionsTable.getSelectedColumn());
            Component component = OptionsPanel.this.optionsTable.getEditorComponent();
            if (component != null) {
                component.requestFocus();
            }
            if (component instanceof JTextComponent) {
                JTextComponent jTextComponent = (JTextComponent)component;
                jTextComponent.selectAll();
            }
            OptionsPanel.this.updateButtons();
        }
    }

    class AddButtonActionListener
    implements ActionListener {
        AddButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = OptionsPanel.this.optionsTableModel.addOption();
            OptionsPanel.this.optionsTable.getSelectionModel().setSelectionInterval(n, n);
            OptionsPanel.this.optionsTable.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
            OptionsPanel.this.updateButtons();
        }
    }

    class RemoveButtonActionListener
    implements ActionListener {
        RemoveButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = OptionsPanel.this.getSelectedRow();
            String string = (String)OptionsPanel.this.optionsTableModel.getValueAt(n, 0);
            if (this.confirmDeletion(string)) {
                if (n > -1) {
                    OptionsPanel.this.optionsTableModel.removeOption(n);
                }
                if (n == OptionsPanel.this.optionsTable.getRowCount()) {
                    --n;
                }
                OptionsPanel.this.optionsTable.getSelectionModel().setSelectionInterval(n, n);
            }
            OptionsPanel.this.updateButtons();
        }

        private boolean confirmDeletion(String string) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(WsimportOptionsPanel.class, (String)"MSG_CONFIRM_DELETE", (Object)string), NbBundle.getMessage(WsimportOptionsPanel.class, (String)"TTL_CONFIRM_DELETE"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            return confirmation.getValue() == NotifyDescriptor.YES_OPTION;
        }
    }
}

