/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.support;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;

public class MultipartFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_MULTIPART_RESOLVER_BEAN_NAME = "filterMultipartResolver";
    private String multipartResolverBeanName = "filterMultipartResolver";

    public void setMultipartResolverBeanName(String multipartResolverBeanName) {
        this.multipartResolverBeanName = multipartResolverBeanName;
    }

    protected String getMultipartResolverBeanName() {
        return this.multipartResolverBeanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        HttpServletRequest processedRequest;
        MultipartResolver multipartResolver = this.lookupMultipartResolver(request);
        if (multipartResolver.isMultipart(processedRequest = request)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Resolving multipart request [" + processedRequest.getRequestURI() + "] with MultipartFilter"));
            }
            processedRequest = multipartResolver.resolveMultipart(processedRequest);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Request [" + processedRequest.getRequestURI() + "] is not a multipart request"));
        }
        try {
            filterChain.doFilter((ServletRequest)processedRequest, (ServletResponse)response);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (processedRequest instanceof MultipartHttpServletRequest) {
                multipartResolver.cleanupMultipart((MultipartHttpServletRequest)processedRequest);
            }
            throw throwable;
        }
        if (processedRequest instanceof MultipartHttpServletRequest) {
            multipartResolver.cleanupMultipart((MultipartHttpServletRequest)processedRequest);
        }
    }

    protected MultipartResolver lookupMultipartResolver(HttpServletRequest request) {
        return this.lookupMultipartResolver();
    }

    protected MultipartResolver lookupMultipartResolver() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using MultipartResolver '" + this.getMultipartResolverBeanName() + "' for MultipartFilter"));
        }
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (MultipartResolver)wac.getBean(this.getMultipartResolverBeanName(), MultipartResolver.class);
    }
}

