/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.autoupdate.services.AutoupdateSettings;
import org.netbeans.modules.autoupdate.updateprovider.DownloadListener;
import org.netbeans.modules.autoupdate.updateprovider.NetworkAccess;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class AutoupdateCatalogCache {
    private File cacheDir;
    private static AutoupdateCatalogCache INSTANCE;
    private Logger err = Logger.getLogger(this.getClass().getName());

    public static synchronized AutoupdateCatalogCache getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new AutoupdateCatalogCache();
            INSTANCE.initCacheDirectory();
        }
        return INSTANCE;
    }

    private synchronized File getCatalogCache() {
        assert (this.cacheDir != null && this.cacheDir.exists());
        return this.cacheDir;
    }

    private void initCacheDirectory() {
        assert (this.cacheDir == null) : "Do initCacheDirectory only once!";
        String userDir = System.getProperty("netbeans.user");
        if (userDir != null) {
            this.cacheDir = new File(new File(new File(userDir, "var"), "cache"), "catalogcache");
        } else {
            File dir = FileUtil.toFile((FileObject)FileUtil.getConfigRoot());
            this.cacheDir = new File(dir, "catalogcache");
        }
        this.cacheDir.mkdirs();
        this.getLicenseDir().mkdirs();
        this.err.log(Level.FINE, "getCacheDirectory: " + this.cacheDir.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL writeCatalogToCache(String codeName, URL original) throws IOException {
        File cache;
        URL url;
        block8: {
            url = null;
            File dir = this.getCatalogCache();
            assert (dir != null && dir.exists()) : "Cache directory must exist.";
            cache = new File(dir, codeName);
            this.copy(original, cache, false);
            try {
                url = cache.toURI().toURL();
            }
            catch (MalformedURLException ex) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)ex);
            }
        }
        String string = this.getLock(cache);
        synchronized (string) {
            assert (cache.exists()) : "Cache " + cache + " exists.";
            this.err.log(Level.FINER, "Cache file " + cache + " was wrote from original URL " + original);
            if (cache.exists() && cache.length() == 0L) {
                this.err.log(Level.INFO, "Written cache size is zero bytes");
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getCatalogURL(String codeName) {
        File dir = this.getCatalogCache();
        assert (dir != null && dir.exists()) : "Cache directory must exist.";
        File cache = new File(dir, codeName);
        String string = this.getLock(cache);
        synchronized (string) {
            if (cache != null && cache.exists()) {
                URL url;
                block8: {
                    if (cache.length() == 0L) {
                        this.err.log(Level.INFO, "Cache file " + cache + " exists and of zero size");
                        return null;
                    }
                    url = null;
                    try {
                        url = cache.toURI().toURL();
                    }
                    catch (MalformedURLException ex) {
                        if ($assertionsDisabled) break block8;
                        throw new AssertionError((Object)ex);
                    }
                }
                return url;
            }
            return null;
        }
    }

    private File getLicenseDir() {
        return new File(this.getCatalogCache(), "licenses");
    }

    private File getLicenseFile(String name) {
        return new File(this.getLicenseDir(), name);
    }

    public String getLicense(String name) {
        return this.getLicense(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLicense(String name, URL url) {
        File file = this.getLicenseFile(name);
        String string = name.intern();
        synchronized (string) {
            if (!file.exists()) {
                if (url == null) {
                    return null;
                }
                try {
                    this.copy(url, file, true);
                }
                catch (IOException e) {
                    this.err.log(Level.INFO, "Can`t store license from " + url + " to " + file, e);
                    try {
                        if (file.exists()) {
                            file.delete();
                        }
                        file.createNewFile();
                        file.deleteOnExit();
                    }
                    catch (IOException ex) {
                        this.err.log(Level.INFO, "Can`t create empty license file", ex);
                    }
                }
            }
            return this.readLicenseFile(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeLicense(String name, String content) {
        File file = this.getLicenseFile(name);
        String string = name.intern();
        synchronized (string) {
            if (file.exists() || content == null) {
                return;
            }
            this.writeToFile(content, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readLicenseFile(String name) {
        File file = this.getLicenseFile(name);
        FileInputStream fr = null;
        String string = name.intern();
        synchronized (string) {
            try {
                fr = new FileInputStream(file);
                byte[] buffer = new byte[8192];
                int n = 0;
                StringBuilder sb = new StringBuilder();
                while ((n = fr.read(buffer)) != -1) {
                    sb.append(new String(buffer, 0, n, "utf-8"));
                }
                String string2 = sb.toString();
                return string2;
            }
            catch (IOException e) {
                this.err.log(Level.INFO, "Can`t read license from file " + file, e);
                String string3 = null;
                return string3;
            }
            finally {
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (IOException e3) {
                        this.err.log(Level.INFO, "Can`t read close input stream for " + file, e3);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(String content, File file) {
        FileOutputStream fw = null;
        try {
            fw = new FileOutputStream(file);
            fw.write(content.getBytes("utf-8"));
        }
        catch (IOException e) {
            this.err.log(Level.INFO, "Can`t write to " + file, e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.flush();
                    fw.close();
                }
                catch (IOException e) {
                    this.err.log(Level.INFO, "Can`t output stream for " + file, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(URL sourceUrl, File cache, boolean allowZeroSize) throws IOException {
        this.err.log(Level.FINE, "Processing URL: " + sourceUrl);
        String prefix = "";
        while (prefix.length() < 3) {
            prefix = prefix + cache.getName();
        }
        File temp = File.createTempFile(prefix, null, cache.getParentFile());
        temp.deleteOnExit();
        DownloadListener nwl = new DownloadListener(sourceUrl, temp, allowZeroSize);
        NetworkAccess.Task task = NetworkAccess.createNetworkAcessTask(sourceUrl, AutoupdateSettings.getOpenConnectionTimeout(), nwl);
        task.waitFinished();
        nwl.notifyException();
        String string = this.getLock(cache);
        synchronized (string) {
            this.updateCachedFile(cache, temp);
        }
    }

    public String getLock(File cache) {
        return cache.getAbsolutePath().intern();
    }

    public String getLock(URL cache) {
        return this.getLock(new File(cache.getFile()));
    }

    private void updateCachedFile(File cache, File temp) {
        if (cache.exists() && !cache.delete()) {
            block6: {
                this.err.log(Level.INFO, "Cannot delete cache " + cache);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ie) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError((Object)ie);
                }
            }
            cache.delete();
        }
        if (temp.length() == 0L) {
            this.err.log(Level.INFO, "Temp cache size is zero bytes");
        }
        if (!temp.renameTo(cache)) {
            this.err.log(Level.INFO, "Cannot rename temp " + temp + " to cache " + cache);
        }
        if (cache.exists() && cache.length() == 0L) {
            this.err.log(Level.INFO, "Final cache size is zero bytes");
        }
    }
}

