/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import com.rc.retroweaver.runtime.Autobox;
import org.eclipse.jface.text.BadLocationException;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.actions.PyComment;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyToggleComment
extends PyComment {
    @Override
    public Tuple<Integer, Integer> perform(PySelection ps) throws BadLocationException {
        ps.selectCompleteLine();
        boolean shouldAddCommentSign = !PyToggleComment.allLinesStartWithCommentSign(ps);
        String endLineDelim = ps.getEndLineDelim();
        int endLineIndex = ps.getEndLineIndex();
        int startLineIndex = ps.getStartLineIndex();
        FastStringBuffer sb = new FastStringBuffer(ps.getSelLength() + (endLineIndex - startLineIndex) + 10);
        int i = startLineIndex;
        int n = endLineIndex;
        while (i <= n) {
            String line = ps.getLine(i);
            if (shouldAddCommentSign) {
                sb.append("#");
                sb.append(line);
            } else {
                sb.append(line.replaceFirst("#", ""));
            }
            sb.append(i < endLineIndex ? endLineDelim : "");
            ++i;
        }
        int start = ps.getStartLine().getOffset();
        String replacement = sb.toString();
        ps.getDoc().replace(start, ps.getSelLength(), replacement);
        return new Tuple((Object)Autobox.valueOf((int)start), (Object)Autobox.valueOf((int)replacement.length()));
    }

    private static boolean allLinesStartWithCommentSign(PySelection ps) {
        int endLineIndex = ps.getEndLineIndex();
        int i = ps.getStartLineIndex();
        int n = endLineIndex;
        while (i <= n) {
            String line = ps.getLine(i);
            if (!line.trim().startsWith("#")) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

