/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.poifs.dev.POIFSViewable;
import org.apache.poi.poifs.filesystem.BATManaged;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.EntryNode;
import org.apache.poi.poifs.filesystem.POIFSDocument;
import org.apache.poi.poifs.filesystem.POIFSWriterListener;
import org.apache.poi.poifs.property.DirectoryProperty;
import org.apache.poi.poifs.property.Property;
import org.apache.poi.poifs.property.PropertyTable;
import org.apache.poi.poifs.storage.BATBlock;
import org.apache.poi.poifs.storage.BlockAllocationTableReader;
import org.apache.poi.poifs.storage.BlockAllocationTableWriter;
import org.apache.poi.poifs.storage.BlockList;
import org.apache.poi.poifs.storage.BlockWritable;
import org.apache.poi.poifs.storage.HeaderBlockReader;
import org.apache.poi.poifs.storage.HeaderBlockWriter;
import org.apache.poi.poifs.storage.RawDataBlockList;
import org.apache.poi.poifs.storage.SmallBlockTableReader;
import org.apache.poi.poifs.storage.SmallBlockTableWriter;

public class POIFSFileSystem
implements POIFSViewable {
    private PropertyTable _property_table = new PropertyTable();
    private List _documents = new ArrayList();
    private DirectoryNode _root = null;

    public POIFSFileSystem() {
    }

    public POIFSFileSystem(InputStream inputStream) throws IOException {
        this();
        HeaderBlockReader headerBlockReader = new HeaderBlockReader(inputStream);
        RawDataBlockList rawDataBlockList = new RawDataBlockList(inputStream);
        new BlockAllocationTableReader(headerBlockReader.getBATCount(), headerBlockReader.getBATArray(), headerBlockReader.getXBATCount(), headerBlockReader.getXBATIndex(), rawDataBlockList);
        PropertyTable propertyTable = new PropertyTable(headerBlockReader.getPropertyStart(), rawDataBlockList);
        this.processProperties(SmallBlockTableReader.getSmallDocumentBlocks(rawDataBlockList, propertyTable.getRoot(), headerBlockReader.getSBATStart()), rawDataBlockList, propertyTable.getRoot().getChildren(), null);
    }

    public DocumentEntry createDocument(InputStream inputStream, String string) throws IOException {
        return this.getRoot().createDocument(string, inputStream);
    }

    public DocumentEntry createDocument(String string, int n, POIFSWriterListener pOIFSWriterListener) throws IOException {
        return this.getRoot().createDocument(string, n, pOIFSWriterListener);
    }

    public DirectoryEntry createDirectory(String string) throws IOException {
        return this.getRoot().createDirectory(string);
    }

    public void writeFilesystem(OutputStream outputStream) throws IOException {
        this._property_table.preWrite();
        SmallBlockTableWriter smallBlockTableWriter = new SmallBlockTableWriter(this._documents, this._property_table.getRoot());
        BlockAllocationTableWriter blockAllocationTableWriter = new BlockAllocationTableWriter();
        ArrayList<BlockWritable> arrayList = new ArrayList<BlockWritable>();
        arrayList.addAll(this._documents);
        arrayList.add(this._property_table);
        arrayList.add(smallBlockTableWriter);
        arrayList.add(smallBlockTableWriter.getSBAT());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            BATManaged bATManaged = (BATManaged)iterator.next();
            int n = bATManaged.countBlocks();
            if (n == 0) continue;
            bATManaged.setStartBlock(blockAllocationTableWriter.allocateSpace(n));
        }
        int n = blockAllocationTableWriter.createBlocks();
        HeaderBlockWriter headerBlockWriter = new HeaderBlockWriter();
        BATBlock[] bATBlockArray = headerBlockWriter.setBATBlocks(blockAllocationTableWriter.countBlocks(), n);
        headerBlockWriter.setPropertyStart(this._property_table.getStartBlock());
        headerBlockWriter.setSBATStart(smallBlockTableWriter.getSBAT().getStartBlock());
        headerBlockWriter.setSBATBlockCount(smallBlockTableWriter.getSBATBlockCount());
        ArrayList<BlockWritable> arrayList2 = new ArrayList<BlockWritable>();
        arrayList2.add(headerBlockWriter);
        arrayList2.addAll(this._documents);
        arrayList2.add(this._property_table);
        arrayList2.add(smallBlockTableWriter);
        arrayList2.add(smallBlockTableWriter.getSBAT());
        arrayList2.add(blockAllocationTableWriter);
        for (int i = 0; i < bATBlockArray.length; ++i) {
            arrayList2.add(bATBlockArray[i]);
        }
        iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            BlockWritable blockWritable = (BlockWritable)iterator.next();
            blockWritable.writeBlocks(outputStream);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 2) {
            System.err.println("two arguments required: input filename and output filename");
            System.exit(1);
        }
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1]);
        new POIFSFileSystem(fileInputStream).writeFilesystem(fileOutputStream);
        fileInputStream.close();
        fileOutputStream.close();
    }

    public DirectoryEntry getRoot() {
        if (this._root == null) {
            this._root = new DirectoryNode(this._property_table.getRoot(), this, null);
        }
        return this._root;
    }

    public DocumentInputStream createDocumentInputStream(String string) throws IOException {
        Entry entry = this.getRoot().getEntry(string);
        if (!entry.isDocumentEntry()) {
            throw new IOException(String.valueOf(String.valueOf(new StringBuffer("Entry '").append(string).append("' is not a DocumentEntry"))));
        }
        return new DocumentInputStream((DocumentEntry)entry);
    }

    void addDocument(POIFSDocument pOIFSDocument) {
        this._documents.add(pOIFSDocument);
        this._property_table.addProperty(pOIFSDocument.getDocumentProperty());
    }

    void addDirectory(DirectoryProperty directoryProperty) {
        this._property_table.addProperty(directoryProperty);
    }

    void remove(EntryNode entryNode) {
        this._property_table.removeProperty(entryNode.getProperty());
        if (entryNode.isDocumentEntry()) {
            this._documents.remove(((DocumentNode)entryNode).getDocument());
        }
    }

    private void processProperties(BlockList blockList, BlockList blockList2, Iterator iterator, DirectoryNode directoryNode) throws IOException {
        while (iterator.hasNext()) {
            DirectoryNode directoryNode2;
            Property property = (Property)iterator.next();
            String string = property.getName();
            DirectoryNode directoryNode3 = directoryNode2 = directoryNode == null ? (DirectoryNode)this.getRoot() : directoryNode;
            if (property.isDirectory()) {
                DirectoryNode directoryNode4 = (DirectoryNode)directoryNode2.createDirectory(string);
                directoryNode4.setStorageClsid(property.getStorageClsid());
                this.processProperties(blockList, blockList2, ((DirectoryProperty)property).getChildren(), directoryNode4);
                continue;
            }
            int n = property.getStartBlock();
            int n2 = property.getSize();
            POIFSDocument pOIFSDocument = null;
            pOIFSDocument = property.shouldUseSmallBlocks() ? new POIFSDocument(string, blockList.fetchBlocks(n), n2) : new POIFSDocument(string, blockList2.fetchBlocks(n), n2);
            directoryNode2.createDocument(pOIFSDocument);
        }
    }

    public Object[] getViewableArray() {
        if (this.preferArray()) {
            return ((POIFSViewable)((Object)this.getRoot())).getViewableArray();
        }
        return new Object[0];
    }

    public Iterator getViewableIterator() {
        if (!this.preferArray()) {
            return ((POIFSViewable)((Object)this.getRoot())).getViewableIterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public boolean preferArray() {
        return ((POIFSViewable)((Object)this.getRoot())).preferArray();
    }

    public String getShortDescription() {
        return "POIFS FileSystem";
    }
}

