/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.RightOwner;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.table.Table;

public class Right
extends DbObject {
    public static final int SELECT = 1;
    public static final int DELETE = 2;
    public static final int INSERT = 4;
    public static final int UPDATE = 8;
    public static final int ALL = 15;
    private Role grantedRole;
    private int grantedRight;
    private Table grantedTable;
    private RightOwner grantee;

    public Right(Database db, int id, RightOwner grantee, Role grantedRole) {
        super(db, id, "RIGHT_" + id, "user");
        this.grantee = grantee;
        this.grantedRole = grantedRole;
    }

    public Right(Database db, int id, RightOwner grantee, int grantedRight, Table grantedRightOnTable) {
        super(db, id, "" + id, "user");
        this.grantee = grantee;
        this.grantedRight = grantedRight;
        this.grantedTable = grantedRightOnTable;
    }

    private boolean appendRight(StringBuffer buff, int right, int mask, String name, boolean comma) {
        if ((right & mask) != 0) {
            if (comma) {
                buff.append(", ");
            }
            buff.append(name);
            return true;
        }
        return comma;
    }

    public String getRights() {
        StringBuffer buff = new StringBuffer();
        if (this.grantedRight == 15) {
            buff.append("ALL");
        } else {
            boolean comma = false;
            comma = this.appendRight(buff, this.grantedRight, 1, "SELECT", comma);
            comma = this.appendRight(buff, this.grantedRight, 2, "DELETE", comma);
            comma = this.appendRight(buff, this.grantedRight, 4, "INSERT", comma);
            this.appendRight(buff, this.grantedRight, 8, "UPDATE", comma);
        }
        return buff.toString();
    }

    public Role getGrantedRole() {
        return this.grantedRole;
    }

    public Table getGrantedTable() {
        return this.grantedTable;
    }

    public DbObject getGrantee() {
        return this.grantee;
    }

    public String getCreateSQLForCopy(Table table, String quotedTable, String quotedName) {
        StringBuffer buff = new StringBuffer();
        buff.append("GRANT ");
        if (this.grantedRole != null) {
            buff.append(this.grantedRole.getSQL());
        } else {
            buff.append(this.getRights());
            buff.append(" ON ");
            buff.append(quotedTable);
        }
        buff.append(" TO ");
        buff.append(this.grantee.getSQL());
        return buff.toString();
    }

    public String getCreateSQL() {
        String quotedTable = this.grantedTable == null ? null : this.grantedTable.getSQL();
        return this.getCreateSQLForCopy(null, quotedTable, null);
    }

    public int getType() {
        return 8;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        if (this.grantedTable != null) {
            this.grantee.revokeRight(this.grantedTable);
        } else {
            this.grantee.revokeRole(session, this.grantedRole);
        }
        this.grantedRole = null;
        this.grantedTable = null;
        this.grantee = null;
        this.invalidate();
    }

    public void checkRename() throws SQLException {
        throw Message.internal();
    }

    public void setRightMask(int rightMask) {
        this.grantedRight = rightMask;
    }

    public int getRightMask() {
        return this.grantedRight;
    }
}

