/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.server;

import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public final class ServerForm
extends ActionForm {
    private String nodeLabel = null;
    private String portNumberText = "8080";
    private String shutdownText = null;
    private String objectName = null;

    public String getNodeLabel() {
        return this.nodeLabel;
    }

    public void setNodeLabel(String nodeLabel) {
        this.nodeLabel = nodeLabel;
    }

    public String getPortNumberText() {
        return this.portNumberText;
    }

    public void setPortNumberText(String portNumberText) {
        this.portNumberText = portNumberText;
    }

    public String getShutdownText() {
        return this.shutdownText;
    }

    public void setShutdownText(String shutdownText) {
        this.shutdownText = shutdownText;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.portNumberText = null;
        this.shutdownText = null;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.portNumberText == null || this.portNumberText.length() < 1) {
            errors.add("portNumberText", new ActionMessage("error.portNumber.required"));
        } else {
            try {
                int port = Integer.parseInt(this.portNumberText);
                if (port <= 0 || port > 65535) {
                    errors.add("portNumberText", new ActionMessage("error.portNumber.range"));
                }
            }
            catch (NumberFormatException e) {
                errors.add("portNumberText", new ActionMessage("error.portNumber.format"));
            }
        }
        if (this.shutdownText == null || this.shutdownText.length() < 7) {
            errors.add("shutdownText", new ActionMessage("error.shutdownText.length"));
        }
        return errors;
    }
}

