/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.PageData;
import org.h2.index.PageDataLeaf;
import org.h2.index.PageDataNode;
import org.h2.index.RowIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.DataPage;
import org.h2.store.PageStore;
import org.h2.store.Record;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableData;

public class PageScanIndex
extends BaseIndex
implements RowIndex {
    private PageStore store;
    private TableData tableData;
    private int headPos;
    private int lastKey;
    private long rowCount;
    private long rowCountApproximation;

    public PageScanIndex(TableData tableData, int n, IndexColumn[] indexColumnArray, IndexType indexType, int n2) throws SQLException {
        this.initBaseIndex(tableData, n, tableData.getName() + "_TABLE_SCAN", indexColumnArray, indexType);
        if (this.database.isMultiVersion()) {
            // empty if block
        }
        this.tableData = tableData;
        if (!this.database.isPersistent() || n < 0) {
            return;
        }
        this.store = this.database.getPageStore();
        if (n2 == -1) {
            n2 = this.store.allocatePage();
            PageDataLeaf pageDataLeaf = new PageDataLeaf(this, n2, 0, this.store.createDataPage());
            this.store.updateRecord(pageDataLeaf, pageDataLeaf.data);
        } else if (this.store.isNew()) {
            PageDataLeaf pageDataLeaf = new PageDataLeaf(this, n2, 0, this.store.createDataPage());
            this.store.updateRecord(pageDataLeaf, pageDataLeaf.data);
        } else {
            this.lastKey = this.getPage(n2).getLastKey();
            this.rowCount = this.getPage(n2).getRowCount();
        }
        this.headPos = n2;
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("open " + this.rowCount);
        }
        tableData.setRowCount(this.rowCount);
    }

    public int getHeadPos() {
        return this.headPos;
    }

    public void add(Session session, Row row) throws SQLException {
        PageData pageData;
        int n;
        row.setPos(++this.lastKey);
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("add " + row.getPos());
        }
        while ((n = (pageData = this.getPage(this.headPos)).addRow(row)) != 0) {
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("split " + n);
            }
            int n2 = pageData.getKey(n - 1);
            PageData pageData2 = pageData;
            PageData pageData3 = pageData.split(n);
            int n3 = pageData.getPageId();
            int n4 = this.store.allocatePage();
            pageData2.setPageId(n4);
            pageData2.setParentPageId(this.headPos);
            pageData3.setParentPageId(this.headPos);
            PageDataNode pageDataNode = new PageDataNode(this, n3, 0, this.store.createDataPage());
            pageDataNode.init(pageData2, n2, pageData3);
            this.store.updateRecord(pageData2, pageData2.data);
            this.store.updateRecord(pageData3, pageData3.data);
            this.store.updateRecord(pageDataNode, null);
            pageData = pageDataNode;
        }
        ++this.rowCount;
        this.store.getLog().addOrRemoveRow(session, this.tableData.getId(), row, true);
    }

    PageData getPage(int n) throws SQLException {
        PageData pageData;
        Record record = this.store.getRecord(n);
        if (record != null) {
            return (PageData)record;
        }
        DataPage dataPage = this.store.readPage(n);
        dataPage.reset();
        int n2 = dataPage.readInt();
        int n3 = dataPage.readByte() & 0xFF;
        switch (n3 & 0xFFFFFFEF) {
            case 1: {
                pageData = new PageDataLeaf(this, n, n2, dataPage);
                break;
            }
            case 2: {
                pageData = new PageDataNode(this, n, n2, dataPage);
                break;
            }
            case 0: {
                PageDataLeaf pageDataLeaf = new PageDataLeaf(this, n, n2, dataPage);
                return pageDataLeaf;
            }
            default: {
                throw Message.getSQLException(90030, "page=" + n + " type=" + n3);
            }
        }
        pageData.read();
        return pageData;
    }

    public boolean canGetFirstOrLast() {
        return false;
    }

    public void close(Session session) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("close");
        }
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        PageData pageData = this.getPage(this.headPos);
        return pageData.find();
    }

    public Cursor findFirstOrLast(Session session, boolean bl) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public double getCost(Session session, int[] nArray) throws SQLException {
        long l = 10L * (this.tableData.getRowCountApproximation() + 1000L);
        return l;
    }

    public boolean needRebuild() {
        return false;
    }

    public void remove(Session session, Row row) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("remove " + row.getPos());
        }
        if (this.rowCount == 1L) {
            this.truncate(session);
        } else {
            int n = row.getPos();
            PageData pageData = this.getPage(this.headPos);
            pageData.remove(n);
            --this.rowCount;
        }
        this.store.getLog().addOrRemoveRow(session, this.tableData.getId(), row, false);
    }

    public void remove(Session session) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("remove");
        }
    }

    public void truncate(Session session) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("truncate");
        }
        this.store.removeRecord(this.headPos);
        PageDataLeaf pageDataLeaf = new PageDataLeaf(this, this.headPos, 0, this.store.createDataPage());
        this.store.updateRecord(pageDataLeaf, null);
        this.rowCount = 0L;
        this.lastKey = 0;
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public Row getRow(Session session, int n) throws SQLException {
        PageData pageData = this.getPage(this.headPos);
        return pageData.getRow(session, n);
    }

    PageStore getPageStore() {
        return this.store;
    }

    Row readRow(DataPage dataPage) throws SQLException {
        return this.tableData.readRow(dataPage);
    }

    public long getRowCountApproximation() {
        return this.rowCountApproximation;
    }

    public long getRowCount(Session session) {
        return this.rowCount;
    }

    public String getCreateSQL() {
        return null;
    }

    public int getColumnIndex(Column column) {
        return -1;
    }
}

