/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import android.content.res.AssetFileDescriptor;
import android.media.MediaPlayer;
import android.media.MediaRecorder;
import android.os.Environment;
import android.util.Log;
import com.phonegap.AudioHandler;
import java.io.File;
import java.io.IOException;

public class AudioPlayer
implements MediaPlayer.OnCompletionListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnErrorListener {
    private static final String LOG_TAG = "AudioPlayer";
    public static int MEDIA_NONE = 0;
    public static int MEDIA_STARTING = 1;
    public static int MEDIA_RUNNING = 2;
    public static int MEDIA_PAUSED = 3;
    public static int MEDIA_STOPPED = 4;
    private static int MEDIA_STATE = 1;
    private static int MEDIA_DURATION = 2;
    private static int MEDIA_POSITION = 3;
    private static int MEDIA_ERROR = 9;
    private static int MEDIA_ERR_NONE_ACTIVE = 0;
    private static int MEDIA_ERR_ABORTED = 1;
    private static int MEDIA_ERR_NETWORK = 2;
    private static int MEDIA_ERR_DECODE = 3;
    private static int MEDIA_ERR_NONE_SUPPORTED = 4;
    private AudioHandler handler;
    private String id;
    private int state = MEDIA_NONE;
    private String audioFile = null;
    private float duration = -1.0f;
    private MediaRecorder recorder = null;
    private String tempFile = null;
    private MediaPlayer mPlayer = null;
    private boolean prepareOnly = false;

    public AudioPlayer(AudioHandler handler, String id) {
        this.handler = handler;
        this.id = id;
        this.tempFile = Environment.getExternalStorageDirectory().getAbsolutePath() + "/tmprecording.mp3";
    }

    public void destroy() {
        if (this.mPlayer != null) {
            if (this.state == MEDIA_RUNNING || this.state == MEDIA_PAUSED) {
                this.mPlayer.stop();
                this.setState(MEDIA_STOPPED);
            }
            this.mPlayer.release();
            this.mPlayer = null;
        }
        if (this.recorder != null) {
            this.stopRecording();
            this.recorder.release();
            this.recorder = null;
        }
    }

    public void startRecording(String file) {
        if (this.mPlayer != null) {
            Log.d((String)LOG_TAG, (String)"AudioPlayer Error: Can't record in play mode.");
            this.handler.sendJavascript("PhoneGap.Media.onStatus('" + this.id + "', " + MEDIA_ERROR + ", " + MEDIA_ERR_ABORTED + ");");
        } else if (this.recorder == null) {
            this.audioFile = file;
            this.recorder = new MediaRecorder();
            this.recorder.setAudioSource(1);
            this.recorder.setOutputFormat(0);
            this.recorder.setAudioEncoder(0);
            this.recorder.setOutputFile(this.tempFile);
            try {
                this.recorder.prepare();
                this.recorder.start();
                this.setState(MEDIA_RUNNING);
                return;
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.handler.sendJavascript("PhoneGap.Media.onStatus('" + this.id + "', " + MEDIA_ERROR + ", " + MEDIA_ERR_ABORTED + ");");
        } else {
            Log.d((String)LOG_TAG, (String)"AudioPlayer Error: Already recording.");
            this.handler.sendJavascript("PhoneGap.Media.onStatus('" + this.id + "', " + MEDIA_ERROR + ", " + MEDIA_ERR_ABORTED + ");");
        }
    }

    public void moveFile(String file) {
        File f = new File(this.tempFile);
        f.renameTo(new File("/sdcard/" + file));
    }

    public void stopRecording() {
        if (this.recorder != null) {
            try {
                if (this.state == MEDIA_RUNNING) {
                    this.recorder.stop();
                    this.setState(MEDIA_STOPPED);
                }
                this.moveFile(this.audioFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void startPlaying(String file) {
        block13: {
            if (this.recorder != null) {
                Log.d((String)LOG_TAG, (String)"AudioPlayer Error: Can't play in record mode.");
                this.handler.sendJavascript("PhoneGap.Media.onStatus('" + this.id + "', " + MEDIA_ERROR + ", " + MEDIA_ERR_ABORTED + ");");
            } else if (this.mPlayer == null || this.state == MEDIA_STOPPED) {
                try {
                    if (this.mPlayer != null) {
                        this.mPlayer.reset();
                    } else {
                        this.mPlayer = new MediaPlayer();
                    }
                    this.audioFile = file;
                    if (this.isStreaming(file)) {
                        this.mPlayer.setDataSource(file);
                        this.mPlayer.setAudioStreamType(3);
                        this.setState(MEDIA_STARTING);
                        this.mPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
                        this.mPlayer.prepareAsync();
                        break block13;
                    }
                    if (file.startsWith("/android_asset/")) {
                        String f = file.substring(15);
                        AssetFileDescriptor fd = this.handler.ctx.getBaseContext().getAssets().openFd(f);
                        this.mPlayer.setDataSource(fd.getFileDescriptor(), fd.getStartOffset(), fd.getLength());
                    } else {
                        this.mPlayer.setDataSource("/sdcard/" + file);
                    }
                    this.setState(MEDIA_STARTING);
                    this.mPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
                    this.mPlayer.prepare();
                    this.duration = this.getDurationInSeconds();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.handler.sendJavascript("PhoneGap.Media.onStatus('" + this.id + "', " + MEDIA_ERROR + ", " + MEDIA_ERR_ABORTED + ");");
                }
            } else if (this.state == MEDIA_PAUSED || this.state == MEDIA_STARTING) {
                this.mPlayer.start();
                this.setState(MEDIA_RUNNING);
            } else {
                Log.d((String)LOG_TAG, (String)("AudioPlayer Error: startPlaying() called during invalid state: " + this.state));
                this.handler.sendJavascript("PhoneGap.Media.onStatus('" + this.id + "', " + MEDIA_ERROR + ", " + MEDIA_ERR_ABORTED + ");");
            }
        }
    }

    public void seekToPlaying(int milliseconds) {
        if (this.mPlayer != null) {
            this.mPlayer.seekTo(milliseconds);
            Log.d((String)LOG_TAG, (String)"Send a onStatus update for the new seek");
            this.handler.sendJavascript("PhoneGap.Media.onStatus('" + this.id + "', " + MEDIA_POSITION + ", " + (float)milliseconds / 1000.0f + ");");
        }
    }

    public void pausePlaying() {
        if (this.state == MEDIA_RUNNING) {
            this.mPlayer.pause();
            this.setState(MEDIA_PAUSED);
        } else {
            Log.d((String)LOG_TAG, (String)("AudioPlayer Error: pausePlaying() called during invalid state: " + this.state));
            this.handler.sendJavascript("PhoneGap.Media.onStatus('" + this.id + "', " + MEDIA_ERROR + ", " + MEDIA_ERR_NONE_ACTIVE + ");");
        }
    }

    public void stopPlaying() {
        if (this.state == MEDIA_RUNNING || this.state == MEDIA_PAUSED) {
            this.mPlayer.stop();
            this.setState(MEDIA_STOPPED);
        } else {
            Log.d((String)LOG_TAG, (String)("AudioPlayer Error: stopPlaying() called during invalid state: " + this.state));
            this.handler.sendJavascript("PhoneGap.Media.onStatus('" + this.id + "', " + MEDIA_ERROR + ", " + MEDIA_ERR_NONE_ACTIVE + ");");
        }
    }

    public void onCompletion(MediaPlayer mPlayer) {
        this.setState(MEDIA_STOPPED);
    }

    public long getCurrentPosition() {
        if (this.state == MEDIA_RUNNING || this.state == MEDIA_PAUSED) {
            int curPos = this.mPlayer.getCurrentPosition();
            this.handler.sendJavascript("PhoneGap.Media.onStatus('" + this.id + "', " + MEDIA_POSITION + ", " + (float)curPos / 1000.0f + ");");
            return curPos;
        }
        return -1L;
    }

    public boolean isStreaming(String file) {
        return file.contains("http://") || file.contains("https://");
    }

    public float getDuration(String file) {
        if (this.recorder != null) {
            return -2.0f;
        }
        if (this.mPlayer != null) {
            return this.duration;
        }
        this.prepareOnly = true;
        this.startPlaying(file);
        return this.duration;
    }

    public void onPrepared(MediaPlayer mPlayer) {
        this.mPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        if (!this.prepareOnly) {
            this.mPlayer.start();
            this.setState(MEDIA_RUNNING);
        }
        this.duration = this.getDurationInSeconds();
        this.prepareOnly = false;
        this.handler.sendJavascript("PhoneGap.Media.onStatus('" + this.id + "', " + MEDIA_DURATION + "," + this.duration + ");");
    }

    private float getDurationInSeconds() {
        return (float)this.mPlayer.getDuration() / 1000.0f;
    }

    public boolean onError(MediaPlayer mPlayer, int arg1, int arg2) {
        Log.d((String)LOG_TAG, (String)("AudioPlayer.onError(" + arg1 + ", " + arg2 + ")"));
        this.mPlayer.stop();
        this.mPlayer.release();
        this.handler.sendJavascript("PhoneGap.Media.onStatus('" + this.id + "', " + MEDIA_ERROR + ", " + arg1 + ");");
        return false;
    }

    private void setState(int state) {
        if (this.state != state) {
            this.handler.sendJavascript("PhoneGap.Media.onStatus('" + this.id + "', " + MEDIA_STATE + ", " + state + ");");
        }
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    public void setVolume(float volume) {
        this.mPlayer.setVolume(volume, volume);
    }
}

