/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public class PRectangle
extends Rectangle2D.Float {
    private float p1x;
    private float p1y;
    private float p2x;
    private float p2y;

    public PRectangle(Point2D.Float float_, Point2D.Float float_2) {
        this.normalizeCoordinates(float_.x, float_.y, float_2.x, float_2.y);
        this.p1x = float_.x;
        this.p1y = float_.y;
        this.p2x = float_2.x;
        this.p2y = float_2.y;
    }

    private PRectangle(float f, float f2, float f3, float f4) {
        super(f, f2, f3, f4);
    }

    public PRectangle(Vector vector) throws IllegalArgumentException {
        if (vector == null || vector.size() < 4) {
            throw new IllegalArgumentException();
        }
        float f = ((Number)vector.elementAt(0)).floatValue();
        float f2 = ((Number)vector.elementAt(1)).floatValue();
        float f3 = ((Number)vector.elementAt(2)).floatValue();
        float f4 = ((Number)vector.elementAt(3)).floatValue();
        this.p1x = f;
        this.p1y = f2;
        this.p2x = f3;
        this.p2y = f4;
        this.normalizeCoordinates(f, f2, f3, f4);
    }

    public PRectangle createCartesianIntersection(PRectangle pRectangle) {
        PRectangle pRectangle2 = new PRectangle(pRectangle.x, pRectangle.y, pRectangle.width, pRectangle.height);
        float f = this.x > pRectangle2.x ? this.x : pRectangle2.x;
        float f2 = this.x + this.width > pRectangle2.x + pRectangle2.width ? pRectangle2.x + pRectangle2.width : this.x + this.width;
        float f3 = this.y - this.height < pRectangle2.y - pRectangle2.height ? pRectangle2.y - pRectangle2.height : this.y - this.height;
        float f4 = this.y > pRectangle2.y ? pRectangle2.y : this.y;
        pRectangle2.x = f;
        pRectangle2.y = f4;
        pRectangle2.width = f2 - f;
        pRectangle2.height = f4 - f3;
        if (pRectangle2.width < 0.0f || pRectangle2.height < 0.0f) {
            pRectangle2.height = 0.0f;
            pRectangle2.width = 0.0f;
            pRectangle2.y = 0.0f;
            pRectangle2.x = 0.0f;
        }
        return pRectangle2;
    }

    public Rectangle2D.Float getOriginalPoints() {
        return new Rectangle2D.Float(this.p1x, this.p1y, this.p2x, this.p2y);
    }

    public Rectangle2D.Float toJava2dCoordinates() {
        return new Rectangle2D.Float(this.x, this.y - this.height, this.width, this.height);
    }

    private void normalizeCoordinates(float f, float f2, float f3, float f4) {
        float f5 = f;
        float f6 = f2;
        float f7 = Math.abs(f3 - f);
        float f8 = Math.abs(f4 - f2);
        if (f > f3) {
            f5 = f3;
        }
        if (f2 < f4) {
            f6 = f4;
        }
        this.setRect(f5, f6, f7, f8);
    }
}

