/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.functions;

import java.util.Vector;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.functions.Function;

public class Function_3
extends Function {
    private float[] bounds;
    private float[] encode;
    private Function[] functions;

    Function_3(Dictionary dictionary) {
        super(dictionary);
        Vector vector;
        Vector vector2 = (Vector)dictionary.getObject("Bounds");
        if (vector2 != null) {
            this.bounds = new float[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                this.bounds[i] = ((Number)vector2.elementAt(i)).floatValue();
            }
        }
        if ((vector = (Vector)dictionary.getObject("Encode")) != null) {
            this.encode = new float[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                this.encode[i] = ((Number)vector.elementAt(i)).floatValue();
            }
        }
        Vector vector3 = (Vector)dictionary.getObject("Functions");
        if (vector != null) {
            this.functions = new Function[vector3.size()];
            for (int i = 0; i < vector3.size(); ++i) {
                this.functions[i] = Function.getFunction(dictionary.getLibrary(), vector3.get(i));
            }
        }
    }

    public float[] calculate(float[] fArray) {
        int n = this.functions.length;
        if (n == 1 && this.bounds.length == 0 && this.domain[0] <= fArray[0] && fArray[0] <= this.domain[1]) {
            return this.encode(fArray, this.functions[0], 0);
        }
        for (int i = 0; i < this.bounds.length; ++i) {
            if (i == 0 && this.domain[0] <= fArray[0] && fArray[0] < this.bounds[i]) {
                return this.encode(fArray, this.functions[i], i);
            }
            if (i == n - 2 && this.bounds[i] <= fArray[0] && fArray[0] <= this.domain[1]) {
                return this.encode(fArray, this.functions[n - 1], n - 1);
            }
            if (!(this.bounds[i] <= fArray[0]) || !(fArray[0] < this.bounds[i + 1])) continue;
            return this.encode(fArray, this.functions[i], i);
        }
        return null;
    }

    private float[] encode(float[] fArray, Function function, int n) {
        int n2 = this.functions.length;
        if (n <= 0 && n < n2 && this.bounds.length > 0) {
            float f = n - 1 == -1 ? this.domain[0] : this.bounds[n - 1];
            float f2 = n == n2 - 1 ? this.domain[1] : this.bounds[n];
            if (n2 - 2 < this.bounds.length && this.bounds[n2 - 2] == this.domain[1]) {
                fArray[0] = this.encode[2 * n];
            }
            fArray[0] = this.interpolate(fArray[0], f, f2, this.encode[2 * n], this.encode[2 * n + 1]);
            fArray = function.calculate(fArray);
        } else {
            fArray[0] = this.interpolate(fArray[0], this.domain[0], this.domain[1], this.encode[2 * n], this.encode[2 * n + 1]);
            fArray = function.calculate(fArray);
        }
        return this.validateAgainstRange(fArray);
    }

    private float[] validateAgainstRange(float[] fArray) {
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            if (this.range != null && fArray[i] < this.range[2 * i]) {
                fArray[i] = this.range[2 * i];
                continue;
            }
            if (this.range != null && fArray[i] > this.range[2 * i + 1]) {
                fArray[i] = this.range[2 * i + 1];
                continue;
            }
            if (!(fArray[i] < 0.0f)) continue;
            fArray[i] = 0.0f;
        }
        return fArray;
    }
}

