// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_STRUCTURE_H
#define _GSTREAMERMM_STRUCTURE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/clock.h>
#include <gstreamermm/enums.h>
#include <gstreamermm/value.h>
#include <glibmm/date.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _GstStructure GstStructure; }
#endif

namespace Gst
{

/** A generic class containing fields of names and values.
 * A Gst::Structure is a collection of key/value pairs. The keys are expressed
 * as GQuarks and the values can be of any GType.
 *
 * In addition to the key/value pairs, a Gst::Structure also has a name. The
 * name starts with a letter and can be folled by letters, numbers and any of
 * "/-_.:".
 *
 * Gst::Structure is used by various GStreamer subsystems to store information
 * in a flexible and extensible way. A Gst::Structure does not have a refcount
 * because it usually is part of a higher level object such as Gst::Caps. It
 * provides a means to enforce mutability using the refcount of the parent.
 *
 * Last reviewed on 2007-10-16 (0.10.15)
 */
class Structure
{
 public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Structure CppObjectType;
  typedef GstStructure BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  Structure();

  explicit Structure(GstStructure* gobject, bool make_a_copy = true);

  Structure(const Structure& other);
  Structure& operator=(const Structure& other);

  ~Structure();

  void swap(Structure& other);

  ///Provides access to the underlying C instance.
  GstStructure*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const GstStructure* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  GstStructure* gobj_copy() const;

protected:
  GstStructure* gobject_;

private:

  
public:
  /** Creates a Structure with the given @a name.
   * You should then use set_field() to set field values.
   */
  explicit Structure(const Glib::ustring& name);

  /** Creates a Gst::Structure from a string representation.
   *
   * @param the_string A string representation of a Gst::Structure. See to_string().
   * @returns A Structure. This will be invalid (see operator=) when the string 
   * could not be parsed.
   */
  static Structure create_from_string(const Glib::ustring& the_string);
  

  /** Use this to discover if the Structure is a valid object.
   */
  operator bool() const;

  
  /** Get the name of @a structure as a string.
   * @return The name of the structure.
   */
  Glib::ustring get_name() const;
  
  /** Checks if the structure has the given name
   * @param name Structure name to check for.
   * @return <tt>true</tt> if @a name matches the name of the structure.
   */
  bool has_name(const Glib::ustring& name) const;
  
  /** Sets the name of the structure to the given @a name.  The string
   * provided is copied before being used. It must not be empty, start with a
   * letter and can be followed by letters, numbers and any of "/-_.:".
   * @param name The new name of the structure.
   */
  void set_name(const Glib::ustring& name);
  
  /** Get the name of @a structure as a GQuark.
   * @return The quark representing the name of the structure.
   */
  Glib::QueryQuark get_name_id() const;

  /** Get the value of the field with name @a fieldname.
   *
   * @param fieldname The name of the field to get.
   * @param value The Value class in which to store the value.
   */
  void get_field(const Glib::ustring& fieldname, Glib::ValueBase& value) const;

  // These are ignored because they are useful in the C API but are either
  // variable argument functions or their functionality is already provided.
  

  /** Sets the field with name @a fieldname to value. If the field does not
   * exist, it is created. If the field exists, the previous value is replaced
   * and freed.
   *
   * @param fieldname The name of the field to set.
   * @param value The value to set the field to.
   */
  void set_field(const Glib::ustring& fieldname, const Glib::ValueBase& value);
  

  /** Sets the field with name @a fieldname to the boolean @a value. If the
   * field does not exist, it is created. If the field exists, the previous
   * value is replaced and freed.
   *
   * @param fieldname The name of the field to set.
   * @param value The value to set the field to.
   */
  void set_field(const Glib::ustring& fieldname, bool value);

  /** Sets the field with name @a fieldname to the int @a value. If the
   * field does not exist, it is created. If the field exists, the previous
   * value is replaced and freed.
   *
   * @param fieldname The name of the field to set.
   * @param value The value to set the field to.
   */
  void set_field(const Glib::ustring& fieldname, int value);

  /** Sets the field with name @a fieldname to the guint @a value. If the
   * field does not exist, it is created. If the field exists, the previous
   * value is replaced and freed.
   *
   * @param fieldname The name of the field to set.
   * @param value The value to set the field to.
   */
  void set_field(const Glib::ustring& fieldname, guint value);

  /** Sets the field with name @a fieldname to the Gst::Fourcc @a value. If
   * the field does not exist, it is created. If the field exists, the previous
   * value is replaced and freed. Please note that when setting fields to
   * special gstreamermm types such as Gst::Fourcc and Gst::Fraction and
   * Glib::Date they are converted to the GStreamer GTypes and thus when
   * attempting to get these fields back as GValues, they will have the
   * GStreamer GType.
   *
   * @param fieldname The name of the field to set.
   * @param value The value to set the field to.
   */
  void set_field(const Glib::ustring& fieldname, const Fourcc& value);

  /** Sets the field with name @a fieldname to the double @a value. If the
   * field does not exist, it is created. If the field exists, the previous
   * value is replaced and freed.
   *
   * @param fieldname The name of the field to set.
   * @param value The value to set the field to.
   */
  void set_field(const Glib::ustring& fieldname, double value);

  //We use std::string, because the encoding is unknown. murrayc
  /** Sets the field with name @a fieldname to the std::string @a value. If
   * the field does not exist, it is created. If the field exists, the previous
   * value is replaced and freed.
   *
   * @param fieldname The name of the field to set.
   * @param value The value to set the field to.
   */
  void set_field(const Glib::ustring& fieldname, const std::string& value);

  /** Sets the field with name @a fieldname to the string constant @a value. If
   * the field does not exist, it is created. If the field exists, the previous
   * value is replaced and freed.
   *
   * @param fieldname The name of the field to set.
   * @param value The value to set the field to.
   */
  void set_field(const Glib::ustring& fieldname, const char* value);

  /** Sets the field with name @a fieldname to the Glib::Date @a value. If
   * the field does not exist, it is created. If the field exists, the previous
   * value is replaced and freed. Please note that when setting fields to
   * special types such as Gst::Fourcc and Gst::Fraction and Glib::Date they
   * are converted to the GStreamer GTypes and thus when attempting to get
   * these fields back as GValues, they will have the GStreamer GType.
   *
   * @param fieldname The name of the field to set.
   * @param value The value to set the field to.
   */
  void set_field(const Glib::ustring& fieldname, const Glib::Date& value);

  /** Sets the field with name @a fieldname to the Gst::ClockTime @a value. If
   * the field does not exist, it is created. If the field exists, the previous
   * value is replaced and freed.
   *
   * @param fieldname The name of the field to set.
   * @param value The value to set the field to.
   */
  void set_field(const Glib::ustring& fieldname, const ClockTime& value);

  /** Sets the field with name @a fieldname to the value @a value of the enum
   * type @a enum_type. If the field does not exist, it is created. If the
   * field exists, the previous value is replaced and freed.  Caller is
   * responsible for making sure that @a value is a valid @a enumtype.  A call
   * to this method would look like so:
   * @code
   * ...
   * structure.set_field("state", Glib::Value<Gst::State>::value_type(),
   * Gst::STATE_PAUSED);
   * ...
   * @endcode
   *
   * @param fieldname The name of the field to set.
   * @param enumtype The enum GType that @a value should be treated as.
   * @param value The value to set the field to.
   */
  void set_field(const Glib::ustring& fieldname, GType enumtype, int value);

  /** Sets the field with name @a fieldname to the Gst::Fraction @a value. If
   * the field does not exist, it is created. If the field exists, the previous
   * value is replaced and freed. Please note that when setting fields to
   * special types such as Gst::Fourcc and Gst::Fraction and Glib::Date they
   * are converted to the GStreamer GTypes and thus when attempting to get
   * these fields back as GValues, they will have the GStreamer GType.
   *
   * @param fieldname The name of the field to set.
   * @param value The value to set the field to.
   */
  void set_field(const Glib::ustring& fieldname, const Gst::Fraction& value);

  /** Sets the field with name @a fieldname field to the Gst::IntRange @a
   * value. If the field does not exist, it is created. If the field exists,
   * the previous value is replaced and freed. Please note that when setting
   * fields to special types such as Gst::Fourcc and Gst::Fraction and
   * Glib::Date they are converted to the GStreamer GTypes and thus when
   * attempting to get these fields back as GValues, they will have the
   * GStreamer GType.
   *
   * @param fieldname The name of the field to set.
   * @param value The value to set the field to.
   */
  void set_field(const Glib::ustring& fieldname, const Gst::IntRange& value);

  /** Sets the field with name @a fieldname field to the Gst::DoubleRange @a
   * value. If the field does not exist, it is created. If the field exists,
   * the previous value is replaced and freed. Please note that when setting
   * fields to special types such as Gst::Fourcc and Gst::Fraction and
   * Glib::Date they are converted to the GStreamer GTypes and thus when
   * attempting to get these fields back as GValues, they will have the
   * GStreamer GType.
   *
   * @param fieldname The name of the field to set.
   * @param value The value to set the field to.
   */
  void set_field(const Glib::ustring& fieldname, const Gst::DoubleRange& value);

  /** Sets the field with name @a fieldname field to the Gst::FractionRange @a
   * value. If the field does not exist, it is created. If the field exists,
   * the previous value is replaced and freed. Please note that when setting
   * fields to special types such as Gst::Fourcc and Gst::Fraction and
   * Glib::Date they are converted to the GStreamer GTypes and thus when
   * attempting to get these fields back as GValues, they will have the
   * GStreamer GType.
   *
   * @param fieldname The name of the field to set.
   * @param value The value to set the field to.
   */
  void set_field(const Glib::ustring& fieldname, const Gst::FractionRange& value);

  // These take ownership of the GValue so they are not wrapped.
  

  /** Removes the field with name @a fieldname. If the field with the given
   * name does not exist, the structure is unchanged.
   *
   * @param fieldname The name of the field to remove.
   */
  void remove_field(const Glib::ustring& fieldname);
  

  /** Removes all fields in a GstStructure.
   */
  void remove_all_fields();
  
  /** Finds the field with the given name, and returns the type of the
   * value it contains.  If the field is not found, G_TYPE_INVALID is
   * returned.
   * @param fieldname The name of the field.
   * @return The Value of the field.
   */
  GType get_field_type(const Glib::ustring& fieldname) const;

  /** For example,
   * bool on_foreach(const Glib::ustring& id, const Glib::ValueBase& value);.
   * The foreach function should return true if the foreach operation should
   * continue, or false if the operation should stop with false.
   */
  typedef sigc::slot<bool, const Glib::ustring&, const Glib::ValueBase&> SlotForeach;

  /** Calls the provided slot once for each field in the Gst::Structure. The
   * slot must not modify the fields. See also map_in_place().
   *
   * @param slot A slot to call for each field.
   * @return true if the supplied slot returns true For each of the fields,
   * false otherwise.
   */
  bool foreach(const SlotForeach& slot);
  

  /** Get the number of fields in the structure.
   * @return The number of fields in the structure.
   */
  int size() const;

  
  /** Check if @a structure contains a field named @a fieldname.
   * @param fieldname The name of a field.
   * @return <tt>true</tt> if the structure contains a field with the given name.
   */
  bool has_field(const Glib::ustring& fieldname) const;
  

  /** Check if @a structure contains a field named @a fieldname and with GType @a type.
   * @param fieldname The name of a field.
   * @param type The type of a value.
   * @return <tt>true</tt> if the structure contains a field with the given name and type.
   */
  bool has_field(const Glib::ustring& fieldname, GType type) const;
  

  /** Gets the value of field @a fieldname into boolean @a value.
   * The caller is responsible for making sure the field exists and has the
   * correct type.
   *
   * @param fieldname The name of a field.
   * @param value An output parameter that will be set with the value.
   * @return true if @a value could be set correctly. If there was no field
   * with @a fieldname or the existing field did not contain a boolean, this
   * function returns false.
   */
  bool get_field(const Glib::ustring& fieldname, bool& value) const;
  

  /** Gets the value of field @a fieldname into integer @a value.
   * The caller is responsible for making sure the field exists and has the
   * correct type.
   *
   * @param fieldname The name of a field.
   * @param value An output parameter that will be set with the value.
   * @return true if @a value could be set correctly. If there was no field
   * with @a fieldname or the existing field did not contain an int, this
   * function returns false.
   */
  bool get_field(const Glib::ustring& fieldname, int& value) const;
  

  /** Gets the value of field @a fieldname into guint @a value.
   * The caller is responsible for making sure the field exists and has the
   * correct type.
   *
   * @param fieldname The name of a field.
   * @param value An output parameter that will be set with the value.
   * @return true if @a value could be set correctly. If there was no field
   * with @a fieldname or the existing field did not contain an guint, this
   * function returns false.
   */
  bool get_field(const Glib::ustring& fieldname, guint& value) const;
  

  /** Gets the value of field @a fieldname into Gst::Fourcc @a value.
   * The caller is responsible for making sure the field exists and has the
   * correct type.
   *
   * @param fieldname The name of a field.
   * @param value An output parameter that will be set with the value.
   * @return true if @a value could be set correctly. If there was no field
   * with @a fieldname or the existing field did not contain a Gst::Fourcc,
   * this function returns false.
   */
  bool get_field(const Glib::ustring& fieldname, Fourcc& value) const;
  

  /** Gets the value of field @a fieldname into double @a value.
   * The caller is responsible for making sure the field exists and has the
   * correct type.
   *
   * @param fieldname The name of a field.
   * @param value An output parameter that will be set with the value.
   * @return true if @a value could be set correctly. If there was no field
   * with @a fieldname or the existing field did not contain a double, this
   * function returns false.
   */
  bool get_field(const Glib::ustring& fieldname, double& value) const;
  

  /** Gets the value of field @a fieldname into Glib::ustring @a value.
   * The caller is responsible for making sure the field exists and has the
   * correct type.
   *
   * @param fieldname The name of a field.
   * @param value An output parameter that will be set with the value.
   * @return true if @a value could be set correctly. If there was no field
   * with @a fieldname or the existing field did not contain a string, this
   * function returns false.
   */
  bool get_field(const Glib::ustring& fieldname, Glib::ustring& value) const;

  /** Gets the value of field @a fieldname into std::string @a value.
   * The caller is responsible for making sure the field exists and has the
   * correct type.
   *
   * @param fieldname The name of a field.
   * @param value An output parameter that will be set with the value.
   * @return true if @a value could be set correctly. If there was no field
   * with @a fieldname or the existing field did not contain a string, this
   * function returns false.
   */
  bool get_field(const Glib::ustring& fieldname, std::string& value) const;
  

  /** Gets the value of field @a fieldname into Glib::Date @a value.
   * The caller is responsible for making sure the field exists and has the
   * correct type.
   *
   * @param fieldname The name of a field.
   * @param date The Glib::Date to set.
   * @return true if @a value could be set correctly. If there was no field
   * with @a fieldname or the existing field did not contain a Glib::Date, this
   * function returns false.
   */
  bool get_field(const Glib::ustring& fieldname, Glib::Date& value) const;
  

  /** Gets the value of field @a fieldname into Gst::ClockTime @a value.
   * The caller is responsible for making sure the field exists and has the
   * correct type.
   *
   * @param fieldname The name of a field.
   * @param value An output parameter that will be set with the value.
   * @return true if @a value could be set correctly. If there was no field
   * with @a fieldname or the existing field did not contain a Gst::ClockTime,
   * this function returns false.
   */
  bool get_field(const Glib::ustring& fieldname, ClockTime& value) const;
  

  /** Gets the value of field @a fieldname with GType enum type @a enumtype
   * into integer @a value.  Caller is responsible for making sure the
   * field exists and has the correct type.  A call to this method would look
   * like so:
   * @code
   * ...
   * int state;
   * structure.get_field("state", Glib::Value<Gst::State>::value_type(),
   * state);
   * ...
   * @endcode
   *
   * @param fieldname The name of a field.
   * @param enumtype The enum GType of the field.
   * @param value An output parameter that will be set with the value.
   * @return true if @a value could be set correctly. If there was no field
   * with @a fieldname or the existing field did not contain an enum, this
   * function returns false.
   */
  bool get_field(const Glib::ustring& fieldname, GType enumtype, int& value) const;
  

  /** Gets the value of field @a fieldname into Gst::Fraction @a value.
   * The caller is responsible for making sure the field exists and has the
   * correct type.
   *
   * @param fieldname The name of a field.
   * @param value The Gst::Fraction to set.
   * @return true if @a value could be set correctly. If there was no field
   * with @a fieldname or the existing field did not contain a Gst::Fraction,
   * this function returns false.
   */
  bool get_field(const Glib::ustring& fieldname, Gst::Fraction& value) const;
  

  /** Gets the value of field @a fieldname into Gst::IntRange @a value.
   * The caller is responsible for making sure the field exists and has the
   * correct type.
   *
   * @param fieldname The name of a field.
   * @param value The Gst::IntRange to set.
   * @return true if @a value could be set correctly. If there was no field
   * with @a fieldname or the existing field did not contain a Gst::IntRange,
   * this function returns false.
   */
  bool get_field(const Glib::ustring& fieldname, Gst::IntRange& value) const;

  /** Gets the value of field @a fieldname into Gst::DoubleRange @a value.
   * The caller is responsible for making sure the field exists and has the
   * correct type.
   *
   * @param fieldname The name of a field.
   * @param value The Gst::DoubleRange to set.
   * @return true if @a value could be set correctly. If there was no field
   * with @a fieldname or the existing field did not contain a
   * Gst::DoubleRange, this function returns false.
   */
  bool get_field(const Glib::ustring& fieldname, Gst::DoubleRange& value) const;

  /** Gets the value of field @a fieldname into Gst::FractionRange @a value.
   * The caller is responsible for making sure the field exists and has the
   * correct type.
   *
   * @param fieldname The name of a field.
   * @param value The Gst::FractionRange to set.
   * @return true if @a value could be set correctly. If there was no field
   * with @a fieldname or the existing field did not contain a
   * Gst::FractionRange, this function returns false.
   */
  bool get_field(const Glib::ustring& fieldname, Gst::FractionRange& value) const;

  /** For example,
   * bool on_map(const Glib::ustring& id, Glib::ValueBase& value);.
   * The map function should return true if the map operation should continue,
   * or false if the operation should stop with false.
   */
  typedef sigc::slot<bool, const Glib::ustring&, Glib::ValueBase&> SlotMap;

  /** Calls the provided slot once for each field in the Gst::Structure. In
   * contrast to foreach(), the function may modify but not delete the fields.
   * The structure must be mutable.
   *
   * @param slot A slot to call for each field.
   * @return true if the supplied slot returns true For each of the fields,
   * false otherwise.
   */
  bool map_in_place(const SlotMap& slot);
  

  /** Get the name of the given field number, counting from 0 onwards.
   * @param index The index to get the name of.
   * @return The name of the given field number.
   */
  Glib::ustring get_nth_field_name(guint index) const;
  
  /** Converts @a structure to a human-readable string representation.
   * 
   * For debugging purposes its easier to do something like this:
   * 
   * [C example ellipted]
   * This prints the structure in human readble form.
   * 
   * Free-function: g_free
   * @return (transfer full)L a pointer to string allocated by Glib::malloc().
   * Glib::free() after usage.
   */
  Glib::ustring to_string() const;
  
  /** Fixates a Gst::Structure by changing the given field to the nearest
   * integer to @a target that is a subset of the existing field.
   * @param field_name A field in @a structure.
   * @param target The target value of the fixation.
   * @return <tt>true</tt> if the structure could be fixated.
   */
  bool fixate_field_nearest_int(const Glib::ustring& name, int target);
  
  /** Fixates a Gst::Structure by changing the given field to the nearest
   * double to @a target that is a subset of the existing field.
   * @param field_name A field in @a structure.
   * @param target The target value of the fixation.
   * @return <tt>true</tt> if the structure could be fixated.
   */
  bool fixate_field_nearest_double(const Glib::ustring& name, double target);

  /** Fixates a Gst::Structure by changing the given field to the nearest
   * fraction to given Gst::Fraction that is a subset of the existing field.
   *
   * @param field_name A field in structure.
   * @param target The target value of the fixation.
   * @return true If the structure could be fixated.
   */
  bool fixate_nearest_fraction(const Glib::ustring& name, const Gst::Fraction& target);
  

  /** Fixates a Gst::Structure by changing the given @a field_name field to the given
   *  @a target boolean if that field is not fixed yet.
   * @param field_name A field in @a structure.
   * @param target The target value of the fixation.
   * @return <tt>true</tt> if the structure could be fixated.
   */
  bool fixate_field_boolean(const Glib::ustring& name, bool target);

  //Variable argument functions are ignored.
  

};

} //namespace Gst


namespace Gst
{

/** @relates Gst::Structure
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(Structure& lhs, Structure& rhs)
  { lhs.swap(rhs); }

} // namespace Gst

namespace Glib
{

/** A Glib::wrap() method for this object.
 * 
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gst::Structure
 */
Gst::Structure wrap(GstStructure* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gst::Structure> : public Glib::Value_Boxed<Gst::Structure>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _GSTREAMERMM_STRUCTURE_H */

