# 
#  Copyright (c) 1994-1998 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
#
#
# $Id: options.t,v 1.1.1.1 1998/01/04 22:47:29 abm Exp $
#

# Initialize options for tkhylafax. Any command line option overrides
# values in the resource database.
#

proc setOptions { args } {

    global Th_Info
    global Th_Pref

    # First initialize options array to contain application default values.
    setDefaultOptions Th_Pref

    # Collect any command line arguments and override any previous values. 
    foreach name {faxResolution notifyOnCompletion notifyOnRetry commentLines
		initiatePoll coverPage editorCmd coverPageDirs autoFrom} {

        # Next check the resource database
        set option [getPreference $name]
        if {$option != ""} {
	   set Th_Pref($name) $option 
        }

        # Finally check command line arguments, these have highest priority
        set option [getOption $name]
        if {$option != ""} {
	   set Th_Pref($name) $option 
        }
        set Th_Info($name) {}
        switch -exact -- $name faxResolution {
	   if {$Th_Pref($name) == "high"} {
	       set Th_Info($name) { -m }
	   } else {
	       set Th_Info($name) { -l }
	   }
        } notifyOnCompletion {
	   if {$Th_Pref($name)} {
	       set Th_Info($name) { -D }
	   }
        } notifyOnRetry {
	   if {$Th_Pref($name)} {
	       set Th_Info($name) { -R }
	   }
        } initiatePoll {
	   if {$Th_Pref($name)} {
	       set Th_Info($name) { -p }
	   }
        } coverPage {
	   if {! $Th_Pref($name)} {
	       set Th_Info($name) { -n }
	   }
        } editorCmd - commentLines - autoFrom {
	   set Th_Info($name) $Th_Pref($name) 
        } coverPageDirs {
	   if {$Th_Pref($name) != ""} {
	       set Th_Info(coverPages) [getCoverPages $Th_Pref($name)]
	   }
        } default {}
    }
}

#
# Set the application default options in case 
# command line values and resource database values
# cannot be found.
#

proc setDefaultOptions { arrayname } {

    upvar $arrayname var
    set var(faxResolution) high
    set var(notifyOnCompletion) 1
    set var(notifyOnRetry) 1
    set var(initiatePoll) 0
    set var(coverPage) 1
    set var(autoFrom) 1
    set var(editorCmd) {xterm -e vi}
    set var(commentLines) 4
    set var(iconBitmap) tkhylafax.xbm
    set var(coverPageDirs) {}
}

#
# Return argument to supplied command line option.
#

proc getOption { name } {

    global argc argv

    for {set x 0} {$x<$argc} {incr x} {
        set opt [lindex $argv $x]
        if {$opt == "-$name"} {
            incr x
	    set value [lindex $argv $x]
	    # Warp booleans to 0 or 1
            switch -exact -- $value {
	       0 -
	       1		{ # ok as is }
	       yes -
	       Yes -
	       YES -
	       true -
	       True -
	       TRUE	{set value 1}
	       no -
	       No -
	       NO -
	       false -
	       False - 
	       FALSE	{set value 0}
	       default	{}
	   }
	   return $value
        }
    }
    return {}
}


#
# Make a list of all possible cover pages.
#

proc getCoverPages { coverpath } {

    set l {}
    set dirs [split $coverpath ":"]
    foreach d $dirs {
	if {![file isdir $d] || ![file readable $d]} {
	    continue
	}
	set files [exec ls $d]
	foreach f $files {
	    if {[isPostscriptFile $d/$f] > 0} {
		lappend l $d/$f
	    }
	}
    }
    return $l
}

proc isPostscriptFile { fname } {
    # File exists.
    if {![file exists $fname]} {
        return -1	
    }

    # File is plain.
    if {![file isfile $fname]} {
        return -2 
    }
 
    # Open file.
    set in [open $fname {RDONLY}] 
 
    # The file is opened now. Read its first line and close the file.
    if {[gets $in ln] < 0} {
	# Can't read file.
	close $in
        return -3
    }

    # Test the first line to see if this is a Postscript file.
    if {[regexp {^%!} $ln]} {
	# OK, this is a Postscript file,
	close $in
	return 1
    }
 
    # No, this is not a Postscript file.
    return 0
}
