<?php
	/**
	 * Rules Module
	 */
	class RulesListModule extends ListModule
	{	
		/**
		 * Constructor
		 * @param int $id unique id.
		 * @param array $data list of all actions.
		 */
		function RulesListModule($id, $data)
		{
			$this->properties = $GLOBALS["properties"]->getRulesProperties();

			parent::ListModule($id, $data, array());
		}
		
		/**
		 * Executes all the actions in the $data variable.
		 * @return boolean true on success of false on fialure.
		 */
		function execute()
		{
			foreach($this->data as $actionType => $action)
			{
				try {
					switch($actionType) {
						case 'list':
							$store = $this->getActionStore($action);
						
							$rules = $this->ruleList($store, $action);
							
							if($rules) {
								$storeProps = mapi_msgstore_getprops($store, array(PR_IPM_WASTEBASKET_ENTRYID));
								$wastebasket_entryid = $storeProps[PR_IPM_WASTEBASKET_ENTRYID];
								$rules["wastebasket_entryid"] = bin2hex($wastebasket_entryid);

								$this->addActionData("list", $rules);
								$GLOBALS["bus"]->addData($this->getResponseData());
							};
							break;
						case 'setRules':
							$store = $this->getActionStore($action);

							if (isset($action["rules"])){
								$this->setRules($store, $action["rules"]);
							}
							break;
						default:
							$this->handleUnknownActionType($actionType);
					}
				} catch (MAPIException $e) {
					$this->processException($e, $actionType);
				}
			}
		}
		
		function ruleList($store, $action)
		{
			$rules = $GLOBALS["operations"]->getRules($store, $this->properties);
			
			$data["item"] = $rules;
			
			return $data;
		}
		
		function setRules($store, $rules)
		{
			$result = $GLOBALS["operations"]->updateRules($store, $rules, $this->properties);
		}
	}
?>
