/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.pentaho.di.core.logging.LogWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolverUtil<T> {
    private static final LogWriter log = LogWriter.getInstance();
    private Set<Class<? extends T>> matches = new HashSet<Class<? extends T>>();
    private ClassLoader classloader;

    public int size() {
        return this.matches.size();
    }

    public Set<Class<? extends T>> getClasses() {
        return this.matches;
    }

    public ClassLoader getClassLoader() {
        return this.classloader == null ? Thread.currentThread().getContextClassLoader() : this.classloader;
    }

    public void setClassLoader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public void findImplementations(Class<?> parent, String ... packageNames) {
        if (packageNames == null) {
            return;
        }
        IsA test = new IsA(parent);
        for (String pkg : packageNames) {
            this.findInPackage(pkg, test);
        }
    }

    public void findSuffix(String suffix, String ... packageNames) {
        if (packageNames == null) {
            return;
        }
        NameEndsWith test = new NameEndsWith(suffix);
        for (String pkg : packageNames) {
            this.findInPackage(pkg, test);
        }
    }

    public void findAnnotated(Class<? extends Annotation> annotation, String ... packageNames) {
        if (packageNames == null) {
            return;
        }
        AnnotatedWith test = new AnnotatedWith(annotation);
        for (String pkg : packageNames) {
            this.findInPackage(pkg, test);
        }
    }

    public void find(Test[] test, String ... packageNames) {
        if (packageNames == null) {
            return;
        }
        for (String pkg : packageNames) {
            this.findInPackage(pkg, test);
        }
    }

    public void find(Test test, String ... packageNames) {
        this.find(new Test[]{test}, packageNames);
    }

    public void findInPackage(String packageName, Test ... tests) {
        Enumeration<URL> urls;
        packageName = packageName.replace('.', '/');
        ClassLoader loader = this.getClassLoader();
        try {
            urls = loader.getResources(packageName);
        }
        catch (IOException ioe) {
            log.logError(this.toString(), "Could not read package: " + packageName, ioe);
            return;
        }
        while (urls.hasMoreElements()) {
            try {
                String urlPath;
                URL eurl = urls.nextElement();
                String urlVal = eurl.toString();
                if (urlVal.indexOf(" ") >= 0) {
                    urlVal = urlVal.replaceAll(" ", "%20");
                    eurl = new URL(urlVal);
                }
                if ((urlPath = eurl.toURI().toString()).startsWith("zip:")) {
                    if (!(urlPath = urlPath.substring(4)).startsWith("file:")) {
                        urlPath = "file:" + urlPath;
                    }
                    eurl = new URL(urlPath);
                }
                if (urlPath.indexOf(33) > 0) {
                    if ((urlPath = urlPath.substring(0, urlPath.indexOf(33))).startsWith("jar:")) {
                        urlPath = urlPath.substring(4);
                    }
                    eurl = new URL(urlPath);
                }
                log.logDetailed(this.toString(), "Scanning for classes in [" + urlPath + "] matching criteria: " + tests, new Object[0]);
                File file = new File(URLDecoder.decode(eurl.getFile(), "UTF-8"));
                if (file.exists() && file.isDirectory()) {
                    this.loadImplementationsInDirectory(packageName, file, tests);
                    continue;
                }
                this.loadImplementationsInJar(packageName, eurl, tests);
            }
            catch (IOException e) {
                e.printStackTrace();
                log.logError(this.toString(), "could not read entries", e);
            }
            catch (URISyntaxException se) {
                log.logError(this.toString(), "could not read entries", se);
            }
        }
    }

    private void loadImplementationsInDirectory(String parent, File location, Test ... tests) {
        File[] files = location.listFiles();
        StringBuilder builder = null;
        for (File file : files) {
            String packageOrClass;
            builder = new StringBuilder(100);
            builder.append(parent).append("/").append(file.getName());
            String string = packageOrClass = parent == null ? file.getName() : builder.toString();
            if (file.isDirectory()) {
                this.loadImplementationsInDirectory(packageOrClass, file, tests);
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            this.addIfMatching(packageOrClass, tests);
        }
    }

    public void loadImplementationsInJar(String parent, URL jarfile, Test ... tests) {
        try {
            JarEntry entry;
            JarInputStream jarStream = new JarInputStream(jarfile.openStream());
            while ((entry = jarStream.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (entry.isDirectory() || !name.startsWith(parent) || !name.endsWith(".class")) continue;
                this.addIfMatching(name, tests);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            log.logError(this.toString(), "Could not search jar file \\'" + jarfile + "\\' for classes matching criteria: " + tests + " due to an IOException", ioe);
        }
    }

    protected void addIfMatching(String fqn, Test ... tests) {
        try {
            String externalName = fqn.substring(0, fqn.indexOf(46)).replace('/', '.');
            ClassLoader loader = this.getClassLoader();
            Class<?> type = loader.loadClass(externalName);
            for (Test test : tests) {
                if (log.isDebug()) {
                    log.logDebug(this.toString(), "Checking to see if class " + externalName + " matches criteria [" + test + "]", new Object[0]);
                }
                if (!test.matches(type)) continue;
                this.matches.add(type);
            }
        }
        catch (Throwable t) {
            log.logDetailed(this.toString(), "Could not examine class \\'" + fqn + "\\' due to a " + t.getClass().getName() + " with message: " + t.getMessage(), new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotatedWith
    implements Test {
        private Class<? extends Annotation> annotation;

        public AnnotatedWith(Class<? extends Annotation> annotation) {
            this.annotation = annotation;
        }

        @Override
        public boolean matches(Class<?> type) {
            return type != null && type.isAnnotationPresent(this.annotation);
        }

        public String toString() {
            return "annotated with @" + this.annotation.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NameEndsWith
    implements Test {
        private String suffix;

        public NameEndsWith(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public boolean matches(Class<?> type) {
            return type != null && type.getName().endsWith(this.suffix);
        }

        public String toString() {
            return "ends with the suffix " + this.suffix;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IsA
    implements Test {
        private Class<?> parent;

        public IsA(Class<?> parentType) {
            this.parent = parentType;
        }

        @Override
        public boolean matches(Class<?> type) {
            return type != null && this.parent.isAssignableFrom(type);
        }

        public String toString() {
            return "is assignable to " + this.parent.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Test {
        public boolean matches(Class<?> var1);
    }
}

