/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.exceloutput;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.exceloutput.ExcelField;
import org.pentaho.di.trans.steps.exceloutput.ExcelOutput;
import org.pentaho.di.trans.steps.exceloutput.ExcelOutputData;
import org.pentaho.di.trans.steps.exceloutput.Messages;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelOutputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String fileName;
    private String extension;
    private String password;
    private boolean headerEnabled;
    private boolean footerEnabled;
    private int splitEvery;
    private boolean stepNrInFilename;
    private boolean dateInFilename;
    private boolean addToResultFilenames;
    private boolean protectsheet;
    private boolean timeInFilename;
    private boolean templateEnabled;
    private String templateFileName;
    private boolean templateAppend;
    private String sheetname;
    private ExcelField[] outputFields;
    private String encoding;
    private String newline;
    private boolean append;
    private boolean doNotOpenNewFileInit;
    private boolean SpecifyFormat;
    private String date_time_format;
    private boolean autosizecolums;

    public boolean isDateInFilename() {
        return this.dateInFilename;
    }

    public void setDateInFilename(boolean dateInFilename) {
        this.dateInFilename = dateInFilename;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSheetname() {
        return this.sheetname;
    }

    public void setSheetname(String sheetname) {
        this.sheetname = sheetname;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isFooterEnabled() {
        return this.footerEnabled;
    }

    public void setFooterEnabled(boolean footer) {
        this.footerEnabled = footer;
    }

    public boolean isAutoSizeColums() {
        return this.autosizecolums;
    }

    public void setAutoSizeColums(boolean autosizecolums) {
        this.autosizecolums = autosizecolums;
    }

    public boolean isHeaderEnabled() {
        return this.headerEnabled;
    }

    public void setHeaderEnabled(boolean header) {
        this.headerEnabled = header;
    }

    public boolean isSpecifyFormat() {
        return this.SpecifyFormat;
    }

    public void setSpecifyFormat(boolean SpecifyFormat) {
        this.SpecifyFormat = SpecifyFormat;
    }

    public String getDateTimeFormat() {
        return this.date_time_format;
    }

    public void setDateTimeFormat(String date_time_format) {
        this.date_time_format = date_time_format;
    }

    public String getNewline() {
        return this.newline;
    }

    public void setNewline(String newline) {
        this.newline = newline;
    }

    public int getSplitEvery() {
        return this.splitEvery;
    }

    public boolean isAddToResultFiles() {
        return this.addToResultFilenames;
    }

    public void setAddToResultFiles(boolean addtoresultfilenamesin) {
        this.addToResultFilenames = addtoresultfilenamesin;
    }

    public void setSplitEvery(int splitEvery) {
        this.splitEvery = splitEvery;
    }

    public boolean isStepNrInFilename() {
        return this.stepNrInFilename;
    }

    public void setStepNrInFilename(boolean stepNrInFilename) {
        this.stepNrInFilename = stepNrInFilename;
    }

    public boolean isTimeInFilename() {
        return this.timeInFilename;
    }

    public boolean isSheetProtected() {
        return this.protectsheet;
    }

    public void setTimeInFilename(boolean timeInFilename) {
        this.timeInFilename = timeInFilename;
    }

    public void setProtectSheet(boolean protectsheet) {
        this.protectsheet = protectsheet;
    }

    public ExcelField[] getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(ExcelField[] outputFields) {
        this.outputFields = outputFields;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isTemplateEnabled() {
        return this.templateEnabled;
    }

    public void setTemplateEnabled(boolean template) {
        this.templateEnabled = template;
    }

    public boolean isTemplateAppend() {
        return this.templateAppend;
    }

    public void setTemplateAppend(boolean templateAppend) {
        this.templateAppend = templateAppend;
    }

    public String getTemplateFileName() {
        return this.templateFileName;
    }

    public void setTemplateFileName(String templateFileName) {
        this.templateFileName = templateFileName;
    }

    public boolean isDoNotOpenNewFileInit() {
        return this.doNotOpenNewFileInit;
    }

    public void setDoNotOpenNewFileInit(boolean doNotOpenNewFileInit) {
        this.doNotOpenNewFileInit = doNotOpenNewFileInit;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.outputFields = new ExcelField[nrfields];
    }

    @Override
    public Object clone() {
        ExcelOutputMeta retval = (ExcelOutputMeta)super.clone();
        int nrfields = this.outputFields.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.outputFields[i] = (ExcelField)this.outputFields[i].clone();
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.headerEnabled = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"header"));
            this.footerEnabled = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"footer"));
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            this.append = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"append"));
            String addToResult = XMLHandler.getTagValue((Node)stepnode, (String)"add_to_result_filenames");
            this.addToResultFilenames = Const.isEmpty((String)addToResult) ? true : "Y".equalsIgnoreCase(addToResult);
            this.fileName = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"name");
            this.extension = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"extention");
            this.doNotOpenNewFileInit = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"do_not_open_newfile_init"));
            this.stepNrInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"split"));
            this.dateInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"add_date"));
            this.timeInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"add_time"));
            this.SpecifyFormat = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"SpecifyFormat"));
            this.date_time_format = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"date_time_format");
            this.autosizecolums = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"autosizecolums"));
            this.protectsheet = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"protect_sheet"));
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"password"));
            this.splitEvery = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"splitevery"), (int)0);
            this.templateEnabled = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"template", (String)"enabled"));
            this.templateAppend = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"template", (String)"append"));
            this.templateFileName = XMLHandler.getTagValue((Node)stepnode, (String)"template", (String)"filename");
            this.sheetname = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"sheetname");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.outputFields[i] = new ExcelField();
                this.outputFields[i].setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                this.outputFields[i].setType(XMLHandler.getTagValue((Node)fnode, (String)"type"));
                this.outputFields[i].setFormat(XMLHandler.getTagValue((Node)fnode, (String)"format"));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public String getNewLine(String fformat) {
        String nl = System.getProperty("line.separator");
        if (fformat != null) {
            if (fformat.equalsIgnoreCase("DOS")) {
                nl = "\r\n";
            } else if (fformat.equalsIgnoreCase("UNIX")) {
                nl = "\n";
            }
        }
        return nl;
    }

    @Override
    public void setDefault() {
        this.autosizecolums = false;
        this.headerEnabled = true;
        this.footerEnabled = false;
        this.fileName = "file";
        this.extension = "xls";
        this.doNotOpenNewFileInit = false;
        this.stepNrInFilename = false;
        this.dateInFilename = false;
        this.timeInFilename = false;
        this.date_time_format = null;
        this.SpecifyFormat = false;
        this.addToResultFilenames = true;
        this.protectsheet = false;
        this.splitEvery = 0;
        this.templateEnabled = false;
        this.templateAppend = false;
        this.templateFileName = "template.xls";
        this.sheetname = "Sheet1";
        this.append = false;
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.outputFields[i] = new ExcelField();
            this.outputFields[i].setName("field" + i);
            this.outputFields[i].setType("Number");
            this.outputFields[i].setFormat(" 0,000,000.00;-0,000,000.00");
        }
    }

    public String[] getFiles(VariableSpace space) {
        int nr;
        int copies = 1;
        int splits = 1;
        if (this.stepNrInFilename) {
            copies = 3;
        }
        if (this.splitEvery != 0) {
            splits = 3;
        }
        if ((nr = copies * splits) > 1) {
            ++nr;
        }
        String[] retval = new String[nr];
        int i = 0;
        for (int copy = 0; copy < copies; ++copy) {
            for (int split = 0; split < splits; ++split) {
                retval[i] = this.buildFilename(space, copy, split);
                ++i;
            }
        }
        if (i < nr) {
            retval[i] = "...";
        }
        return retval;
    }

    public String buildFilename(VariableSpace space, int stepnr, int splitnr) {
        SimpleDateFormat daf = new SimpleDateFormat();
        String retval = space.environmentSubstitute(this.fileName);
        String realextension = space.environmentSubstitute(this.extension);
        Date now = new Date();
        if (this.SpecifyFormat && !Const.isEmpty((String)this.date_time_format)) {
            daf.applyPattern(this.date_time_format);
            String dt = daf.format(now);
            retval = retval + dt;
        } else {
            if (this.dateInFilename) {
                daf.applyPattern("yyyMMdd");
                String d = daf.format(now);
                retval = retval + "_" + d;
            }
            if (this.timeInFilename) {
                daf.applyPattern("HHmmss");
                String t = daf.format(now);
                retval = retval + "_" + t;
            }
        }
        if (this.stepNrInFilename) {
            retval = retval + "_" + stepnr;
        }
        if (this.splitEvery > 0) {
            retval = retval + "_" + splitnr;
        }
        if (realextension != null && realextension.length() != 0) {
            retval = retval + "." + realextension;
        }
        return retval;
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) {
        if (r == null) {
            r = new RowMeta();
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(800);
        retval.append("    ").append(XMLHandler.addTagValue((String)"header", (boolean)this.headerEnabled));
        retval.append("    ").append(XMLHandler.addTagValue((String)"footer", (boolean)this.footerEnabled));
        retval.append("    ").append(XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    " + XMLHandler.addTagValue((String)"append", (boolean)this.append));
        retval.append("    " + XMLHandler.addTagValue((String)"add_to_result_filenames", (boolean)this.addToResultFilenames));
        retval.append("    <file>").append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.fileName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"extention", (String)this.extension));
        retval.append("      ").append(XMLHandler.addTagValue((String)"do_not_open_newfile_init", (boolean)this.doNotOpenNewFileInit));
        retval.append("      ").append(XMLHandler.addTagValue((String)"split", (boolean)this.stepNrInFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_date", (boolean)this.dateInFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_time", (boolean)this.timeInFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"SpecifyFormat", (boolean)this.SpecifyFormat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"date_time_format", (String)this.date_time_format));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sheetname", (String)this.sheetname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"autosizecolums", (boolean)this.autosizecolums));
        retval.append("      ").append(XMLHandler.addTagValue((String)"protect_sheet", (boolean)this.protectsheet));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"splitevery", (int)this.splitEvery));
        retval.append("      </file>").append(Const.CR);
        retval.append("    <template>").append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"enabled", (boolean)this.templateEnabled));
        retval.append("      ").append(XMLHandler.addTagValue((String)"append", (boolean)this.templateAppend));
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename", (String)this.templateFileName));
        retval.append("    </template>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.outputFields.length; ++i) {
            ExcelField field = this.outputFields[i];
            if (field.getName() == null || field.getName().length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)field.getName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)field.getTypeDesc()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)field.getFormat()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.headerEnabled = rep.getStepAttributeBoolean(id_step, "header");
            this.footerEnabled = rep.getStepAttributeBoolean(id_step, "footer");
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            this.append = rep.getStepAttributeBoolean(id_step, "append");
            String addToResult = rep.getStepAttributeString(id_step, "add_to_result_filenames");
            this.addToResultFilenames = Const.isEmpty((String)addToResult) ? true : rep.getStepAttributeBoolean(id_step, "add_to_result_filenames");
            this.fileName = rep.getStepAttributeString(id_step, "file_name");
            this.extension = rep.getStepAttributeString(id_step, "file_extention");
            this.doNotOpenNewFileInit = rep.getStepAttributeBoolean(id_step, "do_not_open_newfile_init");
            this.splitEvery = (int)rep.getStepAttributeInteger(id_step, "file_split");
            this.stepNrInFilename = rep.getStepAttributeBoolean(id_step, "file_add_stepnr");
            this.dateInFilename = rep.getStepAttributeBoolean(id_step, "file_add_date");
            this.timeInFilename = rep.getStepAttributeBoolean(id_step, "file_add_time");
            this.SpecifyFormat = rep.getStepAttributeBoolean(id_step, "SpecifyFormat");
            this.date_time_format = rep.getStepAttributeString(id_step, "date_time_format");
            this.autosizecolums = rep.getStepAttributeBoolean(id_step, "autosizecolums");
            this.protectsheet = rep.getStepAttributeBoolean(id_step, "protect_sheet");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "password"));
            this.templateEnabled = rep.getStepAttributeBoolean(id_step, "template_enabled");
            this.templateAppend = rep.getStepAttributeBoolean(id_step, "template_append");
            this.templateFileName = rep.getStepAttributeString(id_step, "template_filename");
            this.sheetname = rep.getStepAttributeString(id_step, "sheetname");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.outputFields[i] = new ExcelField();
                this.outputFields[i].setName(rep.getStepAttributeString(id_step, i, "field_name"));
                this.outputFields[i].setType(rep.getStepAttributeString(id_step, i, "field_type"));
                this.outputFields[i].setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "header", this.headerEnabled);
            rep.saveStepAttribute(id_transformation, id_step, "footer", this.footerEnabled);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "append", this.append);
            rep.saveStepAttribute(id_transformation, id_step, "add_to_result_filenames", this.addToResultFilenames);
            rep.saveStepAttribute(id_transformation, id_step, "file_name", this.fileName);
            rep.saveStepAttribute(id_transformation, id_step, "do_not_open_newfile_init", this.doNotOpenNewFileInit);
            rep.saveStepAttribute(id_transformation, id_step, "file_extention", this.extension);
            rep.saveStepAttribute(id_transformation, id_step, "file_split", this.splitEvery);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_stepnr", this.stepNrInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_date", this.dateInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_time", this.timeInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "SpecifyFormat", this.SpecifyFormat);
            rep.saveStepAttribute(id_transformation, id_step, "date_time_format", this.date_time_format);
            rep.saveStepAttribute(id_transformation, id_step, "autosizecolums", this.autosizecolums);
            rep.saveStepAttribute(id_transformation, id_step, "protect_sheet", this.protectsheet);
            rep.saveStepAttribute(id_transformation, id_step, "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveStepAttribute(id_transformation, id_step, "template_enabled", this.templateEnabled);
            rep.saveStepAttribute(id_transformation, id_step, "template_append", this.templateAppend);
            rep.saveStepAttribute(id_transformation, id_step, "template_filename", this.templateFileName);
            rep.saveStepAttribute(id_transformation, id_step, "sheetname", this.sheetname);
            for (int i = 0; i < this.outputFields.length; ++i) {
                ExcelField field = this.outputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_format", field.getFormat());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, Messages.getString("ExcelOutputMeta.CheckResult.FieldsReceived", "" + prev.size()), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            String error_message = "";
            boolean error_found = false;
            for (int i = 0; i < this.outputFields.length; ++i) {
                int idx = prev.indexOfValue(this.outputFields[i].getName());
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.outputFields[i].getName() + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = Messages.getString("ExcelOutputMeta.CheckResult.FieldsNotFound", error_message);
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, Messages.getString("ExcelOutputMeta.CheckResult.AllFieldsFound"), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("ExcelOutputMeta.CheckResult.ExpectedInputOk"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("ExcelOutputMeta.CheckResult.ExpectedInputError"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        cr = new CheckResult(2, Messages.getString("ExcelOutputMeta.CheckResult.FilesNotChecked"), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository) throws KettleException {
        try {
            if (!Const.isEmpty((String)this.fileName)) {
                FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.fileName));
                this.fileName = resourceNamingInterface.nameResource(fileObject.getName().getBaseName(), fileObject.getParent().getName().getPath(), space.toString(), ResourceNamingInterface.FileNamingType.DATA_FILE);
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new ExcelOutput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ExcelOutputData();
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"jxl.jar"};
    }
}

