/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.connection.internal.ui.viewers;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableNavigator
extends TableCursor {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    private static final String TABLETREEITEM_ID = "TableTreeItemID";
    final Table table;
    protected SelectionKeyAdapter keyAdapter = null;

    public TableNavigator(Table table, StructuredViewer viewer) {
        super(table, 0);
        this.table = table;
        final Table currentTable = table;
        final StructuredViewer sViewer = viewer;
        this.setVisible(false);
        this.addPaintListener(viewer);
        this.addKeyListeners(viewer);
        this.addMouseListeners(viewer);
        this.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                currentTable.setSelection(new TableItem[]{TableNavigator.this.getRow()});
                if (sViewer instanceof TableTreeViewer) {
                    TableTreeItem tableTreeItem = (TableTreeItem)TableNavigator.this.getRow().getData(TableNavigator.TABLETREEITEM_ID);
                    StructuredSelection selection = new StructuredSelection(tableTreeItem.getData());
                    sViewer.setSelection((ISelection)selection, true);
                }
            }
        });
        this.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                Object eventSource = e.getSource();
                if (eventSource instanceof Control) {
                    if (!this.isChild((Control)currentTable, (Control)eventSource)) {
                        if (currentTable.getItemCount() > 0 && currentTable.getSelectionCount() <= 0) {
                            if (sViewer instanceof TableTreeViewer) {
                                TableTreeItem tableTreeItem = (TableTreeItem)TableNavigator.this.getRow().getData(TableNavigator.TABLETREEITEM_ID);
                                StructuredSelection selection = new StructuredSelection(tableTreeItem.getData());
                                sViewer.setSelection((ISelection)selection, true);
                            } else {
                                currentTable.setSelection(0);
                                TableNavigator.this.setSelection(0, 0);
                            }
                            TableNavigator.this.notifyListeners(13, new Event());
                        }
                    } else if (currentTable.getItems().length > 0) {
                        try {
                            TableNavigator.this.setVisible(true);
                        }
                        catch (Exception exception) {
                            currentTable.setSelection(0);
                            TableNavigator.this.setSelection(0, 0);
                        }
                    } else {
                        TableNavigator.this.setVisible(false);
                    }
                }
            }

            protected boolean isChild(Control parent, Control child) {
                Control tempChild = child;
                while (tempChild != null) {
                    if (tempChild == parent) {
                        return true;
                    }
                    tempChild = tempChild.getParent();
                }
                return false;
            }

            public void focusLost(FocusEvent e) {
                Display.getDefault().asyncExec(new Runnable(this, currentTable){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ Table val$currentTable;
                    {
                        this.this$1 = var1_1;
                        this.val$currentTable = table;
                    }

                    public void run() {
                        if (!(this.val$currentTable == null || this.val$currentTable.isDisposed() || this.val$currentTable.isFocusControl() || this.this$1.isChild((Control)this.val$currentTable, Display.getDefault().getFocusControl()))) {
                            2.access$0(this.this$1).setVisible(false);
                        }
                    }
                });
            }

            static /* synthetic */ TableNavigator access$0(2 var0) {
                return var0.TableNavigator.this;
            }
        });
        table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (currentTable.getItemCount() > 0 && Display.getDefault().getFocusControl() != null && !Display.getDefault().getFocusControl().equals((Object)TableNavigator.this)) {
                    Display.getDefault().asyncExec(new Runnable(this, currentTable){
                        final /* synthetic */ 4 this$1;
                        private final /* synthetic */ Table val$currentTable;
                        {
                            this.this$1 = var1_1;
                            this.val$currentTable = table;
                        }

                        public void run() {
                            if (!4.access$0(this.this$1).isVisible()) {
                                if (4.access$0(this.this$1).getRow() == null && this.val$currentTable.getItemCount() > 0) {
                                    this.val$currentTable.setSelection(0);
                                    4.access$0(this.this$1).setSelection(0, 0);
                                    4.access$0(this.this$1).notifyListeners(13, new Event());
                                }
                                try {
                                    4.access$0(this.this$1).setVisible(true);
                                    4.access$0(this.this$1).setFocus();
                                }
                                catch (Exception exception) {
                                    if (this.val$currentTable.getItemCount() > 0) {
                                        this.val$currentTable.setSelection(0);
                                        4.access$0(this.this$1).setSelection(0, 0);
                                    }
                                    4.access$0(this.this$1).setVisible(false);
                                }
                            }
                        }
                    });
                }
            }

            static /* synthetic */ TableNavigator access$0(4 var0) {
                return var0.TableNavigator.this;
            }
        });
    }

    public Table getTable() {
        return this.table;
    }

    public void addPaintListener(StructuredViewer viewer) {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TableItem[] selection = TableNavigator.this.table.getSelection();
                TableItem row = selection.length == 0 ? TableNavigator.this.table.getItem(TableNavigator.this.table.getTopIndex()) : selection[0];
                String cellText = row.getText(TableNavigator.this.getColumn());
                Image cellImage = row.getImage(TableNavigator.this.getColumn());
                int col = TableNavigator.this.getColumn();
                Display.getCurrent().asyncExec(new Runnable(this, row, cellText, col, cellImage){
                    final /* synthetic */ 6 this$1;
                    private final /* synthetic */ TableItem val$row;
                    private final /* synthetic */ String val$cellText;
                    private final /* synthetic */ int val$col;
                    private final /* synthetic */ Image val$cellImage;
                    {
                        this.this$1 = var1_1;
                        this.val$row = tableItem;
                        this.val$cellText = string;
                        this.val$col = n;
                        this.val$cellImage = image;
                    }

                    public void run() {
                        if (!this.val$row.isDisposed()) {
                            String newText = this.val$row.getText(6.access$0(this.this$1).getColumn());
                            6.access$0(this.this$1).getRow();
                            if (!newText.equals(this.val$cellText) || this.val$row.getImage(this.val$col) != this.val$cellImage) {
                                6.access$0(this.this$1).redraw();
                            }
                        }
                    }
                });
            }

            static /* synthetic */ TableNavigator access$0(6 var0) {
                return var0.TableNavigator.this;
            }
        });
    }

    public SelectionKeyAdapter getKeyAdapter(StructuredViewer viewer) {
        if (this.keyAdapter == null) {
            return new SelectionKeyAdapter(viewer);
        }
        return this.keyAdapter;
    }

    public void setKeyAdapter(SelectionKeyAdapter kAdapter) {
        this.keyAdapter = kAdapter;
    }

    public void addKeyListeners(StructuredViewer viewer) {
        StructuredViewer structuredViewer = viewer;
        this.addKeyListener((KeyListener)this.getKeyAdapter(structuredViewer));
    }

    public void addMouseListeners(StructuredViewer viewer) {
        final StructuredViewer structuredViewer = viewer;
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TableItem row = TableNavigator.this.getRow();
                int column = TableNavigator.this.getColumn();
                if (e.button == 1) {
                    TableTreeItem tableTreeItem;
                    if (structuredViewer instanceof TableViewer) {
                        ((TableViewer)structuredViewer).editElement(row.getData(), column);
                    } else if (structuredViewer instanceof TableTreeViewer && column == 1) {
                        tableTreeItem = (TableTreeItem)row.getData(TableNavigator.TABLETREEITEM_ID);
                        ((TableTreeViewer)structuredViewer).editElement(tableTreeItem.getData(), column);
                    }
                    if (structuredViewer instanceof TableTreeViewer && row.getData(TableNavigator.TABLETREEITEM_ID) instanceof TableTreeItem && column == 0) {
                        tableTreeItem = (TableTreeItem)row.getData(TableNavigator.TABLETREEITEM_ID);
                        boolean expandState = tableTreeItem.getExpanded();
                        ((TableTreeViewer)structuredViewer).setExpandedState(tableTreeItem.getData(), !expandState);
                        TableNavigator.this.refresh();
                    }
                }
            }
        });
    }

    public void moveCellEditorsAbove(CellEditor[] editorArray) {
        int i = 0;
        while (i < editorArray.length) {
            CellEditor cEd = editorArray[i];
            if (cEd != null && cEd.getControl() != null) {
                cEd.getControl().moveAbove(null);
            }
            ++i;
        }
    }

    public void refresh() {
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (!TableNavigator.this.isDisposed() && TableNavigator.this.isVisible()) {
                    TableNavigator.this.redraw();
                }
            }
        });
    }

    public class SelectionKeyAdapter
    extends KeyAdapter {
        StructuredViewer structuredViewer;
        int lastKeyPressed = -1;

        public SelectionKeyAdapter(StructuredViewer viewer) {
            this.structuredViewer = viewer;
        }

        public void keyPressed(KeyEvent e) {
            TableTreeItem tableTreeItem;
            TableItem row = TableNavigator.this.getRow();
            int column = TableNavigator.this.getColumn();
            if (this.lastKeyPressed == 131072 && e.keyCode == 0x1000013) {
                Menu popup = TableNavigator.this.getTable().getMenu();
                popup.setVisible(true);
            }
            this.lastKeyPressed = e.keyCode;
            if (row.getData(TableNavigator.TABLETREEITEM_ID) instanceof TableTreeItem) {
                if (column == 0 && e.character == '+') {
                    tableTreeItem = (TableTreeItem)row.getData(TableNavigator.TABLETREEITEM_ID);
                    ((TableTreeViewer)this.structuredViewer).setExpandedState(tableTreeItem.getData(), true);
                    TableNavigator.this.refresh();
                } else if (column == 0 && e.character == '-') {
                    tableTreeItem = (TableTreeItem)row.getData(TableNavigator.TABLETREEITEM_ID);
                    ((TableTreeViewer)this.structuredViewer).setExpandedState(tableTreeItem.getData(), false);
                    TableNavigator.this.refresh();
                }
            }
            if (e.keyCode == 0x100000B) {
                if (this.structuredViewer instanceof TableViewer) {
                    ((TableViewer)this.structuredViewer).editElement(row.getData(), column);
                } else if (this.structuredViewer instanceof TableTreeViewer) {
                    tableTreeItem = (TableTreeItem)row.getData(TableNavigator.TABLETREEITEM_ID);
                    ((TableTreeViewer)this.structuredViewer).editElement(tableTreeItem.getData(), column);
                }
            }
        }
    }
}

