/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.text.FileMatch;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.internal.ui.text.SearchResultUpdater;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.Match;

public class FileSearchQuery
implements ISearchQuery {
    private final FileTextSearchScope fScope;
    private final String fSearchText;
    private final boolean fIsRegEx;
    private final boolean fIsCaseSensitive;
    private FileSearchResult fResult;

    public FileSearchQuery(String searchText, boolean isRegEx, boolean isCaseSensitive, FileTextSearchScope scope) {
        this.fSearchText = searchText;
        this.fIsRegEx = isRegEx;
        this.fIsCaseSensitive = isCaseSensitive;
        this.fScope = scope;
    }

    public FileTextSearchScope getSearchScope() {
        return this.fScope;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public IStatus run(IProgressMonitor monitor) {
        AbstractTextSearchResult textResult = (AbstractTextSearchResult)this.getSearchResult();
        textResult.removeAll();
        Pattern searchPattern = this.getSearchPattern();
        boolean isFileSearchOnly = searchPattern.pattern().length() == 0;
        boolean searchInBinaries = !this.isScopeAllFileTypes();
        TextSearchResultCollector collector = new TextSearchResultCollector(textResult, isFileSearchOnly, searchInBinaries);
        return TextSearchEngine.create().search(this.fScope, (TextSearchRequestor)collector, searchPattern, monitor);
    }

    private boolean isScopeAllFileTypes() {
        String[] fileNamePatterns = this.fScope.getFileNamePatterns();
        int i = 0;
        while (i < fileNamePatterns.length) {
            if ("*".equals(fileNamePatterns[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getLabel() {
        return SearchMessages.FileSearchQuery_label;
    }

    public String getSearchString() {
        return this.fSearchText;
    }

    public String getResultLabel(int nMatches) {
        String searchString = this.getSearchString();
        if (searchString.length() > 0) {
            if (this.isScopeAllFileTypes()) {
                if (nMatches == 1) {
                    Object[] args = new Object[]{searchString, this.fScope.getDescription()};
                    return Messages.format(SearchMessages.FileSearchQuery_singularLabel, args);
                }
                Object[] args = new Object[]{searchString, new Integer(nMatches), this.fScope.getDescription()};
                return Messages.format(SearchMessages.FileSearchQuery_pluralPattern, args);
            }
            if (nMatches == 1) {
                Object[] args = new Object[]{searchString, this.fScope.getDescription(), this.fScope.getFilterDescription()};
                return Messages.format(SearchMessages.FileSearchQuery_singularPatternWithFileExt, args);
            }
            Object[] args = new Object[]{searchString, new Integer(nMatches), this.fScope.getDescription(), this.fScope.getFilterDescription()};
            return Messages.format(SearchMessages.FileSearchQuery_pluralPatternWithFileExt, args);
        }
        if (nMatches == 1) {
            Object[] args = new Object[]{this.fScope.getFilterDescription(), this.fScope.getDescription()};
            return Messages.format(SearchMessages.FileSearchQuery_singularLabel_fileNameSearch, args);
        }
        Object[] args = new Object[]{this.fScope.getFilterDescription(), new Integer(nMatches), this.fScope.getDescription()};
        return Messages.format(SearchMessages.FileSearchQuery_pluralPattern_fileNameSearch, args);
    }

    public IStatus searchInFile(AbstractTextSearchResult result, IProgressMonitor monitor, IFile file) {
        FileTextSearchScope scope = FileTextSearchScope.newSearchScope(new IResource[]{file}, new String[]{"*"}, true);
        Pattern searchPattern = this.getSearchPattern();
        boolean isFileSearchOnly = searchPattern.pattern().length() == 0;
        TextSearchResultCollector collector = new TextSearchResultCollector(result, isFileSearchOnly, true);
        return TextSearchEngine.create().search(scope, (TextSearchRequestor)collector, searchPattern, monitor);
    }

    protected Pattern getSearchPattern() {
        return PatternConstructor.createPattern(this.fSearchText, this.fIsCaseSensitive, this.fIsRegEx);
    }

    public boolean isRegexSearch() {
        return this.fIsRegEx;
    }

    public boolean isCaseSensitive() {
        return this.fIsCaseSensitive;
    }

    public boolean canRerun() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new FileSearchResult(this);
            new SearchResultUpdater(this.fResult);
        }
        return this.fResult;
    }

    private static final class TextSearchResultCollector
    extends TextSearchRequestor {
        private final AbstractTextSearchResult fResult;
        private final boolean fIsFileSearchOnly;
        private final boolean fSearchInBinaries;
        private ArrayList fCachedMatches;

        private TextSearchResultCollector(AbstractTextSearchResult result, boolean isFileSearchOnly, boolean searchInBinaries) {
            this.fResult = result;
            this.fIsFileSearchOnly = isFileSearchOnly;
            this.fSearchInBinaries = searchInBinaries;
        }

        public boolean acceptFile(IFile file) throws CoreException {
            if (this.fIsFileSearchOnly) {
                this.fResult.addMatch(new FileMatch(file, 0, 0));
            }
            this.flushMatches();
            return true;
        }

        public boolean reportBinaryFile(IFile file) {
            return this.fSearchInBinaries;
        }

        public boolean acceptPatternMatch(TextSearchMatchAccess matchRequestor) throws CoreException {
            this.fCachedMatches.add(new FileMatch(matchRequestor.getFile(), matchRequestor.getMatchOffset(), matchRequestor.getMatchLength()));
            return true;
        }

        public void beginReporting() {
            this.fCachedMatches = new ArrayList();
        }

        public void endReporting() {
            this.flushMatches();
            this.fCachedMatches = null;
        }

        private void flushMatches() {
            if (!this.fCachedMatches.isEmpty()) {
                this.fResult.addMatches(this.fCachedMatches.toArray(new Match[this.fCachedMatches.size()]));
                this.fCachedMatches.clear();
            }
        }
    }
}

