/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManagerEvent;
import org.eclipse.core.commands.contexts.IContextManagerListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.contexts.DebugContextManager;
import org.eclipse.debug.internal.ui.contexts.DebugModelContextBindingManager;
import org.eclipse.debug.internal.ui.contexts.provisional.IDebugContextListener;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener4;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ViewContextService
implements IDebugContextListener,
IPerspectiveListener4,
Preferences.IPropertyChangeListener,
IContextManagerListener {
    private Map fPerspectiveToActiveContext = new HashMap();
    private Map fPerspectiveToActivatedContexts = new HashMap();
    private Map fContextIdsToViewIds;
    private Map fViewBindings;
    private List fEnabledPerspectives = new ArrayList();
    private boolean fIgnoreChanges = false;
    private IWorkbenchWindow fWindow;
    private IContextService fContextService;
    public static final String DEBUG_CONTEXT = "org.eclipse.debug.ui.debugging";
    private static final String ID_CONTEXT_VIEW_BINDINGS = "contextViewBindings";
    private static final String ATTR_CONTEXT_ID = "contextId";
    private static final String ATTR_VIEW_ID = "viewId";
    private static final String ATTR_AUTO_OPEN = "autoOpen";
    private static final String ATTR_AUTO_CLOSE = "autoClose";
    private static final String XML_ELEMENT_VIEW_BINDINGS = "viewBindings";
    private static final String XML_ELEMENT_PERSPECTIVE = "perspective";
    private static final String XML_ELEMENT_VIEW = "view";
    private static final String XML_ATTR_ID = "id";
    private static final String XML_ATTR_USER_ACTION = "userAction";
    private static final String XML_VALUE_OPENED = "opened";
    private static final String XML_VALUE_CLOSED = "closed";
    private static Set fgBaseDebugViewIds = null;

    static {
        fgBaseDebugViewIds = new HashSet();
        fgBaseDebugViewIds.add("org.eclipse.debug.ui.DebugView");
        fgBaseDebugViewIds.add("org.eclipse.debug.ui.VariableView");
        fgBaseDebugViewIds.add("org.eclipse.debug.ui.BreakpointView");
        fgBaseDebugViewIds.add("org.eclipse.ui.console.ConsoleView");
    }

    ViewContextService(IWorkbenchWindow window) {
        this.fWindow = window;
        this.loadContextToViewExtensions();
        this.applyUserViewBindings();
        this.loadPerspectives();
        window.addPerspectiveListener((IPerspectiveListener)this);
        DebugContextManager.getDefault().addDebugContextListener(this, window);
        DebugUIPlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        this.fContextService = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
        this.fContextService.addContextManagerListener((IContextManagerListener)this);
    }

    public void dispose() {
        this.fWindow.removePerspectiveListener((IPerspectiveListener)this);
        DebugContextManager.getDefault().removeDebugContextListener(this, this.fWindow);
        DebugUIPlugin.getDefault().getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
        this.fContextService.removeContextManagerListener((IContextManagerListener)this);
    }

    private void loadContextToViewExtensions() {
        this.fContextIdsToViewIds = new HashMap();
        this.fViewBindings = new HashMap();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), ID_CONTEXT_VIEW_BINDINGS);
        IConfigurationElement[] configurationElements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configurationElements.length) {
            IConfigurationElement element = configurationElements[i];
            String viewId = element.getAttribute(ATTR_VIEW_ID);
            String contextId = element.getAttribute(ATTR_CONTEXT_ID);
            if (contextId != null && viewId != null) {
                ViewBinding info = new ViewBinding(element);
                ArrayList<String> ids = (ArrayList<String>)this.fContextIdsToViewIds.get(contextId);
                if (ids == null) {
                    ids = new ArrayList<String>();
                    this.fContextIdsToViewIds.put(contextId, ids);
                }
                ids.add(viewId);
                this.fViewBindings.put(viewId, info);
            }
            ++i;
        }
    }

    private void applyUserViewBindings() {
        String xml = DebugUITools.getPreferenceStore().getString(IInternalDebugUIConstants.PREF_USER_VIEW_BINDINGS);
        if (xml.length() > 0) {
            try {
                Element root = DebugPlugin.parseDocument((String)xml);
                NodeList list = root.getChildNodes();
                int length = list.getLength();
                int i = 0;
                while (i < length) {
                    String id;
                    ViewBinding binding;
                    Element entry;
                    Node node = list.item(i);
                    short type = node.getNodeType();
                    if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(XML_ELEMENT_VIEW) && (binding = (ViewBinding)this.fViewBindings.get(id = entry.getAttribute(XML_ATTR_ID))) != null) {
                        binding.applyUserSettings(entry);
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
    }

    private void loadPerspectives() {
        String prefString = DebugUIPlugin.getDefault().getPreferenceStore().getString(IDebugUIConstants.PREF_MANAGE_VIEW_PERSPECTIVES);
        this.fEnabledPerspectives = ViewContextService.parseList(prefString);
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if (!this.fIgnoreChanges) {
            if (IDebugUIConstants.PREF_MANAGE_VIEW_PERSPECTIVES.equals(event.getProperty())) {
                this.loadPerspectives();
            } else if (IInternalDebugUIConstants.PREF_USER_VIEW_BINDINGS.equals(event.getProperty())) {
                this.loadContextToViewExtensions();
                this.applyUserViewBindings();
                this.fPerspectiveToActivatedContexts.clear();
                ISelection selection = DebugContextManager.getDefault().getActiveContext(this.fWindow);
                this.contextActivated(selection, null);
            }
        }
    }

    private boolean isEnabledPerspective() {
        IPerspectiveDescriptor perspective = this.getActivePerspective();
        if (perspective != null) {
            return this.fEnabledPerspectives.contains(perspective.getId());
        }
        return false;
    }

    private IPerspectiveDescriptor getActivePerspective() {
        IWorkbenchPage activePage = this.fWindow.getActivePage();
        if (activePage != null) {
            return activePage.getPerspective();
        }
        return null;
    }

    public static List parseList(String listString) {
        ArrayList<String> list = new ArrayList<String>(10);
        StringTokenizer tokenizer = new StringTokenizer(listString, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            list.add(token);
        }
        return list;
    }

    public void contextActivated(ISelection selection, IWorkbenchPart part) {
        if (this.isEnabledPerspective() && selection instanceof IStructuredSelection && !selection.isEmpty()) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object target : ss) {
                ILaunchConfiguration launchConfiguration;
                ILaunch launch = DebugModelContextBindingManager.getLaunch(target);
                if (launch == null || (launchConfiguration = launch.getLaunchConfiguration()) == null) continue;
                try {
                    List workbenchContexts;
                    ILaunchConfigurationType type = launchConfiguration.getType();
                    if (!this.fContextService.getActiveContextIds().contains(String.valueOf(type.getIdentifier()) + "." + this.getActivePerspective().getId()) || (workbenchContexts = DebugModelContextBindingManager.getDefault().getWorkbenchContextsForDebugContext(target)).isEmpty()) continue;
                    Iterator contexts = workbenchContexts.iterator();
                    while (contexts.hasNext()) {
                        String contextId = (String)contexts.next();
                        if (!this.isActivated(contextId)) {
                            this.activateChain(contextId);
                        }
                        if (contexts.hasNext() || this.isActiveContext(contextId)) continue;
                        this.activate(contextId);
                    }
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
            }
        }
    }

    private boolean isActiveContext(String contextId) {
        IPerspectiveDescriptor activePerspective = this.getActivePerspective();
        if (activePerspective != null) {
            String activeId = (String)this.fPerspectiveToActiveContext.get(activePerspective);
            return contextId.equals(activeId);
        }
        return false;
    }

    private boolean isActivated(String contextId) {
        Set contexts;
        IPerspectiveDescriptor activePerspective = this.getActivePerspective();
        if (activePerspective != null && (contexts = (Set)this.fPerspectiveToActivatedContexts.get(activePerspective)) != null) {
            return contexts.contains(contextId);
        }
        return false;
    }

    private void addActivated(String contextId) {
        IPerspectiveDescriptor activePerspective = this.getActivePerspective();
        if (activePerspective != null) {
            HashSet<String> contexts = (HashSet<String>)this.fPerspectiveToActivatedContexts.get(activePerspective);
            if (contexts == null) {
                contexts = new HashSet<String>();
                this.fPerspectiveToActivatedContexts.put(activePerspective, contexts);
            }
            contexts.add(contextId);
        }
    }

    private void removeActivated(String contextId) {
        Set contexts;
        IPerspectiveDescriptor activePerspective = this.getActivePerspective();
        if (activePerspective != null && (contexts = (Set)this.fPerspectiveToActivatedContexts.get(activePerspective)) != null) {
            contexts.remove(contextId);
        }
    }

    public void contextChanged(ISelection selection, IWorkbenchPart part) {
    }

    public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    private void clean(IPerspectiveDescriptor perspective) {
        Set contexts = (Set)this.fPerspectiveToActivatedContexts.remove(perspective);
        this.fPerspectiveToActiveContext.remove(perspective);
        if (contexts != null) {
            for (String id : contexts) {
                this.deactivate(id);
            }
        }
    }

    public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
        ViewBinding info;
        if (!this.fIgnoreChanges && page.getWorkbenchWindow().equals(this.fWindow) && partRef != null && (info = (ViewBinding)this.fViewBindings.get(partRef.getId())) != null) {
            if ("viewShow" == changeId) {
                info.userOpened();
            } else if ("viewHide" == changeId) {
                info.userClosed();
            }
        }
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        ISelection activeContext;
        if (page.getWorkbenchWindow().equals(this.fWindow) && (activeContext = DebugContextManager.getDefault().getActiveContext(this.fWindow)) != null) {
            this.contextActivated(activeContext, null);
        }
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }

    private void activateChain(String contextId) {
        String[] contextChain = this.getContextChain(contextId);
        if (contextChain != null) {
            int i = 0;
            while (i < contextChain.length) {
                this.activate(contextChain[i]);
                ++i;
            }
        }
    }

    private String[] getContextChain(String contextId) {
        ArrayList<String> chain = new ArrayList<String>();
        Context context = null;
        do {
            if (context != null) {
                try {
                    contextId = context.getParentId();
                }
                catch (NotDefinedException e) {
                    DebugUIPlugin.log(e);
                    return null;
                }
            }
            context = this.fContextService.getContext(contextId);
            chain.add(0, contextId);
        } while (!contextId.equals(DEBUG_CONTEXT));
        return chain.toArray(new String[chain.size()]);
    }

    private void activate(String contextId) {
        IPerspectiveDescriptor perspective;
        IWorkbenchPage page = this.fWindow.getActivePage();
        if (page != null && (perspective = page.getPerspective()) != null) {
            this.addActivated(contextId);
            this.setActive(perspective, contextId);
            List viewIds = (List)this.fContextIdsToViewIds.get(contextId);
            if (viewIds != null) {
                for (String id : viewIds) {
                    ViewBinding info = (ViewBinding)this.fViewBindings.get(id);
                    info.activated(page);
                }
            }
        }
    }

    private void setActive(IPerspectiveDescriptor perspective, String contextId) {
        if (contextId == null) {
            this.fPerspectiveToActiveContext.remove(perspective);
        } else {
            this.fPerspectiveToActiveContext.put(perspective, contextId);
        }
    }

    public void contextManagerChanged(ContextManagerEvent event) {
        Set disabledContexts;
        if (event.isActiveContextsChanged() && !(disabledContexts = this.getDisabledContexts(event)).isEmpty()) {
            for (String contextId : disabledContexts) {
                if (!this.isViewConetxt(contextId) || !this.isActivated(contextId)) continue;
                this.deactivate(contextId);
            }
        }
    }

    private void deactivate(String contextId) {
        IPerspectiveDescriptor perspective;
        IWorkbenchPage page = this.fWindow.getActivePage();
        if (page != null && (perspective = page.getPerspective()) != null) {
            List viewIds;
            this.removeActivated(contextId);
            if (this.isActiveContext(contextId)) {
                this.setActive(perspective, null);
            }
            if ((viewIds = (List)this.fContextIdsToViewIds.get(contextId)) != null) {
                for (String id : viewIds) {
                    ViewBinding info = (ViewBinding)this.fViewBindings.get(id);
                    info.deactivated(page);
                }
            }
        }
    }

    private Set getDisabledContexts(ContextManagerEvent event) {
        HashSet prev = new HashSet(event.getPreviouslyActiveContextIds());
        Set activeContextIds = event.getContextManager().getActiveContextIds();
        if (activeContextIds != null) {
            prev.removeAll(activeContextIds);
        }
        return prev;
    }

    private boolean isViewConetxt(String id) {
        return this.fContextIdsToViewIds.containsKey(id);
    }

    private void saveViewBindings() {
        try {
            try {
                Document document = DebugPlugin.newDocument();
                Element root = document.createElement(XML_ELEMENT_VIEW_BINDINGS);
                document.appendChild(root);
                for (ViewBinding binding : this.fViewBindings.values()) {
                    binding.saveBindings(document, root);
                }
                String prefValue = "";
                if (root.hasChildNodes()) {
                    prefValue = DebugPlugin.serializeDocument((Document)document);
                }
                this.fIgnoreChanges = true;
                DebugUITools.getPreferenceStore().setValue(IInternalDebugUIConstants.PREF_USER_VIEW_BINDINGS, prefValue);
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        finally {
            this.fIgnoreChanges = false;
        }
    }

    public String[] getEnabledPerspectives() {
        return this.fEnabledPerspectives.toArray(new String[this.fEnabledPerspectives.size()]);
    }

    public void showViewQuiet(String viewId) {
        IWorkbenchPage page = this.fWindow.getActivePage();
        if (page != null) {
            try {
                try {
                    this.fIgnoreChanges = true;
                    page.showView(viewId, null, 2);
                }
                catch (PartInitException e) {
                    DebugUIPlugin.log(e);
                }
            }
            finally {
                this.fIgnoreChanges = false;
            }
        }
    }

    public void perspectivePreDeactivate(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        if (page.getWorkbenchWindow().equals(this.fWindow)) {
            this.clean(perspective);
        }
    }

    private class ViewBinding {
        private IConfigurationElement fElement;
        private Set fUserOpened = new HashSet();
        private Set fUserClosed = new HashSet();

        public ViewBinding(IConfigurationElement element) {
            this.fElement = element;
        }

        public String getViewId() {
            return this.fElement.getAttribute(ViewContextService.ATTR_VIEW_ID);
        }

        public boolean isAutoOpen() {
            String autoopen = this.fElement.getAttribute(ViewContextService.ATTR_AUTO_OPEN);
            return autoopen == null || "true".equals(autoopen);
        }

        public boolean isAutoClose() {
            String autoclose = this.fElement.getAttribute(ViewContextService.ATTR_AUTO_CLOSE);
            return autoclose == null || "true".equals(autoclose);
        }

        public boolean isUserOpened() {
            return this.fUserOpened.contains(ViewContextService.this.getActivePerspective().getId());
        }

        public boolean isUserClosed() {
            return this.fUserClosed.contains(ViewContextService.this.getActivePerspective().getId());
        }

        public boolean isDefault() {
            String id = ViewContextService.this.getActivePerspective().getId();
            if (IDebugUIConstants.ID_DEBUG_PERSPECTIVE.equals(id)) {
                return fgBaseDebugViewIds.contains(this.getViewId());
            }
            return false;
        }

        protected void userOpened() {
            if (this.isTrackingViews()) {
                String id = ViewContextService.this.getActivePerspective().getId();
                this.fUserOpened.add(id);
                this.fUserClosed.remove(id);
                ViewContextService.this.saveViewBindings();
            }
        }

        protected void userClosed() {
            if (this.isTrackingViews()) {
                String id = ViewContextService.this.getActivePerspective().getId();
                this.fUserClosed.add(id);
                this.fUserOpened.remove(id);
                ViewContextService.this.saveViewBindings();
            }
        }

        protected boolean isTrackingViews() {
            return DebugUITools.getPreferenceStore().getBoolean(IInternalDebugUIConstants.PREF_TRACK_VIEWS);
        }

        public void activated(IWorkbenchPage page) {
            if (!this.isUserClosed() && this.isAutoOpen()) {
                try {
                    try {
                        ViewContextService.this.fIgnoreChanges = true;
                        page.showView(this.getViewId(), null, 3);
                    }
                    catch (PartInitException e) {
                        DebugUIPlugin.log(e);
                    }
                }
                finally {
                    ViewContextService.this.fIgnoreChanges = false;
                }
            }
        }

        public void deactivated(IWorkbenchPage page) {
            IViewReference reference;
            if (!this.isUserOpened() && this.isAutoClose() && !this.isDefault() && (reference = page.findViewReference(this.getViewId())) != null) {
                try {
                    ViewContextService.this.fIgnoreChanges = true;
                    page.hideView(reference);
                }
                finally {
                    ViewContextService.this.fIgnoreChanges = false;
                }
            }
        }

        public void saveBindings(Document document, Element root) {
            Element viewElement = document.createElement(ViewContextService.XML_ELEMENT_VIEW);
            viewElement.setAttribute(ViewContextService.XML_ATTR_ID, this.getViewId());
            this.appendPerspectives(document, viewElement, this.fUserOpened, ViewContextService.XML_VALUE_OPENED);
            this.appendPerspectives(document, viewElement, this.fUserClosed, ViewContextService.XML_VALUE_CLOSED);
            if (viewElement.hasChildNodes()) {
                root.appendChild(viewElement);
            }
        }

        private void appendPerspectives(Document document, Element parent, Set perpectives, String xmlValue) {
            String[] ids = perpectives.toArray(new String[perpectives.size()]);
            int i = 0;
            while (i < ids.length) {
                String id = ids[i];
                Element element = document.createElement(ViewContextService.XML_ELEMENT_PERSPECTIVE);
                element.setAttribute(ViewContextService.XML_ATTR_ID, id);
                element.setAttribute(ViewContextService.XML_ATTR_USER_ACTION, xmlValue);
                parent.appendChild(element);
                ++i;
            }
        }

        public void applyUserSettings(Element viewElement) {
            NodeList list = viewElement.getChildNodes();
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                Element entry;
                Node node = list.item(i);
                short type = node.getNodeType();
                if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(ViewContextService.XML_ELEMENT_PERSPECTIVE)) {
                    String id = entry.getAttribute(ViewContextService.XML_ATTR_ID);
                    String setting = entry.getAttribute(ViewContextService.XML_ATTR_USER_ACTION);
                    if (id != null) {
                        if (ViewContextService.XML_VALUE_CLOSED.equals(setting)) {
                            this.fUserClosed.add(id);
                        } else if (ViewContextService.XML_VALUE_OPENED.equals(setting)) {
                            this.fUserOpened.add(id);
                        }
                    }
                }
                ++i;
            }
        }
    }
}

