/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.ControlStatementsFix;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.dialogs.IDialogSettings;

public class ControlStatementsCleanUp
extends AbstractCleanUp {
    public static final int ADD_BLOCK_TO_CONTROL_STATEMENTS = 1;
    public static final int CONVERT_FOR_LOOP_TO_ENHANCED_FOR_LOOP = 2;
    public static final int REMOVE_UNNECESSARY_BLOCKS = 4;
    public static final int REMOVE_UNNECESSARY_BLOCKS_CONTAINING_RETURN_OR_THROW = 8;
    private static final int DEFAULT_FLAG = 0;
    private static final String SECTION_NAME = "CleanUp_ControlStatements";

    public ControlStatementsCleanUp(int flag) {
        super(flag);
    }

    public ControlStatementsCleanUp(IDialogSettings settings) {
        super(ControlStatementsCleanUp.getSection(settings, SECTION_NAME), 0);
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return ControlStatementsFix.createCleanUp(compilationUnit, this.isFlag(1), this.isFlag(4), this.isFlag(8), this.isFlag(2));
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    public Map getRequiredOptions() {
        return null;
    }

    public void saveSettings(IDialogSettings settings) {
        super.saveSettings(ControlStatementsCleanUp.getSection(settings, SECTION_NAME));
    }

    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isFlag(1)) {
            result.add(MultiFixMessages.CodeStyleMultiFix_ConvertSingleStatementInControlBodeyToBlock_description);
        }
        if (this.isFlag(2)) {
            result.add(MultiFixMessages.Java50CleanUp_ConvertToEnhancedForLoop_description);
        }
        if (this.isFlag(4)) {
            result.add(MultiFixMessages.ControlStatementsCleanUp_RemoveUnnecessaryBlocks_description);
        }
        if (this.isFlag(8)) {
            result.add(MultiFixMessages.ControlStatementsCleanUp_RemoveUnnecessaryBlocksWithReturnOrThrow_description);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        if (this.isFlag(1)) {
            buf.append("if (obj == null) {\n");
            buf.append("    throw new IllegalArgumentException();\n");
            buf.append("}\n");
            buf.append("if (ids.length > 0) {\n");
            buf.append("    System.out.println(ids[0]);\n");
            buf.append("} else {\n");
            buf.append("    return;\n");
            buf.append("}\n");
        } else if (this.isFlag(4)) {
            buf.append("if (obj == null)\n");
            buf.append("    throw new IllegalArgumentException();\n");
            buf.append("\n");
            buf.append("if (ids.length > 0)\n");
            buf.append("    System.out.println(ids[0]);\n");
            buf.append("else\n");
            buf.append("    return;\n");
            buf.append("\n");
        } else if (this.isFlag(8)) {
            buf.append("if (obj == null)\n");
            buf.append("    throw new IllegalArgumentException();\n");
            buf.append("\n");
            buf.append("if (ids.length > 0) {\n");
            buf.append("    System.out.println(ids[0]);\n");
            buf.append("} else \n");
            buf.append("    return;\n");
            buf.append("\n");
        } else {
            buf.append("if (obj == null) {\n");
            buf.append("    throw new IllegalArgumentException();\n");
            buf.append("}\n");
            buf.append("if (ids.length > 0) {\n");
            buf.append("    System.out.println(ids[0]);\n");
            buf.append("} else \n");
            buf.append("    return;\n");
            buf.append("\n");
        }
        buf.append("\n");
        if (this.isFlag(2)) {
            buf.append("for (int element : ids) {\n");
            buf.append("    double value= element / 2; \n");
            buf.append("    System.out.println(value);\n");
            buf.append("}\n");
        } else {
            buf.append("for (int i = 0; i < ids.length; i++) {\n");
            buf.append("    double value= ids[i] / 2; \n");
            buf.append("    System.out.println(value);\n");
            buf.append("}\n");
        }
        return buf.toString();
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        return false;
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        return -1;
    }

    public int getDefaultFlag() {
        return 0;
    }
}

