/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.actions;

import org.eclipse.ant.internal.ui.debug.model.AntLineBreakpoint;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;

public class ToggleLineBreakpointAction
implements IToggleBreakpointsTarget {
    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        IEditorPart editorPart = (IEditorPart)part;
        IEditorInput editorInput = editorPart.getEditorInput();
        IFile resource = null;
        if (editorInput instanceof IFileEditorInput) {
            resource = ((IFileEditorInput)editorInput).getFile();
        }
        if (resource == null) {
            Display.getCurrent().beep();
            return;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        int lineNumber = textSelection.getStartLine();
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.ant.ui.debug");
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            if (resource.equals((Object)breakpoint.getMarker().getResource()) && ((ILineBreakpoint)breakpoint).getLineNumber() == lineNumber + 1) {
                breakpoint.delete();
                return;
            }
            ++i;
        }
        new AntLineBreakpoint((IResource)resource, lineNumber + 1);
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return selection instanceof ITextSelection;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }
}

