#include "feldspar_array.h"
#include <string.h>

/* Deep array copy */
void copyArray(struct array *to, struct array from)
{
    to->length = from.length;
    to->elemSize = from.elemSize;
    if( from.elemSize == (-1) )
    {
        unsigned i;
        for( i = 0; i < from.length; ++i )
            copyArray( &at(struct array, *to, i), at(struct array, from, i) );
    }
    else
    {
        memcpy( to->buffer, from.buffer, from.length * from.elemSize );
    }
}

/* Deep array copy to a given position */
void copyArrayPos(struct array *to, unsigned pos, struct array from)
{
    to->length = pos + from.length;
    to->elemSize = from.elemSize;
    if( from.elemSize == (-1) )
    {
        unsigned i;
        for( i = 0; i < from.length; ++i )
            copyArray( &at(struct array, *to, i + pos), at(struct array, from, i) );
    }
    else
    {
        memcpy( (char*)(to->buffer) + pos * from.elemSize, from.buffer, from.length * from.elemSize );
    }
}

/* Deep array copy with a given length */
void copyArrayLen(struct array *to, struct array from, unsigned len)
{
    to->length = len;
    to->elemSize = from.elemSize;
    if( from.elemSize == (-1) )
    {
        unsigned i;
        for( i = 0; i < len; ++i )
            copyArray( &at(struct array, *to, i), at(struct array, from, i) );
    }
    else
    {
        memcpy( to->buffer, from.buffer, len * from.elemSize );
    }
}

/* Array length */
unsigned length(struct array arr)
{
    return arr.length;
}

/* (Re)set array length */
void setLength(struct array *arr, unsigned len)
{
    arr->length = len;
}

/* Reset array length by increasing it */
void increaseLength(struct array *arr, unsigned len)
{
    arr->length += len;
}

