/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.lang.reflect.TypeSignature;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Method;
import java.security.MessageDigest;

public class RMIHashes {
    public static long getMethodHash(Method method) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(method.getName());
            stringBuffer.append('(');
            Class[] classArray = method.getParameterTypes();
            for (int i = 0; i < classArray.length; ++i) {
                stringBuffer.append(TypeSignature.getEncodingOfClass(classArray[i]));
            }
            stringBuffer.append(')');
            Class clazz = method.getReturnType();
            if (clazz != Void.TYPE) {
                stringBuffer.append(TypeSignature.getEncodingOfClass(clazz));
            } else {
                stringBuffer.append('V');
            }
            dataOutputStream.writeUTF(stringBuffer.toString());
            dataOutputStream.flush();
            dataOutputStream.close();
            messageDigest.update(byteArrayOutputStream.toByteArray());
            byte[] byArray = messageDigest.digest();
            long l = 0L;
            int n = byArray.length < 8 ? byArray.length : 8;
            for (int i = 0; i < n; ++i) {
                l += ((long)byArray[i] & (long)255) << (8 * i & 0x3F);
            }
            return l;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static long getInterfaceHash(Class clazz) {
        return clazz.hashCode();
    }
}

