/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.jce.sig;

import gnu.java.security.Registry;
import gnu.java.security.key.dss.DSSKeyPairPKCS8Codec;
import gnu.java.security.key.dss.DSSKeyPairX509Codec;
import gnu.java.security.key.dss.DSSPrivateKey;
import gnu.java.security.key.dss.DSSPublicKey;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class DSSKeyFactory
extends KeyFactorySpi {
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DSAPublicKeySpec) {
            DSAPublicKeySpec dSAPublicKeySpec = (DSAPublicKeySpec)keySpec;
            BigInteger bigInteger = dSAPublicKeySpec.getP();
            BigInteger bigInteger2 = dSAPublicKeySpec.getQ();
            BigInteger bigInteger3 = dSAPublicKeySpec.getG();
            BigInteger bigInteger4 = dSAPublicKeySpec.getY();
            return new DSSPublicKey(2, bigInteger, bigInteger2, bigInteger3, bigInteger4);
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            X509EncodedKeySpec x509EncodedKeySpec = (X509EncodedKeySpec)keySpec;
            byte[] byArray = x509EncodedKeySpec.getEncoded();
            try {
                PublicKey publicKey = new DSSKeyPairX509Codec().decodePublicKey(byArray);
                return publicKey;
            }
            catch (RuntimeException runtimeException) {
                throw new InvalidKeySpecException(runtimeException.getMessage(), runtimeException);
            }
        }
        throw new InvalidKeySpecException("Unsupported (public) key specification");
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DSAPrivateKeySpec) {
            DSAPrivateKeySpec dSAPrivateKeySpec = (DSAPrivateKeySpec)keySpec;
            BigInteger bigInteger = dSAPrivateKeySpec.getP();
            BigInteger bigInteger2 = dSAPrivateKeySpec.getQ();
            BigInteger bigInteger3 = dSAPrivateKeySpec.getG();
            BigInteger bigInteger4 = dSAPrivateKeySpec.getX();
            return new DSSPrivateKey(3, bigInteger, bigInteger2, bigInteger3, bigInteger4);
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = (PKCS8EncodedKeySpec)keySpec;
            byte[] byArray = pKCS8EncodedKeySpec.getEncoded();
            try {
                PrivateKey privateKey = new DSSKeyPairPKCS8Codec().decodePrivateKey(byArray);
                return privateKey;
            }
            catch (RuntimeException runtimeException) {
                throw new InvalidKeySpecException(runtimeException.getMessage(), runtimeException);
            }
        }
        throw new InvalidKeySpecException("Unsupported (private) key specification");
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (key instanceof DSAPublicKey) {
            if (clazz.isAssignableFrom(DSSKeyFactory.class$("java.security.spec.DSAPublicKeySpec"))) {
                DSAPublicKey dSAPublicKey = (DSAPublicKey)key;
                BigInteger bigInteger = dSAPublicKey.getParams().getP();
                BigInteger bigInteger2 = dSAPublicKey.getParams().getQ();
                BigInteger bigInteger3 = dSAPublicKey.getParams().getG();
                BigInteger bigInteger4 = dSAPublicKey.getY();
                return new DSAPublicKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3);
            }
            if (clazz.isAssignableFrom(DSSKeyFactory.class$("java.security.spec.X509EncodedKeySpec"))) {
                if (key instanceof DSSPublicKey) {
                    DSSPublicKey dSSPublicKey = (DSSPublicKey)key;
                    byte[] byArray = dSSPublicKey.getEncoded(2);
                    return new X509EncodedKeySpec(byArray);
                }
                if (Registry.X509_ENCODING_SORT_NAME.equalsIgnoreCase(key.getFormat())) {
                    byte[] byArray = key.getEncoded();
                    return new X509EncodedKeySpec(byArray);
                }
                throw new InvalidKeySpecException("Wrong key type or unsupported (public) key specification");
            }
            throw new InvalidKeySpecException("Unsupported (public) key specification");
        }
        if (key instanceof DSAPrivateKey) {
            if (clazz.isAssignableFrom(DSSKeyFactory.class$("java.security.spec.DSAPrivateKeySpec"))) {
                DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)key;
                BigInteger bigInteger = dSAPrivateKey.getParams().getP();
                BigInteger bigInteger5 = dSAPrivateKey.getParams().getQ();
                BigInteger bigInteger6 = dSAPrivateKey.getParams().getG();
                BigInteger bigInteger7 = dSAPrivateKey.getX();
                return new DSAPrivateKeySpec(bigInteger7, bigInteger, bigInteger5, bigInteger6);
            }
            if (clazz.isAssignableFrom(DSSKeyFactory.class$("java.security.spec.PKCS8EncodedKeySpec"))) {
                if (key instanceof DSSPrivateKey) {
                    DSSPrivateKey dSSPrivateKey = (DSSPrivateKey)key;
                    byte[] byArray = dSSPrivateKey.getEncoded(3);
                    return new PKCS8EncodedKeySpec(byArray);
                }
                if (Registry.PKCS8_ENCODING_SHORT_NAME.equalsIgnoreCase(key.getFormat())) {
                    byte[] byArray = key.getEncoded();
                    return new PKCS8EncodedKeySpec(byArray);
                }
                throw new InvalidKeySpecException("Wrong key type or unsupported (private) key specification");
            }
            throw new InvalidKeySpecException("Unsupported (private) key specification");
        }
        throw new InvalidKeySpecException("Wrong key type or unsupported key specification");
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof DSSPublicKey || key instanceof DSSPrivateKey) {
            return key;
        }
        if (key instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)key;
            BigInteger bigInteger = dSAPublicKey.getParams().getP();
            BigInteger bigInteger2 = dSAPublicKey.getParams().getQ();
            BigInteger bigInteger3 = dSAPublicKey.getParams().getG();
            BigInteger bigInteger4 = dSAPublicKey.getY();
            return new DSSPublicKey(2, bigInteger, bigInteger2, bigInteger3, bigInteger4);
        }
        if (key instanceof DSAPrivateKey) {
            DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)key;
            BigInteger bigInteger = dSAPrivateKey.getParams().getP();
            BigInteger bigInteger5 = dSAPrivateKey.getParams().getQ();
            BigInteger bigInteger6 = dSAPrivateKey.getParams().getG();
            BigInteger bigInteger7 = dSAPrivateKey.getX();
            return new DSSPrivateKey(3, bigInteger, bigInteger5, bigInteger6, bigInteger7);
        }
        throw new InvalidKeyException("Wrong key type");
    }
}

