/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.dss;

import gnu.java.security.Registry;
import gnu.java.security.action.GetPropertyAction;
import gnu.java.security.key.dss.DSSKey;
import gnu.java.security.key.dss.DSSKeyPairPKCS8Codec;
import gnu.java.security.key.dss.DSSKeyPairRawCodec;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;

public class DSSPrivateKey
extends DSSKey
implements PrivateKey,
DSAPrivateKey {
    private final BigInteger x;
    private transient String str;

    public DSSPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this(1, bigInteger, bigInteger2, bigInteger3, bigInteger4);
    }

    public DSSPrivateKey(int n, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        super(n == 4 ? 3 : n, bigInteger, bigInteger2, bigInteger3);
        this.x = bigInteger4;
    }

    public static DSSPrivateKey valueOf(byte[] byArray) {
        if (byArray[0] == Registry.MAGIC_RAW_DSS_PRIVATE_KEY[0]) {
            try {
                return (DSSPrivateKey)new DSSKeyPairRawCodec().decodePrivateKey(byArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return (DSSPrivateKey)new DSSKeyPairPKCS8Codec().decodePrivateKey(byArray);
    }

    public BigInteger getX() {
        return this.x;
    }

    public byte[] getEncoded(int n) {
        byte[] byArray;
        switch (n) {
            case 1: {
                byArray = new DSSKeyPairRawCodec().encodePrivateKey(this);
                break;
            }
            case 3: {
                byArray = new DSSKeyPairPKCS8Codec().encodePrivateKey(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported encoding format: " + n);
            }
        }
        return byArray;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof DSAPrivateKey)) {
            return false;
        }
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)object;
        return super.equals(dSAPrivateKey) && this.x.equals(dSAPrivateKey.getX());
    }

    public String toString() {
        if (this.str == null) {
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("line.separator"));
            this.str = new StringBuilder(this.getClass().getName()).append("(").append(super.toString()).append(",").append(string).append("x=0x").append("**...*").append(string).append(")").toString();
        }
        return this.str;
    }
}

