/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.prng;

import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.javax.crypto.prng.CSPRNG;
import java.net.MalformedURLException;
import java.security.SecureRandomSpi;

public class CSPRNGSpi
extends SecureRandomSpi {
    private final IRandom adaptee = CSPRNG.getSystemInstance();

    protected byte[] engineGenerateSeed(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("count must be nonnegative");
        }
        byte[] byArray = new byte[n];
        if (n == 0) {
            return byArray;
        }
        this.engineNextBytes(byArray);
        return byArray;
    }

    protected void engineNextBytes(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        try {
            this.adaptee.nextBytes(byArray, 0, byArray.length);
        }
        catch (LimitReachedException limitReachedException) {
            throw new RuntimeException("random-number generator has been exhausted");
        }
    }

    protected void engineSetSeed(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.adaptee.addRandomBytes(byArray, 0, byArray.length);
    }
}

