/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.gif;

import gnu.javax.imageio.IIOInputStream;
import gnu.javax.imageio.gif.GIFFile;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class GIFImageReader
extends ImageReader {
    private GIFFile file = null;

    protected GIFImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    private void readImage() throws IOException {
        if (this.file != null) {
            return;
        }
        try {
            this.file = this.input instanceof InputStream ? new GIFFile((InputStream)this.input) : new GIFFile(new IIOInputStream((ImageInputStream)this.input));
        }
        catch (GIFFile.GIFException gIFException) {
            throw new IIOException(gIFException.getMessage());
        }
    }

    private IndexColorModel getPalette(int n) {
        GIFFile gIFFile = this.file.getImage(n);
        byte[] byArray = gIFFile.getRawPalette();
        int n2 = gIFFile.getNColors();
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        byte[] byArray4 = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray2[i] = byArray[i * 3];
            byArray3[i] = byArray[i * 3 + 1];
            byArray4[i] = byArray[i * 3 + 2];
        }
        if (gIFFile.hasTransparency()) {
            byte[] byArray5 = new byte[n2];
            for (int i = 0; i < n2; ++i) {
                byArray5[i] = -1;
            }
            byArray5[gIFFile.getTransparentIndex()] = 0;
            return new IndexColorModel(8, n2, byArray2, byArray3, byArray4, byArray5);
        }
        return new IndexColorModel(8, n2, byArray2, byArray3, byArray4);
    }

    private void validateIndex(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.getNumImages(false)) {
            throw new IndexOutOfBoundsException("Invalid image index.");
        }
    }

    public void setInput(Object object) {
        super.setInput(object);
    }

    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
    }

    public void setInput(Object object, boolean bl) {
        super.setInput(object, bl);
        if (!(object instanceof ImageInputStream) && !(object instanceof InputStream)) {
            throw new IllegalArgumentException("Input not an ImageInputStream.");
        }
    }

    private void checkStream() throws IOException {
        if (!(this.input instanceof ImageInputStream) && !(this.input instanceof InputStream)) {
            throw new IllegalStateException("Input not an ImageInputStream or InputStream.");
        }
        if (this.input == null) {
            throw new IllegalStateException("No input stream.");
        }
    }

    public int getWidth(int n) throws IOException {
        this.validateIndex(n);
        return this.file.getImage(n).getWidth();
    }

    public int getHeight(int n) throws IOException {
        this.validateIndex(n);
        return this.file.getImage(n).getHeight();
    }

    public Iterator getImageTypes(int n) {
        this.validateIndex(n);
        return null;
    }

    public int getNumImages(boolean bl) {
        try {
            this.readImage();
        }
        catch (IOException iOException) {
            return 0;
        }
        return this.file.nImages();
    }

    public IIOMetadata getImageMetadata(int n) {
        this.validateIndex(n);
        return null;
    }

    public IIOMetadata getStreamMetadata() {
        return null;
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException, IIOException {
        SampleModel sampleModel;
        this.validateIndex(n);
        GIFFile gIFFile = this.file.getImage(n);
        int n2 = gIFFile.getWidth();
        int n3 = gIFFile.getHeight();
        switch (gIFFile.getNColors()) {
            case 16: {
                sampleModel = new MultiPixelPackedSampleModel(0, n2, n3, 4);
                break;
            }
            case 4: {
                sampleModel = new MultiPixelPackedSampleModel(0, n2, n3, 2);
                break;
            }
            case 2: {
                sampleModel = new MultiPixelPackedSampleModel(0, n2, n3, 1);
                break;
            }
            default: {
                sampleModel = new SinglePixelPackedSampleModel(0, n2, n3, new int[]{255});
            }
        }
        DataBufferByte dataBufferByte = new DataBufferByte(gIFFile.getRawImage(), n2 * n3, 0);
        WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, dataBufferByte, null);
        return new BufferedImage(this.getPalette(n), writableRaster, false, null);
    }
}

