/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteBufferHelper;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.VMDirectByteBuffer;

final class LongViewBufferImpl
extends LongBuffer {
    private int offset;
    private ByteBuffer bb;
    private boolean readOnly;
    private ByteOrder endian;

    LongViewBufferImpl(ByteBuffer byteBuffer, int n) {
        super(n, n, 0, -1);
        this.bb = byteBuffer;
        this.offset = byteBuffer.position();
        this.readOnly = byteBuffer.isReadOnly();
        this.endian = byteBuffer.order();
        if (byteBuffer.isDirect()) {
            this.address = VMDirectByteBuffer.adjustAddress(byteBuffer.address, this.offset);
        }
    }

    public LongViewBufferImpl(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, boolean bl, ByteOrder byteOrder) {
        super(n2, n3, n4, n5);
        this.bb = byteBuffer;
        this.offset = n;
        this.readOnly = bl;
        this.endian = byteOrder;
        if (byteBuffer.isDirect()) {
            this.address = VMDirectByteBuffer.adjustAddress(byteBuffer.address, n);
        }
    }

    public long get() {
        int n = this.position();
        long l = ByteBufferHelper.getLong(this.bb, (n << 3) + this.offset, this.endian);
        this.position(n + 1);
        return l;
    }

    public long get(int n) {
        return ByteBufferHelper.getLong(this.bb, (n << 3) + this.offset, this.endian);
    }

    public LongBuffer put(long l) {
        int n = this.position();
        ByteBufferHelper.putLong(this.bb, (n << 3) + this.offset, l, this.endian);
        this.position(n + 1);
        return this;
    }

    public LongBuffer put(int n, long l) {
        ByteBufferHelper.putLong(this.bb, (n << 3) + this.offset, l, this.endian);
        return this;
    }

    public LongBuffer compact() {
        if (this.position() > 0) {
            int n = this.limit() - this.position();
            this.bb.shiftDown(this.offset, this.offset + 8 * this.position(), 8 * n);
            this.position(n);
            this.limit(this.capacity());
        } else {
            this.position(this.limit());
            this.limit(this.capacity());
        }
        return this;
    }

    public LongBuffer slice() {
        return new LongViewBufferImpl(this.bb, (this.position() >> 3) + this.offset, this.remaining(), this.remaining(), 0, -1, this.readOnly, this.endian);
    }

    LongBuffer duplicate(boolean bl) {
        int n = this.position();
        this.reset();
        int n2 = this.position();
        this.position(n);
        return new LongViewBufferImpl(this.bb, this.offset, this.capacity(), this.limit(), n, n2, bl, this.endian);
    }

    public LongBuffer duplicate() {
        return this.duplicate(this.readOnly);
    }

    public LongBuffer asReadOnlyBuffer() {
        return this.duplicate(true);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isDirect() {
        return this.bb.isDirect();
    }

    public ByteOrder order() {
        return this.endian;
    }
}

