/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import gnu.javax.swing.tree.GnuPath;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.VariableHeightLayoutCache;

public class FixedHeightLayoutCache
extends VariableHeightLayoutCache {
    Set expanded;
    Hashtable nodes;
    Hashtable row2node;
    boolean dirty;
    int totalHeight;
    int maximalWidth;

    private /* synthetic */ void finit$() {
        this.expanded = new HashSet();
        this.nodes = new Hashtable();
        this.row2node = new Hashtable();
    }

    public FixedHeightLayoutCache() {
        this.finit$();
    }

    public int getRowCount() {
        if (this.dirty) {
            this.update();
        }
        return this.row2node.size();
    }

    private final void update() {
        this.nodes.clear();
        this.row2node.clear();
        this.maximalWidth = 0;
        this.totalHeight = 0;
        Object object = this.treeModel.getRoot();
        if (this.rootVisible) {
            this.countRows(object, null, 0);
        } else {
            int n = this.treeModel.getChildCount(object);
            for (int i = 0; i < n; ++i) {
                Object object2 = this.treeModel.getChild(object, i);
                this.countRows(object2, object, 0);
            }
        }
        this.dirty = false;
    }

    private final void countRows(Object object, Object object2, int n) {
        Integer n2 = new Integer(this.row2node.size());
        this.row2node.put(n2, object);
        NodeRecord nodeRecord = new NodeRecord(this, n2, n, object, object2);
        this.nodes.put(object, nodeRecord);
        if (this.expanded.contains(object)) {
            int n3 = this.treeModel.getChildCount(object);
            int n4 = n + 1;
            for (int i = 0; i < n3; ++i) {
                Object object3 = this.treeModel.getChild(object, i);
                this.countRows(object3, object, n4);
            }
        }
    }

    public void invalidatePathBounds(TreePath treePath) {
        NodeRecord nodeRecord = (NodeRecord)this.nodes.get(treePath.getLastPathComponent());
        if (nodeRecord != null) {
            nodeRecord.bounds = null;
        }
    }

    public void invalidateSizes() {
        this.dirty = true;
    }

    public void setExpandedState(TreePath treePath, boolean bl) {
        if (bl) {
            this.expanded.add(treePath.getLastPathComponent());
        } else {
            this.expanded.remove(treePath.getLastPathComponent());
        }
        this.dirty = true;
    }

    public boolean isExpanded(TreePath treePath) {
        return this.expanded.contains(treePath.getLastPathComponent());
    }

    public Rectangle getBounds(TreePath treePath, Rectangle rectangle) {
        Object object;
        NodeRecord nodeRecord;
        if (treePath == null) {
            return null;
        }
        if (this.dirty) {
            this.update();
        }
        if ((nodeRecord = (NodeRecord)this.nodes.get(object = treePath.getLastPathComponent())) == null) {
            rectangle.height = 0;
            rectangle.width = 0;
            rectangle.y = 0;
            rectangle.x = 0;
        } else {
            if (nodeRecord.bounds == null) {
                Rectangle rectangle2;
                nodeRecord.bounds = rectangle2 = this.getNodeDimensions(object, nodeRecord.row, nodeRecord.depth, nodeRecord.isExpanded, rectangle);
            }
            rectangle.setRect(nodeRecord.bounds);
        }
        return rectangle;
    }

    public TreePath getPathForRow(int n) {
        Object object;
        if (this.dirty) {
            this.update();
        }
        if ((object = this.row2node.get(new Integer(n))) == null) {
            return null;
        }
        NodeRecord nodeRecord = (NodeRecord)this.nodes.get(object);
        return nodeRecord.getPath();
    }

    public int getRowForPath(TreePath treePath) {
        NodeRecord nodeRecord;
        if (treePath == null) {
            return -1;
        }
        if (this.dirty) {
            this.update();
        }
        if ((nodeRecord = (NodeRecord)this.nodes.get(treePath.getLastPathComponent())) == null) {
            return -1;
        }
        return nodeRecord.row;
    }

    public TreePath getPathClosestTo(int n, int n2) {
        if (this.dirty) {
            this.update();
        }
        NodeRecord nodeRecord = null;
        Enumeration enumeration = this.nodes.elements();
        int n3 = Integer.MAX_VALUE;
        while (enumeration.hasMoreElements() && n3 > 0) {
            NodeRecord nodeRecord2 = (NodeRecord)enumeration.nextElement();
            if (nodeRecord == null) {
                nodeRecord = nodeRecord2;
                n3 = this.distance(nodeRecord2.getBounds(), n, n2);
                continue;
            }
            int n4 = this.distance(nodeRecord2.getBounds(), n, n2);
            if (n4 >= n3) continue;
            nodeRecord = nodeRecord2;
            n3 = n4;
        }
        if (nodeRecord == null) {
            return null;
        }
        return nodeRecord.getPath();
    }

    int distance(Rectangle rectangle, int n, int n2) {
        if (n2 < rectangle.y) {
            return rectangle.y - n2;
        }
        if (n2 > rectangle.y + rectangle.height) {
            return n2 - (rectangle.y + rectangle.height);
        }
        return 0;
    }

    public int getVisibleChildCount(TreePath treePath) {
        if (this.isExpanded(treePath)) {
            return 0;
        }
        return this.treeModel.getChildCount(treePath.getLastPathComponent());
    }

    public Enumeration getVisiblePathsFrom(TreePath treePath) {
        if (this.dirty) {
            this.update();
        }
        Vector vector = new Vector(treePath.getPathCount());
        for (int i = 0; i < treePath.getPathCount(); ++i) {
            Object object = treePath.getPathComponent(i);
            NodeRecord nodeRecord = (NodeRecord)this.nodes.get(object);
            if (nodeRecord.row < 0) continue;
            vector.add(object);
        }
        return vector.elements();
    }

    public boolean getExpandedState(TreePath treePath) {
        return this.expanded.contains(treePath.getLastPathComponent());
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.dirty = true;
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.dirty = true;
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.dirty = true;
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.dirty = true;
    }

    public void setModel(TreeModel treeModel) {
        this.treeModel = treeModel;
        this.expanded.add(this.treeModel.getRoot());
        this.dirty = true;
    }

    public void setRootVisible(boolean bl) {
        this.rootVisible = bl;
        this.dirty = true;
    }

    public int getPreferredHeight() {
        if (this.dirty) {
            this.update();
        }
        this.totalHeight = 0;
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            NodeRecord nodeRecord = (NodeRecord)enumeration.nextElement();
            Rectangle rectangle = nodeRecord.getBounds();
            this.totalHeight += rectangle.height;
        }
        return this.totalHeight;
    }

    public int getPreferredWidth(Rectangle rectangle) {
        if (this.dirty) {
            this.update();
        }
        this.maximalWidth = 0;
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            NodeRecord nodeRecord = (NodeRecord)enumeration.nextElement();
            Rectangle rectangle2 = nodeRecord.getBounds();
            if (rectangle2.x + rectangle2.width <= this.maximalWidth) continue;
            this.maximalWidth = rectangle2.x + rectangle2.width;
        }
        return this.maximalWidth;
    }

    protected boolean isFixedRowHeight() {
        return true;
    }

    class NodeRecord {
        private /* synthetic */ FixedHeightLayoutCache this$0;
        final int row;
        final int depth;
        final Object parent;
        final Object node;
        final boolean isExpanded;
        Rectangle bounds;
        private TreePath path;

        NodeRecord(FixedHeightLayoutCache fixedHeightLayoutCache, int n, int n2, Object object, Object object2) {
            this.this$0 = fixedHeightLayoutCache;
            this.row = n;
            this.depth = n2;
            this.parent = object2;
            this.node = object;
            this.isExpanded = fixedHeightLayoutCache.expanded.contains(object);
        }

        TreePath getPath() {
            if (this.path == null) {
                int n;
                int n2;
                boolean bl = false;
                if (this.parent != null && (n2 = this.this$0.treeModel.getChildCount(this.parent)) > 0 && (n = this.this$0.treeModel.getIndexOfChild(this.parent, this.node)) == n2 - 1) {
                    bl = true;
                }
                LinkedList linkedList = new LinkedList();
                NodeRecord nodeRecord = this;
                while (nodeRecord != null) {
                    linkedList.addFirst(nodeRecord.node);
                    if (nodeRecord.parent != null) {
                        Object object = nodeRecord.parent;
                        nodeRecord = (NodeRecord)this.this$0.nodes.get(object);
                        if (nodeRecord != null) continue;
                        linkedList.addFirst(object);
                        continue;
                    }
                    nodeRecord = null;
                }
                this.path = new GnuPath(linkedList.toArray(), bl);
            }
            return this.path;
        }

        Rectangle getBounds() {
            if (this.bounds == null) {
                this.bounds = this.this$0.getNodeDimensions(this.node, this.row, this.depth, this.isExpanded, new Rectangle());
            }
            return this.bounds;
        }
    }
}

