/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.ext.Extension;
import gnu.java.security.x509.ext.GeneralSubtree;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameConstraints
extends Extension.Value {
    public static final OID ID = new OID("2.5.29.30");
    private List<GeneralSubtree> permittedSubtrees;
    private List<GeneralSubtree> excludedSubtrees;

    public NameConstraints(byte[] encoded) throws IOException {
        super(encoded);
        DERReader der = new DERReader(encoded);
        DERValue value = der.read();
        if (!value.isConstructed()) {
            throw new IOException("malformed NameConstraints");
        }
        this.permittedSubtrees = new LinkedList<GeneralSubtree>();
        this.excludedSubtrees = new LinkedList<GeneralSubtree>();
        int len = 0;
        if (len < value.getLength()) {
            DERValue subtrees = der.read();
            if (subtrees.getTag() == 0) {
                DERValue subtree;
                int len2 = 0;
                while (len2 < subtrees.getLength()) {
                    subtree = der.read();
                    this.permittedSubtrees.add(new GeneralSubtree(subtree.getEncoded()));
                    der.skip(subtree.getLength());
                    len2 += subtree.getEncodedLength();
                }
                if ((len += subtrees.getEncodedLength()) < value.getLength()) {
                    subtrees = der.read();
                    if (subtrees.getTag() != 1) {
                        throw new IOException("unexpected tag " + subtrees.getTag() + " (expecting 1 for excludedSubtrees)");
                    }
                    len2 = 0;
                    while (len2 < subtrees.getLength()) {
                        subtree = der.read();
                        this.excludedSubtrees.add(new GeneralSubtree(subtree.getEncoded()));
                        der.skip(subtree.getLength());
                        len2 += subtree.getEncodedLength();
                    }
                }
            } else if (subtrees.getTag() == 1) {
                int len2 = 0;
                while (len2 < subtrees.getLength()) {
                    DERValue subtree = der.read();
                    this.excludedSubtrees.add(new GeneralSubtree(subtree.getEncoded()));
                    der.skip(subtree.getLength());
                    len2 += subtree.getEncodedLength();
                }
            } else {
                throw new IOException("unexpected tag " + subtrees.getTag() + " (expecting 0 or 1)");
            }
        }
    }

    public List<GeneralSubtree> permittedSubtrees() {
        return Collections.unmodifiableList(this.permittedSubtrees);
    }

    public List<GeneralSubtree> excludedSubtrees() {
        return Collections.unmodifiableList(this.excludedSubtrees);
    }

    @Override
    public String toString() {
        return String.valueOf(NameConstraints.class.getName()) + " [ permittedSubtrees=" + this.permittedSubtrees + "; excludedSubtrees=" + this.excludedSubtrees + " ]";
    }
}

