/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mode;

import gnu.java.lang.CPStringBuilder;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.mode.IMode;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class BaseMode
implements IMode {
    protected String name;
    protected int state;
    protected IBlockCipher cipher;
    protected int cipherBlockSize;
    protected int modeBlockSize;
    protected byte[] iv;
    protected Object lock = new Object();

    protected BaseMode(String name, IBlockCipher underlyingCipher, int cipherBlockSize) {
        this.name = name;
        this.cipher = underlyingCipher;
        this.cipherBlockSize = cipherBlockSize;
        this.state = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(byte[] in, int inOffset, byte[] out, int outOffset) throws IllegalStateException {
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case 1: {
                    this.encryptBlock(in, inOffset, out, outOffset);
                    break;
                }
                case 2: {
                    this.decryptBlock(in, inOffset, out, outOffset);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public String name() {
        return new CPStringBuilder(this.name).append('(').append(this.cipher.name()).append(')').toString();
    }

    public int defaultBlockSize() {
        return this.cipherBlockSize;
    }

    public int defaultKeySize() {
        return this.cipher.defaultKeySize();
    }

    public Iterator blockSizes() {
        ArrayList<Integer> al = new ArrayList<Integer>();
        al.add(this.cipherBlockSize);
        return Collections.unmodifiableList(al).iterator();
    }

    public Iterator keySizes() {
        return this.cipher.keySizes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Map attributes) throws InvalidKeyException, IllegalStateException {
        Object object = this.lock;
        synchronized (object) {
            Integer bs;
            if (this.state != -1) {
                throw new IllegalStateException();
            }
            Integer want = (Integer)attributes.get("gnu.crypto.mode.state");
            if (want != null) {
                switch (want) {
                    case 1: {
                        this.state = 1;
                        break;
                    }
                    case 2: {
                        this.state = 2;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            this.modeBlockSize = (bs = (Integer)attributes.get("gnu.crypto.mode.block.size")) == null ? this.cipherBlockSize : bs;
            byte[] iv = (byte[])attributes.get("gnu.crypto.mode.iv");
            this.iv = iv != null ? (byte[])iv.clone() : new byte[this.modeBlockSize];
            this.cipher.init(attributes);
            this.setup();
        }
    }

    public int currentBlockSize() {
        if (this.state == -1) {
            throw new IllegalStateException();
        }
        return this.modeBlockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.state = -1;
            this.iv = null;
            this.cipher.reset();
            this.teardown();
        }
    }

    public boolean selfTest() {
        Iterator kit = this.keySizes();
        while (kit.hasNext()) {
            int ks = (Integer)kit.next();
            Iterator bit = this.blockSizes();
            while (bit.hasNext()) {
                if (this.testSymmetry(ks, (Integer)bit.next())) continue;
                return false;
            }
        }
        return true;
    }

    public abstract Object clone();

    public abstract void setup();

    public abstract void teardown();

    public abstract void encryptBlock(byte[] var1, int var2, byte[] var3, int var4);

    public abstract void decryptBlock(byte[] var1, int var2, byte[] var3, int var4);

    private boolean testSymmetry(int ks, int bs) {
        try {
            IMode mode = (IMode)this.clone();
            byte[] iv = new byte[this.cipherBlockSize];
            byte[] k = new byte[ks];
            int i = 0;
            while (i < ks) {
                k[i] = (byte)i;
                ++i;
            }
            int blockCount = 5;
            int limit = blockCount * bs;
            byte[] pt = new byte[limit];
            i = 0;
            while (i < limit) {
                pt[i] = (byte)i;
                ++i;
            }
            byte[] ct = new byte[limit];
            byte[] cpt = new byte[limit];
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("gnu.crypto.cipher.key.material", k);
            map.put("gnu.crypto.cipher.block.size", this.cipherBlockSize);
            map.put("gnu.crypto.mode.state", 1);
            map.put("gnu.crypto.mode.iv", iv);
            map.put("gnu.crypto.mode.block.size", bs);
            mode.reset();
            mode.init(map);
            i = 0;
            while (i < blockCount) {
                mode.update(pt, i * bs, ct, i * bs);
                ++i;
            }
            mode.reset();
            map.put("gnu.crypto.mode.state", 2);
            mode.init(map);
            i = 0;
            while (i < blockCount) {
                mode.update(ct, i * bs, cpt, i * bs);
                ++i;
            }
            return Arrays.equals(pt, cpt);
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
            return false;
        }
    }
}

