/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPException;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.IIOImage;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class BMPFileHeader {
    private static final short bfType = 16973;
    protected long bfSize;
    protected long bfOffBits;
    public static final int SIZE = 14;
    private static final int BITMAPINFOHEADER_SIZE = 40;

    public BMPFileHeader(ImageInputStream in) throws IOException, BMPException {
        byte[] data = new byte[14];
        if (in.read(data) != 14) {
            throw new IOException("Couldn't read header.");
        }
        ByteBuffer buf = ByteBuffer.wrap(data);
        if (buf.getShort(0) != 16973) {
            throw new BMPException("Not a BMP file.");
        }
        buf.order(ByteOrder.LITTLE_ENDIAN);
        this.bfSize = (long)buf.getInt(2) & 0xFFFFFFFFFFFFFFFFL;
        this.bfOffBits = (long)buf.getInt(10) & 0xFFFFFFFFFFFFFFFFL;
    }

    public BMPFileHeader(ImageOutputStream out, IIOImage im) throws IOException {
        RenderedImage img = im.getRenderedImage();
        int w = img.getWidth();
        int h = img.getHeight();
        this.bfOffBits = 54L;
        this.bfSize = (long)(w * h * 3 + (4 - w * 3 % 4) * h) + this.bfOffBits;
        this.write(out);
    }

    public void write(ImageOutputStream out) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(14);
        buf.putShort(0, (short)16973);
        buf.putInt(2, (int)(this.bfSize & 0xFFFFFFFFFFFFFFFFL));
        buf.putInt(6, 0);
        buf.putInt(7, (int)(this.bfOffBits & 0xFFFFFFFFFFFFFFFFL));
        out.write(buf.array());
    }

    public void setSize(long size) {
        this.bfSize = size;
    }

    public void setOffset(long offset) {
        this.bfOffBits = offset;
    }

    public long getSize() {
        return this.bfSize;
    }

    public long getOffset() {
        return this.bfOffBits;
    }
}

