/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.gif;

import gnu.javax.imageio.IIOInputStream;
import gnu.javax.imageio.gif.GIFFile;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class GIFImageReader
extends ImageReader {
    private GIFFile file = null;

    protected GIFImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    private void readImage() throws IOException {
        if (this.file != null) {
            return;
        }
        try {
            this.file = this.input instanceof InputStream ? new GIFFile((InputStream)this.input) : new GIFFile(new IIOInputStream((ImageInputStream)this.input));
        }
        catch (GIFFile.GIFException ge) {
            throw new IIOException(ge.getMessage());
        }
    }

    private IndexColorModel getPalette(int index) {
        GIFFile f = this.file.getImage(index);
        byte[] data = f.getRawPalette();
        int nc = f.getNColors();
        byte[] r = new byte[nc];
        byte[] g = new byte[nc];
        byte[] b = new byte[nc];
        int i = 0;
        while (i < nc) {
            r[i] = data[i * 3];
            g[i] = data[i * 3 + 1];
            b[i] = data[i * 3 + 2];
            ++i;
        }
        if (f.hasTransparency()) {
            byte[] a = new byte[nc];
            int i2 = 0;
            while (i2 < nc) {
                a[i2] = -1;
                ++i2;
            }
            a[f.getTransparentIndex()] = 0;
            return new IndexColorModel(8, nc, r, g, b, a);
        }
        return new IndexColorModel(8, nc, r, g, b);
    }

    private void validateIndex(int imageIndex) throws IndexOutOfBoundsException {
        if (imageIndex < 0 || imageIndex >= this.getNumImages(false)) {
            throw new IndexOutOfBoundsException("Invalid image index.");
        }
    }

    public void setInput(Object input) {
        super.setInput(input);
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
    }

    public void setInput(Object input, boolean isStreamable) {
        super.setInput(input, isStreamable);
        if (!(input instanceof ImageInputStream) && !(input instanceof InputStream)) {
            throw new IllegalArgumentException("Input not an ImageInputStream.");
        }
    }

    private void checkStream() throws IOException {
        if (!(this.input instanceof ImageInputStream) && !(this.input instanceof InputStream)) {
            throw new IllegalStateException("Input not an ImageInputStream or InputStream.");
        }
        if (this.input == null) {
            throw new IllegalStateException("No input stream.");
        }
    }

    public int getWidth(int imageIndex) throws IOException {
        this.validateIndex(imageIndex);
        return this.file.getImage(imageIndex).getWidth();
    }

    public int getHeight(int imageIndex) throws IOException {
        this.validateIndex(imageIndex);
        return this.file.getImage(imageIndex).getHeight();
    }

    public Iterator getImageTypes(int imageIndex) {
        this.validateIndex(imageIndex);
        return null;
    }

    public int getNumImages(boolean allowSearch) {
        try {
            this.readImage();
        }
        catch (IOException iOException) {
            return 0;
        }
        return this.file.nImages();
    }

    public IIOMetadata getImageMetadata(int imageIndex) {
        this.validateIndex(imageIndex);
        return null;
    }

    public IIOMetadata getStreamMetadata() {
        return null;
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException, IIOException {
        SampleModel sm;
        this.validateIndex(imageIndex);
        GIFFile f = this.file.getImage(imageIndex);
        int width = f.getWidth();
        int height = f.getHeight();
        switch (f.getNColors()) {
            case 16: {
                sm = new MultiPixelPackedSampleModel(0, width, height, 4);
                break;
            }
            case 4: {
                sm = new MultiPixelPackedSampleModel(0, width, height, 2);
                break;
            }
            case 2: {
                sm = new MultiPixelPackedSampleModel(0, width, height, 1);
                break;
            }
            default: {
                sm = new SinglePixelPackedSampleModel(0, width, height, new int[]{255});
            }
        }
        DataBufferByte db = new DataBufferByte(f.getRawImage(), width * height, 0);
        WritableRaster raster = Raster.createWritableRaster(sm, db, null);
        return new BufferedImage(this.getPalette(imageIndex), raster, false, null);
    }
}

