/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.gcj.RawData;
import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.FloatBufferImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FloatBuffer
extends Buffer
implements Comparable<FloatBuffer> {
    final int array_offset;
    final float[] backing_buffer;

    FloatBuffer(int capacity, int limit, int position, int mark, RawData address, float[] backing_buffer, int array_offset) {
        super(capacity, limit, position, mark, address);
        this.backing_buffer = backing_buffer;
        this.array_offset = array_offset;
    }

    public static FloatBuffer allocate(int capacity) {
        return new FloatBufferImpl(capacity);
    }

    public static final FloatBuffer wrap(float[] array, int offset, int length) {
        return new FloatBufferImpl(array, 0, array.length, offset + length, offset, -1, false);
    }

    public static final FloatBuffer wrap(float[] array) {
        return FloatBuffer.wrap(array, 0, array.length);
    }

    public FloatBuffer get(float[] dst, int offset, int length) {
        FloatBuffer.checkArraySize(dst.length, offset, length);
        this.checkForUnderflow(length);
        int i = offset;
        while (i < offset + length) {
            dst[i] = this.get();
            ++i;
        }
        return this;
    }

    public FloatBuffer get(float[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public FloatBuffer put(FloatBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        this.checkForOverflow(src.remaining());
        if (src.remaining() > 0) {
            float[] toPut = new float[src.remaining()];
            src.get(toPut);
            this.put(toPut);
        }
        return this;
    }

    public FloatBuffer put(float[] src, int offset, int length) {
        FloatBuffer.checkArraySize(src.length, offset, length);
        this.checkForOverflow(length);
        int i = offset;
        while (i < offset + length) {
            this.put(src[i]);
            ++i;
        }
        return this;
    }

    public final FloatBuffer put(float[] src) {
        return this.put(src, 0, src.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null && !this.isReadOnly();
    }

    public final float[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.array_offset;
    }

    public int hashCode() {
        int hashCode = Float.floatToIntBits(this.get(this.position())) + 31;
        int multiplier = 1;
        int i = this.position() + 1;
        while (i < this.limit()) {
            hashCode += (Float.floatToIntBits(this.get(i)) + 30) * (multiplier *= 31);
            ++i;
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FloatBuffer) {
            return this.compareTo((FloatBuffer)obj) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(FloatBuffer other) {
        int num = Math.min(this.remaining(), other.remaining());
        int pos_this = this.position();
        int pos_other = other.position();
        int count = 0;
        while (count < num) {
            float b;
            float a;
            if ((a = this.get(pos_this++)) != (b = other.get(pos_other++))) {
                if (a < b) {
                    return -1;
                }
                return 1;
            }
            ++count;
        }
        return this.remaining() - other.remaining();
    }

    public abstract ByteOrder order();

    public abstract float get();

    public abstract FloatBuffer put(float var1);

    public abstract float get(int var1);

    public abstract FloatBuffer put(int var1, float var2);

    public abstract FloatBuffer compact();

    public abstract boolean isDirect();

    public abstract FloatBuffer slice();

    public abstract FloatBuffer duplicate();

    public abstract FloatBuffer asReadOnlyBuffer();
}

