/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.VMAccessController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AccessController {
    private AccessController() {
    }

    public static void checkPermission(Permission perm) throws AccessControlException {
        AccessController.getContext().checkPermission(perm);
    }

    public static <T> T doPrivileged(PrivilegedAction<T> action) {
        VMAccessController.pushContext(null);
        try {
            T t = action.run();
            return t;
        }
        finally {
            VMAccessController.popContext();
        }
    }

    public static <T> T doPrivileged(PrivilegedAction<T> action, AccessControlContext context) {
        VMAccessController.pushContext(context);
        try {
            T t = action.run();
            return t;
        }
        finally {
            VMAccessController.popContext();
        }
    }

    public static <T> T doPrivileged(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        VMAccessController.pushContext(null);
        try {
            T t = action.run();
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            VMAccessController.popContext();
        }
    }

    public static <T> T doPrivileged(PrivilegedExceptionAction<T> action, AccessControlContext context) throws PrivilegedActionException {
        VMAccessController.pushContext(context);
        try {
            T t = action.run();
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            VMAccessController.popContext();
        }
    }

    public static AccessControlContext getContext() {
        return VMAccessController.getContext();
    }
}

