/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.locks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractOwnableSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueuedSynchronizer
extends AbstractOwnableSynchronizer
implements Serializable {
    private static final long serialVersionUID = 7373984972572414691L;
    private volatile transient Node head;
    private volatile transient Node tail;
    private volatile int state;
    static final long spinForTimeoutThreshold = 1000L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long stateOffset;
    private static final long headOffset;
    private static final long tailOffset;
    private static final long waitStatusOffset;

    static {
        try {
            stateOffset = unsafe.objectFieldOffset(AbstractQueuedSynchronizer.class.getDeclaredField("state"));
            headOffset = unsafe.objectFieldOffset(AbstractQueuedSynchronizer.class.getDeclaredField("head"));
            tailOffset = unsafe.objectFieldOffset(AbstractQueuedSynchronizer.class.getDeclaredField("tail"));
            waitStatusOffset = unsafe.objectFieldOffset(Node.class.getDeclaredField("waitStatus"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    protected AbstractQueuedSynchronizer() {
    }

    protected final int getState() {
        return this.state;
    }

    protected final void setState(int newState) {
        this.state = newState;
    }

    protected final boolean compareAndSetState(int expect, int update) {
        return unsafe.compareAndSwapInt(this, stateOffset, expect, update);
    }

    private Node enq(Node node2) {
        Node t;
        while (true) {
            if ((t = this.tail) == null) {
                Node h = new Node();
                h.next = node2;
                node2.prev = h;
                if (!this.compareAndSetHead(h)) continue;
                this.tail = node2;
                return h;
            }
            node2.prev = t;
            if (this.compareAndSetTail(t, node2)) break;
        }
        t.next = node2;
        return t;
    }

    private Node addWaiter(Node mode) {
        Node node2 = new Node(Thread.currentThread(), mode);
        Node pred = this.tail;
        if (pred != null) {
            node2.prev = pred;
            if (this.compareAndSetTail(pred, node2)) {
                pred.next = node2;
                return node2;
            }
        }
        this.enq(node2);
        return node2;
    }

    private void setHead(Node node2) {
        this.head = node2;
        node2.thread = null;
        node2.prev = null;
    }

    private void unparkSuccessor(Node node2) {
        AbstractQueuedSynchronizer.compareAndSetWaitStatus(node2, -1, 0);
        Node s = node2.next;
        if (s == null || s.waitStatus > 0) {
            s = null;
            Node t = this.tail;
            while (t != null && t != node2) {
                if (t.waitStatus <= 0) {
                    s = t;
                }
                t = t.prev;
            }
        }
        if (s != null) {
            LockSupport.unpark(s.thread);
        }
    }

    private void setHeadAndPropagate(Node node2, int propagate) {
        Node s;
        this.setHead(node2);
        if (propagate > 0 && node2.waitStatus != 0 && ((s = node2.next) == null || s.isShared())) {
            this.unparkSuccessor(node2);
        }
    }

    private void cancelAcquire(Node node2) {
        if (node2 != null) {
            node2.thread = null;
            node2.waitStatus = 1;
            this.unparkSuccessor(node2);
        }
    }

    private static boolean shouldParkAfterFailedAcquire(Node pred, Node node2) {
        int s = pred.waitStatus;
        if (s < 0) {
            return true;
        }
        if (s > 0) {
            node2.prev = pred.prev;
        } else {
            AbstractQueuedSynchronizer.compareAndSetWaitStatus(pred, 0, -1);
        }
        return false;
    }

    private static void selfInterrupt() {
        Thread.currentThread().interrupt();
    }

    private final boolean parkAndCheckInterrupt() {
        LockSupport.park(this);
        return Thread.interrupted();
    }

    final boolean acquireQueued(Node node2, int arg) {
        try {
            boolean interrupted = false;
            while (true) {
                Node p;
                if ((p = node2.predecessor()) == this.head && this.tryAcquire(arg)) {
                    this.setHead(node2);
                    p.next = null;
                    return interrupted;
                }
                if (!AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(p, node2) || !this.parkAndCheckInterrupt()) continue;
                interrupted = true;
            }
        }
        catch (RuntimeException ex) {
            this.cancelAcquire(node2);
            throw ex;
        }
    }

    private void doAcquireInterruptibly(int arg) throws InterruptedException {
        Node node2 = this.addWaiter(Node.EXCLUSIVE);
        try {
            Node p;
            do {
                if ((p = node2.predecessor()) != this.head || !this.tryAcquire(arg)) continue;
                this.setHead(node2);
                p.next = null;
                return;
            } while (!AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(p, node2) || !this.parkAndCheckInterrupt());
        }
        catch (RuntimeException ex) {
            this.cancelAcquire(node2);
            throw ex;
        }
        this.cancelAcquire(node2);
        throw new InterruptedException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doAcquireNanos(int arg, long nanosTimeout) throws InterruptedException {
        long lastTime = System.nanoTime();
        Node node2 = this.addWaiter(Node.EXCLUSIVE);
        try {
            do {
                Node p;
                if ((p = node2.predecessor()) == this.head && this.tryAcquire(arg)) {
                    this.setHead(node2);
                    p.next = null;
                    return true;
                }
                if (nanosTimeout <= 0L) {
                    this.cancelAcquire(node2);
                    return false;
                }
                if (nanosTimeout > 1000L && AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(p, node2)) {
                    LockSupport.parkNanos(this, nanosTimeout);
                }
                long now = System.nanoTime();
                nanosTimeout -= now - lastTime;
                lastTime = now;
            } while (!Thread.interrupted());
        }
        catch (RuntimeException ex) {
            this.cancelAcquire(node2);
            throw ex;
        }
        this.cancelAcquire(node2);
        throw new InterruptedException();
    }

    private void doAcquireShared(int arg) {
        Node node2 = this.addWaiter(Node.SHARED);
        try {
            boolean interrupted = false;
            while (true) {
                int r;
                Node p;
                if ((p = node2.predecessor()) == this.head && (r = this.tryAcquireShared(arg)) >= 0) {
                    this.setHeadAndPropagate(node2, r);
                    p.next = null;
                    if (interrupted) {
                        AbstractQueuedSynchronizer.selfInterrupt();
                    }
                    return;
                }
                if (!AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(p, node2) || !this.parkAndCheckInterrupt()) continue;
                interrupted = true;
            }
        }
        catch (RuntimeException ex) {
            this.cancelAcquire(node2);
            throw ex;
        }
    }

    private void doAcquireSharedInterruptibly(int arg) throws InterruptedException {
        Node node2 = this.addWaiter(Node.SHARED);
        try {
            Node p;
            do {
                int r;
                if ((p = node2.predecessor()) != this.head || (r = this.tryAcquireShared(arg)) < 0) continue;
                this.setHeadAndPropagate(node2, r);
                p.next = null;
                return;
            } while (!AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(p, node2) || !this.parkAndCheckInterrupt());
        }
        catch (RuntimeException ex) {
            this.cancelAcquire(node2);
            throw ex;
        }
        this.cancelAcquire(node2);
        throw new InterruptedException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doAcquireSharedNanos(int arg, long nanosTimeout) throws InterruptedException {
        long lastTime = System.nanoTime();
        Node node2 = this.addWaiter(Node.SHARED);
        try {
            do {
                int r;
                Node p;
                if ((p = node2.predecessor()) == this.head && (r = this.tryAcquireShared(arg)) >= 0) {
                    this.setHeadAndPropagate(node2, r);
                    p.next = null;
                    return true;
                }
                if (nanosTimeout <= 0L) {
                    this.cancelAcquire(node2);
                    return false;
                }
                if (nanosTimeout > 1000L && AbstractQueuedSynchronizer.shouldParkAfterFailedAcquire(p, node2)) {
                    LockSupport.parkNanos(this, nanosTimeout);
                }
                long now = System.nanoTime();
                nanosTimeout -= now - lastTime;
                lastTime = now;
            } while (!Thread.interrupted());
        }
        catch (RuntimeException ex) {
            this.cancelAcquire(node2);
            throw ex;
        }
        this.cancelAcquire(node2);
        throw new InterruptedException();
    }

    protected boolean tryAcquire(int arg) {
        throw new UnsupportedOperationException();
    }

    protected boolean tryRelease(int arg) {
        throw new UnsupportedOperationException();
    }

    protected int tryAcquireShared(int arg) {
        throw new UnsupportedOperationException();
    }

    protected boolean tryReleaseShared(int arg) {
        throw new UnsupportedOperationException();
    }

    protected boolean isHeldExclusively() {
        throw new UnsupportedOperationException();
    }

    public final void acquire(int arg) {
        if (!this.tryAcquire(arg) && this.acquireQueued(this.addWaiter(Node.EXCLUSIVE), arg)) {
            AbstractQueuedSynchronizer.selfInterrupt();
        }
    }

    public final void acquireInterruptibly(int arg) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!this.tryAcquire(arg)) {
            this.doAcquireInterruptibly(arg);
        }
    }

    public final boolean tryAcquireNanos(int arg, long nanosTimeout) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.tryAcquire(arg) || this.doAcquireNanos(arg, nanosTimeout);
    }

    public final boolean release(int arg) {
        if (this.tryRelease(arg)) {
            Node h = this.head;
            if (h != null && h.waitStatus != 0) {
                this.unparkSuccessor(h);
            }
            return true;
        }
        return false;
    }

    public final void acquireShared(int arg) {
        if (this.tryAcquireShared(arg) < 0) {
            this.doAcquireShared(arg);
        }
    }

    public final void acquireSharedInterruptibly(int arg) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.tryAcquireShared(arg) < 0) {
            this.doAcquireSharedInterruptibly(arg);
        }
    }

    public final boolean tryAcquireSharedNanos(int arg, long nanosTimeout) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.tryAcquireShared(arg) >= 0 || this.doAcquireSharedNanos(arg, nanosTimeout);
    }

    public final boolean releaseShared(int arg) {
        if (this.tryReleaseShared(arg)) {
            Node h = this.head;
            if (h != null && h.waitStatus != 0) {
                this.unparkSuccessor(h);
            }
            return true;
        }
        return false;
    }

    public final boolean hasQueuedThreads() {
        return this.head != this.tail;
    }

    public final boolean hasContended() {
        return this.head != null;
    }

    public final Thread getFirstQueuedThread() {
        return this.head == this.tail ? null : this.fullGetFirstQueuedThread();
    }

    private Thread fullGetFirstQueuedThread() {
        Thread st;
        Node s;
        Node h = this.head;
        if (h != null && (s = h.next) != null && s.prev == this.head && (st = s.thread) != null || (h = this.head) != null && (s = h.next) != null && s.prev == this.head && (st = s.thread) != null) {
            return st;
        }
        Node t = this.tail;
        Thread firstThread = null;
        while (t != null && t != this.head) {
            Thread tt = t.thread;
            if (tt != null) {
                firstThread = tt;
            }
            t = t.prev;
        }
        return firstThread;
    }

    public final boolean isQueued(Thread thread) {
        if (thread == null) {
            throw new NullPointerException();
        }
        Node p = this.tail;
        while (p != null) {
            if (p.thread == thread) {
                return true;
            }
            p = p.prev;
        }
        return false;
    }

    final boolean apparentlyFirstQueuedIsExclusive() {
        Node s;
        Node h = this.head;
        return h != null && (s = h.next) != null && s.nextWaiter != Node.SHARED;
    }

    final boolean isFirst(Thread current) {
        Node s;
        Node h = this.head;
        return h == null || (s = h.next) != null && s.thread == current || this.fullIsFirst(current);
    }

    final boolean fullIsFirst(Thread current) {
        Node s;
        Thread firstThread = null;
        Node h = this.head;
        if (h != null && (s = h.next) != null && s.prev == this.head && (firstThread = s.thread) != null) {
            return firstThread == current;
        }
        Node t = this.tail;
        while (t != null && t != this.head) {
            Thread tt = t.thread;
            if (tt != null) {
                firstThread = tt;
            }
            t = t.prev;
        }
        return firstThread == current || firstThread == null;
    }

    public final int getQueueLength() {
        int n = 0;
        Node p = this.tail;
        while (p != null) {
            if (p.thread != null) {
                ++n;
            }
            p = p.prev;
        }
        return n;
    }

    public final Collection<Thread> getQueuedThreads() {
        ArrayList<Thread> list2 = new ArrayList<Thread>();
        Node p = this.tail;
        while (p != null) {
            Thread t = p.thread;
            if (t != null) {
                list2.add(t);
            }
            p = p.prev;
        }
        return list2;
    }

    public final Collection<Thread> getExclusiveQueuedThreads() {
        ArrayList<Thread> list2 = new ArrayList<Thread>();
        Node p = this.tail;
        while (p != null) {
            Thread t;
            if (!p.isShared() && (t = p.thread) != null) {
                list2.add(t);
            }
            p = p.prev;
        }
        return list2;
    }

    public final Collection<Thread> getSharedQueuedThreads() {
        ArrayList<Thread> list2 = new ArrayList<Thread>();
        Node p = this.tail;
        while (p != null) {
            Thread t;
            if (p.isShared() && (t = p.thread) != null) {
                list2.add(t);
            }
            p = p.prev;
        }
        return list2;
    }

    public String toString() {
        int s = this.getState();
        String q = this.hasQueuedThreads() ? "non" : "";
        return String.valueOf(super.toString()) + "[State = " + s + ", " + q + "empty queue]";
    }

    final boolean isOnSyncQueue(Node node2) {
        if (node2.waitStatus == -2 || node2.prev == null) {
            return false;
        }
        if (node2.next != null) {
            return true;
        }
        return this.findNodeFromTail(node2);
    }

    private boolean findNodeFromTail(Node node2) {
        Node t = this.tail;
        while (t != node2) {
            if (t == null) {
                return false;
            }
            t = t.prev;
        }
        return true;
    }

    final boolean transferForSignal(Node node2) {
        if (!AbstractQueuedSynchronizer.compareAndSetWaitStatus(node2, -2, 0)) {
            return false;
        }
        Node p = this.enq(node2);
        int c = p.waitStatus;
        if (c > 0 || !AbstractQueuedSynchronizer.compareAndSetWaitStatus(p, c, -1)) {
            LockSupport.unpark(node2.thread);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    final boolean transferAfterCancelledWait(Node node) {
        if (!AbstractQueuedSynchronizer.compareAndSetWaitStatus(node, -2, 0)) ** GOTO lbl6
        this.enq(node);
        return true;
lbl-1000:
        // 1 sources

        {
            Thread.yield();
lbl6:
            // 2 sources

            ** while (!this.isOnSyncQueue((Node)node))
        }
lbl7:
        // 1 sources

        return false;
    }

    final int fullyRelease(Node node2) {
        try {
            int savedState = this.getState();
            if (this.release(savedState)) {
                return savedState;
            }
        }
        catch (RuntimeException ex) {
            node2.waitStatus = 1;
            throw ex;
        }
        node2.waitStatus = 1;
        throw new IllegalMonitorStateException();
    }

    public final boolean owns(ConditionObject condition) {
        if (condition == null) {
            throw new NullPointerException();
        }
        return condition.isOwnedBy(this);
    }

    public final boolean hasWaiters(ConditionObject condition) {
        if (!this.owns(condition)) {
            throw new IllegalArgumentException("Not owner");
        }
        return condition.hasWaiters();
    }

    public final int getWaitQueueLength(ConditionObject condition) {
        if (!this.owns(condition)) {
            throw new IllegalArgumentException("Not owner");
        }
        return condition.getWaitQueueLength();
    }

    public final Collection<Thread> getWaitingThreads(ConditionObject condition) {
        if (!this.owns(condition)) {
            throw new IllegalArgumentException("Not owner");
        }
        return condition.getWaitingThreads();
    }

    private final boolean compareAndSetHead(Node update) {
        return unsafe.compareAndSwapObject(this, headOffset, null, update);
    }

    private final boolean compareAndSetTail(Node expect, Node update) {
        return unsafe.compareAndSwapObject(this, tailOffset, expect, update);
    }

    private static final boolean compareAndSetWaitStatus(Node node2, int expect, int update) {
        return unsafe.compareAndSwapInt(node2, waitStatusOffset, expect, update);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConditionObject
    implements Condition,
    Serializable {
        private static final long serialVersionUID = 1173984872572414699L;
        private transient Node firstWaiter;
        private transient Node lastWaiter;
        private static final int REINTERRUPT = 1;
        private static final int THROW_IE = -1;

        private Node addConditionWaiter() {
            Node node2 = new Node(Thread.currentThread(), -2);
            Node t = this.lastWaiter;
            if (t == null) {
                this.firstWaiter = node2;
            } else {
                t.nextWaiter = node2;
            }
            this.lastWaiter = node2;
            return node2;
        }

        private void doSignal(Node first) {
            do {
                if ((this.firstWaiter = first.nextWaiter) == null) {
                    this.lastWaiter = null;
                }
                first.nextWaiter = null;
            } while (!AbstractQueuedSynchronizer.this.transferForSignal(first) && (first = this.firstWaiter) != null);
        }

        private void doSignalAll(Node first) {
            Node next;
            this.firstWaiter = null;
            this.lastWaiter = null;
            do {
                next = first.nextWaiter;
                first.nextWaiter = null;
                AbstractQueuedSynchronizer.this.transferForSignal(first);
            } while ((first = next) != null);
        }

        private boolean isOnConditionQueue(Node node2) {
            return node2.next != null || node2 == this.lastWaiter;
        }

        private void unlinkCancelledWaiter(Node node2) {
            Node t = this.firstWaiter;
            Node trail = null;
            while (t != null) {
                if (t == node2) {
                    Node next = t.nextWaiter;
                    if (trail == null) {
                        this.firstWaiter = next;
                    } else {
                        trail.nextWaiter = next;
                    }
                    if (this.lastWaiter != node2) break;
                    this.lastWaiter = trail;
                    break;
                }
                trail = t;
                t = t.nextWaiter;
            }
        }

        @Override
        public final void signal() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            Node first = this.firstWaiter;
            if (first != null) {
                this.doSignal(first);
            }
        }

        @Override
        public final void signalAll() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            Node first = this.firstWaiter;
            if (first != null) {
                this.doSignalAll(first);
            }
        }

        @Override
        public final void awaitUninterruptibly() {
            Node node2 = this.addConditionWaiter();
            int savedState = AbstractQueuedSynchronizer.this.fullyRelease(node2);
            boolean interrupted = false;
            while (!AbstractQueuedSynchronizer.this.isOnSyncQueue(node2)) {
                LockSupport.park(this);
                if (!Thread.interrupted()) continue;
                interrupted = true;
            }
            if (AbstractQueuedSynchronizer.this.acquireQueued(node2, savedState) || interrupted) {
                AbstractQueuedSynchronizer.selfInterrupt();
            }
        }

        private int checkInterruptWhileWaiting(Node node2) {
            return Thread.interrupted() ? (AbstractQueuedSynchronizer.this.transferAfterCancelledWait(node2) ? -1 : 1) : 0;
        }

        private void reportInterruptAfterWait(int interruptMode) throws InterruptedException {
            if (interruptMode == -1) {
                throw new InterruptedException();
            }
            if (interruptMode == 1) {
                AbstractQueuedSynchronizer.selfInterrupt();
            }
        }

        @Override
        public final void await() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node2 = this.addConditionWaiter();
            int savedState = AbstractQueuedSynchronizer.this.fullyRelease(node2);
            int interruptMode = 0;
            while (!AbstractQueuedSynchronizer.this.isOnSyncQueue(node2)) {
                LockSupport.park(this);
                interruptMode = this.checkInterruptWhileWaiting(node2);
                if (interruptMode != 0) break;
            }
            if (AbstractQueuedSynchronizer.this.acquireQueued(node2, savedState) && interruptMode != -1) {
                interruptMode = 1;
            }
            if (this.isOnConditionQueue(node2)) {
                this.unlinkCancelledWaiter(node2);
            }
            if (interruptMode != 0) {
                this.reportInterruptAfterWait(interruptMode);
            }
        }

        @Override
        public final long awaitNanos(long nanosTimeout) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node2 = this.addConditionWaiter();
            int savedState = AbstractQueuedSynchronizer.this.fullyRelease(node2);
            long lastTime = System.nanoTime();
            int interruptMode = 0;
            while (!AbstractQueuedSynchronizer.this.isOnSyncQueue(node2)) {
                if (nanosTimeout <= 0L) {
                    AbstractQueuedSynchronizer.this.transferAfterCancelledWait(node2);
                    break;
                }
                LockSupport.parkNanos(this, nanosTimeout);
                interruptMode = this.checkInterruptWhileWaiting(node2);
                if (interruptMode != 0) break;
                long now = System.nanoTime();
                nanosTimeout -= now - lastTime;
                lastTime = now;
            }
            if (AbstractQueuedSynchronizer.this.acquireQueued(node2, savedState) && interruptMode != -1) {
                interruptMode = 1;
            }
            if (this.isOnConditionQueue(node2)) {
                this.unlinkCancelledWaiter(node2);
            }
            if (interruptMode != 0) {
                this.reportInterruptAfterWait(interruptMode);
            }
            return nanosTimeout - (System.nanoTime() - lastTime);
        }

        @Override
        public final boolean awaitUntil(Date deadline) throws InterruptedException {
            if (deadline == null) {
                throw new NullPointerException();
            }
            long abstime = deadline.getTime();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node2 = this.addConditionWaiter();
            int savedState = AbstractQueuedSynchronizer.this.fullyRelease(node2);
            boolean timedout = false;
            int interruptMode = 0;
            while (!AbstractQueuedSynchronizer.this.isOnSyncQueue(node2)) {
                if (System.currentTimeMillis() > abstime) {
                    timedout = AbstractQueuedSynchronizer.this.transferAfterCancelledWait(node2);
                    break;
                }
                LockSupport.parkUntil(this, abstime);
                interruptMode = this.checkInterruptWhileWaiting(node2);
                if (interruptMode != 0) break;
            }
            if (AbstractQueuedSynchronizer.this.acquireQueued(node2, savedState) && interruptMode != -1) {
                interruptMode = 1;
            }
            if (this.isOnConditionQueue(node2)) {
                this.unlinkCancelledWaiter(node2);
            }
            if (interruptMode != 0) {
                this.reportInterruptAfterWait(interruptMode);
            }
            return !timedout;
        }

        @Override
        public final boolean await(long time, TimeUnit unit) throws InterruptedException {
            if (unit == null) {
                throw new NullPointerException();
            }
            long nanosTimeout = unit.toNanos(time);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node2 = this.addConditionWaiter();
            int savedState = AbstractQueuedSynchronizer.this.fullyRelease(node2);
            long lastTime = System.nanoTime();
            boolean timedout = false;
            int interruptMode = 0;
            while (!AbstractQueuedSynchronizer.this.isOnSyncQueue(node2)) {
                if (nanosTimeout <= 0L) {
                    timedout = AbstractQueuedSynchronizer.this.transferAfterCancelledWait(node2);
                    break;
                }
                LockSupport.parkNanos(this, nanosTimeout);
                interruptMode = this.checkInterruptWhileWaiting(node2);
                if (interruptMode != 0) break;
                long now = System.nanoTime();
                nanosTimeout -= now - lastTime;
                lastTime = now;
            }
            if (AbstractQueuedSynchronizer.this.acquireQueued(node2, savedState) && interruptMode != -1) {
                interruptMode = 1;
            }
            if (this.isOnConditionQueue(node2)) {
                this.unlinkCancelledWaiter(node2);
            }
            if (interruptMode != 0) {
                this.reportInterruptAfterWait(interruptMode);
            }
            return !timedout;
        }

        final boolean isOwnedBy(AbstractQueuedSynchronizer sync) {
            return sync == AbstractQueuedSynchronizer.this;
        }

        protected final boolean hasWaiters() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            Node w = this.firstWaiter;
            while (w != null) {
                if (w.waitStatus == -2) {
                    return true;
                }
                w = w.nextWaiter;
            }
            return false;
        }

        protected final int getWaitQueueLength() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            int n = 0;
            Node w = this.firstWaiter;
            while (w != null) {
                if (w.waitStatus == -2) {
                    ++n;
                }
                w = w.nextWaiter;
            }
            return n;
        }

        protected final Collection<Thread> getWaitingThreads() {
            if (!AbstractQueuedSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            ArrayList<Thread> list2 = new ArrayList<Thread>();
            Node w = this.firstWaiter;
            while (w != null) {
                Thread t;
                if (w.waitStatus == -2 && (t = w.thread) != null) {
                    list2.add(t);
                }
                w = w.nextWaiter;
            }
            return list2;
        }
    }

    static final class Node {
        static final int CANCELLED = 1;
        static final int SIGNAL = -1;
        static final int CONDITION = -2;
        static final Node SHARED = new Node();
        static final Node EXCLUSIVE = null;
        volatile int waitStatus;
        volatile Node prev;
        volatile Node next;
        volatile Thread thread;
        Node nextWaiter;

        final boolean isShared() {
            return this.nextWaiter == SHARED;
        }

        final Node predecessor() throws NullPointerException {
            Node p = this.prev;
            if (p == null) {
                throw new NullPointerException();
            }
            return p;
        }

        Node() {
        }

        Node(Thread thread, Node mode) {
            this.nextWaiter = mode;
            this.thread = thread;
        }

        Node(Thread thread, int waitStatus) {
            this.waitStatus = waitStatus;
            this.thread = thread;
        }
    }
}

