/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.plugins.jpeg;

import gnu.java.lang.CPStringBuilder;

public class JPEGQTable {
    private int[] table;
    public static final JPEGQTable K1Luminance = new JPEGQTable(new int[]{16, 11, 10, 16, 24, 40, 51, 61, 12, 12, 14, 19, 26, 58, 60, 55, 14, 13, 16, 24, 40, 57, 69, 56, 14, 17, 22, 29, 51, 87, 80, 62, 18, 22, 37, 56, 68, 109, 103, 77, 24, 35, 55, 64, 81, 104, 113, 92, 49, 64, 78, 87, 103, 121, 120, 101, 72, 92, 95, 98, 112, 100, 103, 99}, false);
    public static final JPEGQTable K1Div2Luminance = K1Luminance.getScaledInstance(0.5f, true);
    public static final JPEGQTable K2Chrominance = new JPEGQTable(new int[]{17, 18, 24, 47, 99, 99, 99, 99, 18, 21, 26, 66, 99, 99, 99, 99, 24, 26, 56, 99, 99, 99, 99, 99, 47, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99}, false);
    public static final JPEGQTable K2Div2Chrominance = K2Chrominance.getScaledInstance(0.5f, true);

    public JPEGQTable(int[] table) {
        this(JPEGQTable.checkTable(table), true);
    }

    private JPEGQTable(int[] table, boolean copy) {
        this.table = copy ? (int[])table.clone() : table;
    }

    private static int[] checkTable(int[] table) {
        if (table == null || table.length != 64) {
            throw new IllegalArgumentException("invalid JPEG quantization table");
        }
        return table;
    }

    public int[] getTable() {
        return (int[])this.table.clone();
    }

    public JPEGQTable getScaledInstance(float scaleFactor, boolean forceBaseline) {
        int[] scaledTable = this.getTable();
        int max = forceBaseline ? 255 : Short.MAX_VALUE;
        int i = 0;
        while (i < scaledTable.length) {
            scaledTable[i] = Math.round(scaleFactor * (float)scaledTable[i]);
            if (scaledTable[i] < 1) {
                scaledTable[i] = 1;
            } else if (scaledTable[i] > max) {
                scaledTable[i] = max;
            }
            ++i;
        }
        return new JPEGQTable(scaledTable, false);
    }

    public String toString() {
        CPStringBuilder buffer = new CPStringBuilder();
        buffer.append("JPEGQTable:\n");
        int i = 0;
        while (i < 8) {
            buffer.append("        ");
            int j = 0;
            while (j < 8) {
                buffer.append(String.valueOf(this.table[i * 8 + j]) + " ");
                ++j;
            }
            buffer.append("\n");
            ++i;
        }
        return buffer.toString();
    }
}

