/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.SharedUIDefaults;

public class BasicToolBarUI
extends ToolBarUI
implements SwingConstants {
    static JFrame owner = new JFrame();
    private static Border nonRolloverBorder;
    private static Border rolloverBorder;
    protected String constraintBeforeFloating;
    int lastGoodOrientation;
    protected Color dockingBorderColor;
    protected Color dockingColor;
    protected MouseInputListener dockingListener;
    protected DragWindow dragWindow;
    protected Color floatingBorderColor;
    protected Color floatingColor;
    protected int focusedCompIndex;
    protected PropertyChangeListener propertyListener;
    protected JToolBar toolBar;
    protected ContainerListener toolBarContListener;
    protected FocusListener toolBarFocusListener;
    protected KeyStroke leftKey;
    protected KeyStroke rightKey;
    protected KeyStroke upKey;
    protected KeyStroke downKey;
    private transient Window floatFrame;
    transient Container origParent;
    transient Hashtable borders;
    private transient WindowListener windowListener;
    transient Dimension cachedBounds;
    transient int cachedOrientation;

    public boolean canDock(Component c, Point p) {
        return this.areaOfClick(c, p) != -1;
    }

    private int areaOfClick(Component c, Point p) {
        Rectangle pBounds = c.getBounds();
        Dimension d = this.toolBar.getSize();
        int limit = Math.min(d.width, d.height);
        if (!pBounds.contains(p)) {
            return -1;
        }
        if (p.y < limit) {
            return 1;
        }
        if (p.y > pBounds.height - limit) {
            return 5;
        }
        if (p.x < limit) {
            return 7;
        }
        if (p.x > pBounds.width - limit) {
            return 3;
        }
        return -1;
    }

    protected MouseInputListener createDockingListener() {
        return new DockingListener(this.toolBar);
    }

    protected DragWindow createDragWindow(JToolBar toolbar) {
        return new DragWindow();
    }

    protected JFrame createFloatingFrame(JToolBar toolbar) {
        return null;
    }

    protected RootPaneContainer createFloatingWindow(JToolBar toolbar) {
        return new ToolBarDialog();
    }

    protected WindowListener createFrameListener() {
        return new FrameListener();
    }

    protected Border createNonRolloverBorder() {
        Border b = UIManager.getBorder("ToolBar.nonrolloverBorder");
        if (b == null) {
            b = new CompoundBorder(new BasicBorders.ButtonBorder(UIManager.getColor("Button.shadow"), UIManager.getColor("Button.darkShadow"), UIManager.getColor("Button.light"), UIManager.getColor("Button.highlight")), BasicBorders.getMarginBorder());
        }
        return b;
    }

    protected PropertyChangeListener createPropertyListener() {
        return new PropertyListener();
    }

    protected Border createRolloverBorder() {
        Border b = UIManager.getBorder("ToolBar.rolloverBorder");
        if (b == null) {
            b = new CompoundBorder(new BasicBorders.ButtonBorder(UIManager.getColor("Button.shadow"), UIManager.getColor("Button.darkShadow"), UIManager.getColor("Button.light"), UIManager.getColor("Button.highlight")), BasicBorders.getMarginBorder());
        }
        return b;
    }

    protected ContainerListener createToolBarContListener() {
        return new ToolBarContListener();
    }

    protected FocusListener createToolBarFocusListener() {
        return new ToolBarFocusListener();
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicToolBarUI();
    }

    protected void dragTo(Point position, Point origin) {
        int loc = this.areaOfClick(this.origParent, SwingUtilities.convertPoint(this.toolBar, position, this.origParent));
        if (loc != -1) {
            this.dragWindow.setBorderColor(this.dockingBorderColor);
            this.dragWindow.setBackground(this.dockingColor);
        } else {
            this.dragWindow.setBorderColor(this.floatingBorderColor);
            this.dragWindow.setBackground(this.floatingColor);
        }
        int w = 0;
        int h = 0;
        boolean tmp = loc == 1 || loc == 5 || loc == -1;
        this.cachedOrientation = this.toolBar.getOrientation();
        this.cachedBounds = this.toolBar.getSize();
        if (this.cachedOrientation == 0 && tmp || this.cachedOrientation == 1 && !tmp) {
            w = this.cachedBounds.width;
            h = this.cachedBounds.height;
        } else {
            w = this.cachedBounds.height;
            h = this.cachedBounds.width;
        }
        Point p = this.dragWindow.getOffset();
        Insets insets = this.toolBar.getInsets();
        this.dragWindow.setBounds(origin.x + position.x - p.x - (insets.left + insets.right) / 2, origin.y + position.y - p.y - (insets.top + insets.bottom) / 2, w, h);
        if (!this.dragWindow.isVisible()) {
            this.dragWindow.show();
        }
    }

    protected void floatAt(Point position, Point origin) {
        String constraint;
        Container newParent;
        Point p = new Point(position);
        int aoc = this.areaOfClick(this.origParent, SwingUtilities.convertPoint(this.toolBar, p, this.origParent));
        Container oldParent = this.toolBar.getParent();
        oldParent.remove(this.toolBar);
        oldParent.doLayout();
        oldParent.repaint();
        if (aoc == -1) {
            newParent = ((RootPaneContainer)((Object)this.floatFrame)).getContentPane();
        } else {
            this.floatFrame.hide();
            newParent = this.origParent;
        }
        switch (aoc) {
            case 3: {
                constraint = "East";
                break;
            }
            case 1: {
                constraint = "North";
                break;
            }
            case 5: {
                constraint = "South";
                break;
            }
            case 7: {
                constraint = "West";
                break;
            }
            default: {
                constraint = "Center";
            }
        }
        int newOrientation = 0;
        if (aoc != -1 && (aoc == 3 || aoc == 7)) {
            newOrientation = 1;
        }
        if (aoc != -1) {
            this.constraintBeforeFloating = constraint;
            this.lastGoodOrientation = newOrientation;
        }
        newParent.add((Component)this.toolBar, constraint);
        this.setFloating(aoc == -1, null);
        this.toolBar.setOrientation(newOrientation);
        Insets insets = this.floatFrame.getInsets();
        Dimension dims = this.toolBar.getPreferredSize();
        p = this.dragWindow.getOffset();
        this.setFloatingLocation(position.x + origin.x - p.x - (insets.left + insets.right) / 2, position.y + origin.y - p.y - (insets.top + insets.bottom) / 2);
        if (aoc == -1) {
            this.floatFrame.pack();
            this.floatFrame.setSize(dims.width + insets.left + insets.right, dims.height + insets.top + insets.bottom);
            this.floatFrame.show();
        }
        newParent.invalidate();
        newParent.validate();
        newParent.repaint();
    }

    public Color getDockingColor() {
        return this.dockingColor;
    }

    public Color getFloatingColor() {
        return this.floatingColor;
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    protected void installComponents() {
        this.floatFrame = (Window)((Object)this.createFloatingWindow(this.toolBar));
        this.dragWindow = this.createDragWindow(this.toolBar);
        nonRolloverBorder = this.createNonRolloverBorder();
        rolloverBorder = this.createRolloverBorder();
        this.borders = new Hashtable();
        this.setRolloverBorders(this.toolBar.isRollover());
        this.fillHashtable();
    }

    protected void installDefaults() {
        LookAndFeel.installBorder(this.toolBar, "ToolBar.border");
        LookAndFeel.installColorsAndFont(this.toolBar, "ToolBar.background", "ToolBar.foreground", "ToolBar.font");
        this.dockingBorderColor = UIManager.getColor("ToolBar.dockingForeground");
        this.dockingColor = UIManager.getColor("ToolBar.dockingBackground");
        this.floatingBorderColor = UIManager.getColor("ToolBar.floatingForeground");
        this.floatingColor = UIManager.getColor("ToolBar.floatingBackground");
    }

    protected void installKeyboardActions() {
        InputMap inputMap = (InputMap)SharedUIDefaults.get("ToolBar.ancestorInputMap");
        SwingUtilities.replaceUIInputMap(this.toolBar, 1, inputMap);
        SwingUtilities.replaceUIActionMap(this.toolBar, this.getActionMap());
    }

    private ActionMap getActionMap() {
        ActionMap am = (ActionMap)UIManager.get("ToolBar.actionMap");
        if (am == null) {
            am = this.createDefaultActions();
            UIManager.getLookAndFeelDefaults().put("ToolBar.actionMap", am);
        }
        return am;
    }

    private ActionMap createDefaultActions() {
        ActionMapUIResource am = new ActionMapUIResource();
        ToolBarAction action = new ToolBarAction();
        am.put("navigateLeft", action);
        am.put("navigateRight", action);
        am.put("navigateUp", action);
        am.put("navigateDown", action);
        return am;
    }

    protected void installListeners() {
        this.dockingListener = this.createDockingListener();
        this.toolBar.addMouseListener(this.dockingListener);
        this.toolBar.addMouseMotionListener(this.dockingListener);
        this.propertyListener = this.createPropertyListener();
        this.toolBar.addPropertyChangeListener(this.propertyListener);
        this.toolBarContListener = this.createToolBarContListener();
        this.toolBar.addContainerListener(this.toolBarContListener);
        this.windowListener = this.createFrameListener();
        this.floatFrame.addWindowListener(this.windowListener);
        this.toolBarFocusListener = this.createToolBarFocusListener();
        if (this.toolBarFocusListener != null) {
            int count = this.toolBar.getComponentCount();
            int i = 0;
            while (i < count) {
                this.toolBar.getComponent(i).addFocusListener(this.toolBarFocusListener);
                ++i;
            }
        }
    }

    protected void installNonRolloverBorders(JComponent c) {
        Component[] components = this.toolBar.getComponents();
        int i = 0;
        while (i < components.length) {
            this.setBorderToNonRollover(components[i]);
            ++i;
        }
    }

    protected void installNormalBorders(JComponent c) {
        Component[] components = this.toolBar.getComponents();
        int i = 0;
        while (i < components.length) {
            this.setBorderToNormal(components[i]);
            ++i;
        }
    }

    protected void installRolloverBorders(JComponent c) {
        Component[] components = this.toolBar.getComponents();
        int i = 0;
        while (i < components.length) {
            this.setBorderToRollover(components[i]);
            ++i;
        }
    }

    private void fillHashtable() {
        Component[] c = this.toolBar.getComponents();
        int i = 0;
        while (i < c.length) {
            JButton b;
            if (c[i] instanceof JButton && (b = (JButton)c[i]).getBorder() != null) {
                this.borders.put(b, b.getBorder());
            }
            ++i;
        }
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JToolBar) {
            this.toolBar = (JToolBar)c;
            this.installDefaults();
            this.installComponents();
            this.installListeners();
            this.installKeyboardActions();
        }
    }

    public boolean isFloating() {
        return this.floatFrame.isVisible();
    }

    public boolean isRolloverBorders() {
        return this.toolBar.isRollover();
    }

    protected void navigateFocusedComp(int direction) {
        int count = this.toolBar.getComponentCount();
        switch (direction) {
            case 3: 
            case 5: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= count) break;
                int i = this.focusedCompIndex + 1;
                boolean focusRequested = false;
                while (i != this.focusedCompIndex && !focusRequested) {
                    Component comp;
                    if (i >= count) {
                        i = 0;
                    }
                    if ((comp = this.toolBar.getComponentAtIndex(i++)) == null || !comp.isFocusable() || !comp.isEnabled()) continue;
                    comp.requestFocus();
                    focusRequested = true;
                }
                break;
            }
            case 1: 
            case 7: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= count) break;
                int i = this.focusedCompIndex - 1;
                boolean focusRequested = false;
                while (i != this.focusedCompIndex && !focusRequested) {
                    Component comp;
                    if (i < 0) {
                        i = count - 1;
                    }
                    if ((comp = this.toolBar.getComponentAtIndex(i--)) == null || !comp.isFocusable() || !comp.isEnabled()) continue;
                    comp.requestFocus();
                    focusRequested = true;
                }
                break;
            }
        }
    }

    protected void setBorderToNonRollover(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            b.setRolloverEnabled(false);
            if (b.getBorder() != null) {
                this.borders.put(b, b.getBorder());
            }
            b.setBorder(nonRolloverBorder);
        }
    }

    protected void setBorderToNormal(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            b.setRolloverEnabled(true);
            b.setBorder((Border)this.borders.remove(b));
        }
    }

    protected void setBorderToRollover(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            b.setRolloverEnabled(false);
            if (b.getBorder() != null) {
                this.borders.put(b, b.getBorder());
            }
            b.setBorder(rolloverBorder);
        }
    }

    public void setDockingColor(Color c) {
        this.dockingColor = c;
    }

    public void setFloating(boolean b, Point p) {
        this.floatFrame.setVisible(b);
    }

    public void setFloatingColor(Color c) {
        this.floatingColor = c;
    }

    public void setFloatingLocation(int x, int y) {
        this.floatFrame.setLocation(x, y);
        this.floatFrame.invalidate();
        this.floatFrame.validate();
        this.floatFrame.repaint();
    }

    public void setOrientation(int orientation) {
        this.toolBar.setOrientation(orientation);
    }

    public void setRolloverBorders(boolean rollover) {
        if (rollover) {
            this.installRolloverBorders(this.toolBar);
        } else {
            this.installNonRolloverBorders(this.toolBar);
        }
    }

    protected void uninstallComponents() {
        this.installNormalBorders(this.toolBar);
        this.borders = null;
        this.cachedBounds = null;
        this.floatFrame = null;
        this.dragWindow = null;
    }

    protected void uninstallDefaults() {
        this.toolBar.setBackground(null);
        this.toolBar.setForeground(null);
        this.toolBar.setFont(null);
        this.dockingBorderColor = null;
        this.dockingColor = null;
        this.floatingBorderColor = null;
        this.floatingColor = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.toolBar, 1, null);
        SwingUtilities.replaceUIActionMap(this.toolBar, null);
    }

    protected void uninstallListeners() {
        if (this.toolBarFocusListener != null) {
            int count = this.toolBar.getComponentCount();
            int i = 0;
            while (i < count) {
                this.toolBar.getComponent(i).removeFocusListener(this.toolBarFocusListener);
                ++i;
            }
            this.toolBarFocusListener = null;
        }
        this.floatFrame.removeWindowListener(this.windowListener);
        this.windowListener = null;
        this.toolBar.removeContainerListener(this.toolBarContListener);
        this.toolBarContListener = null;
        this.toolBar.removeMouseMotionListener(this.dockingListener);
        this.toolBar.removeMouseListener(this.dockingListener);
        this.dockingListener = null;
    }

    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.toolBar = null;
    }

    public class DockingListener
    implements MouseInputListener {
        protected boolean isDragging;
        protected Point origin;
        protected JToolBar toolBar;

        public DockingListener(JToolBar t) {
            this.toolBar = t;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            if (this.isDragging) {
                BasicToolBarUI.this.dragTo(e.getPoint(), this.origin);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (!this.toolBar.isFloatable()) {
                return;
            }
            Point ssd = e.getPoint();
            Insets insets = this.toolBar.getInsets();
            if (this.toolBar.getOrientation() == 0 ? e.getX() > insets.left : e.getY() > insets.top) {
                return;
            }
            this.origin = new Point(0, 0);
            if (this.toolBar.isShowing()) {
                SwingUtilities.convertPointToScreen(ssd, this.toolBar);
            }
            if (!(SwingUtilities.getAncestorOfClass(Window.class, this.toolBar) instanceof UIResource)) {
                BasicToolBarUI.this.origParent = this.toolBar.getParent();
            }
            if (this.toolBar.isShowing()) {
                SwingUtilities.convertPointToScreen(this.origin, this.toolBar);
            }
            this.isDragging = true;
            if (BasicToolBarUI.this.dragWindow != null) {
                BasicToolBarUI.this.dragWindow.setOffset(new Point(BasicToolBarUI.this.cachedBounds.width / 2, BasicToolBarUI.this.cachedBounds.height / 2));
            }
            BasicToolBarUI.this.dragTo(e.getPoint(), this.origin);
        }

        public void mouseReleased(MouseEvent e) {
            if (!this.isDragging || !this.toolBar.isFloatable()) {
                return;
            }
            this.isDragging = false;
            BasicToolBarUI.this.floatAt(e.getPoint(), this.origin);
            BasicToolBarUI.this.dragWindow.hide();
        }
    }

    protected class DragWindow
    extends Window {
        private Color borderColor;
        private Point offset;

        DragWindow() {
            super(owner);
        }

        public Color getBorderColor() {
            if (this.borderColor == null) {
                return Color.BLACK;
            }
            return this.borderColor;
        }

        public Insets getInsets() {
            return new Insets(0, 0, 0, 0);
        }

        public Point getOffset() {
            return this.offset;
        }

        public void paint(Graphics g) {
            Color saved = g.getColor();
            Rectangle b = this.getBounds();
            g.setColor(this.getBorderColor());
            g.drawRect(0, 0, b.width - 1, b.height - 1);
            g.setColor(saved);
        }

        public void setBorderColor(Color c) {
            this.borderColor = c;
        }

        public void setOffset(Point p) {
            this.offset = p;
        }

        public void setOrientation(int o) {
            BasicToolBarUI.this.toolBar.setOrientation(o);
            if (BasicToolBarUI.this.dragWindow != null) {
                BasicToolBarUI.this.dragWindow.setOrientation(o);
            }
        }
    }

    protected class FrameListener
    extends WindowAdapter {
        protected FrameListener() {
        }

        public void windowClosing(WindowEvent e) {
            Container parent = BasicToolBarUI.this.toolBar.getParent();
            parent.remove(BasicToolBarUI.this.toolBar);
            if (BasicToolBarUI.this.origParent != null) {
                BasicToolBarUI.this.origParent.add((Component)BasicToolBarUI.this.toolBar, BasicToolBarUI.this.constraintBeforeFloating != null ? BasicToolBarUI.this.constraintBeforeFloating : "North");
                BasicToolBarUI.this.toolBar.setOrientation(BasicToolBarUI.this.lastGoodOrientation);
            }
            BasicToolBarUI.this.origParent.invalidate();
            BasicToolBarUI.this.origParent.validate();
            BasicToolBarUI.this.origParent.repaint();
        }
    }

    protected class PropertyListener
    implements PropertyChangeListener {
        protected PropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("rollover") && BasicToolBarUI.this.toolBar != null) {
                BasicToolBarUI.this.setRolloverBorders(BasicToolBarUI.this.toolBar.isRollover());
            }
        }
    }

    static class ToolBarAction
    extends AbstractAction {
        ToolBarAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object cmd = this.getValue("__command__");
            JToolBar toolBar = (JToolBar)event.getSource();
            BasicToolBarUI ui = (BasicToolBarUI)toolBar.getUI();
            if (cmd.equals("navigateRight")) {
                ui.navigateFocusedComp(3);
            } else if (cmd.equals("navigateLeft")) {
                ui.navigateFocusedComp(7);
            } else if (cmd.equals("navigateUp")) {
                ui.navigateFocusedComp(1);
            } else if (cmd.equals("navigateDown")) {
                ui.navigateFocusedComp(5);
            } else assert (false) : "Shouldn't reach here";
        }
    }

    private static class ToolBarBorder
    implements Border {
        private static final int offset = 10;
        private static final int regular = 2;

        private ToolBarBorder() {
        }

        public Insets getBorderInsets(Component c) {
            if (c instanceof JToolBar) {
                JToolBar tb = (JToolBar)c;
                int orientation = tb.getOrientation();
                if (!tb.isFloatable()) {
                    return new Insets(2, 2, 2, 2);
                }
                if (orientation == 0) {
                    return new Insets(2, 10, 2, 2);
                }
                return new Insets(10, 2, 2, 2);
            }
            return new Insets(0, 0, 0, 0);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        private void paintBumps(Graphics g, int x, int y, int w, int h, int size, Color c) {
            Color saved = g.getColor();
            g.setColor(c);
            int hgap = 2 * size;
            int vgap = 4 * size;
            int count = 0;
            int i = x;
            while (i < w + x) {
                int j = count++ % 2 == 0 ? y : y + 2 * size;
                while (j < h + y) {
                    g.fillRect(i, j, size, size);
                    j += vgap;
                }
                i += hgap;
            }
            g.setColor(saved);
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (c instanceof JToolBar) {
                JToolBar tb = (JToolBar)c;
                int orientation = tb.getOrientation();
                if (orientation == 0) {
                    this.paintBumps(g, x, y, 10, height, 1, Color.WHITE);
                    this.paintBumps(g, x + 1, y + 1, 9, height - 1, 1, Color.GRAY);
                } else {
                    this.paintBumps(g, x, y, width, 10, 1, Color.WHITE);
                    this.paintBumps(g, x + 1, y + 1, width - 1, 9, 1, Color.GRAY);
                }
            }
        }
    }

    protected class ToolBarContListener
    implements ContainerListener {
        protected ToolBarContListener() {
        }

        public void componentAdded(ContainerEvent e) {
            JButton b;
            if (e.getChild() instanceof JButton && (b = (JButton)e.getChild()).getBorder() != null) {
                BasicToolBarUI.this.borders.put(b, b.getBorder());
            }
            if (BasicToolBarUI.this.isRolloverBorders()) {
                BasicToolBarUI.this.setBorderToRollover(e.getChild());
            } else {
                BasicToolBarUI.this.setBorderToNonRollover(e.getChild());
            }
            BasicToolBarUI.this.cachedBounds = BasicToolBarUI.this.toolBar.getPreferredSize();
            BasicToolBarUI.this.cachedOrientation = BasicToolBarUI.this.toolBar.getOrientation();
            Component c = e.getChild();
            if (BasicToolBarUI.this.toolBarFocusListener != null) {
                c.addFocusListener(BasicToolBarUI.this.toolBarFocusListener);
            }
        }

        public void componentRemoved(ContainerEvent e) {
            BasicToolBarUI.this.setBorderToNormal(e.getChild());
            BasicToolBarUI.this.cachedBounds = BasicToolBarUI.this.toolBar.getPreferredSize();
            BasicToolBarUI.this.cachedOrientation = BasicToolBarUI.this.toolBar.getOrientation();
            Component c = e.getChild();
            if (BasicToolBarUI.this.toolBarFocusListener != null) {
                c.removeFocusListener(BasicToolBarUI.this.toolBarFocusListener);
            }
        }
    }

    private class ToolBarDialog
    extends JDialog
    implements UIResource {
        public ToolBarDialog() {
            this.setName(BasicToolBarUI.this.toolBar.getName() != null ? BasicToolBarUI.this.toolBar.getName() : "");
        }
    }

    protected class ToolBarFocusListener
    implements FocusListener {
        protected ToolBarFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            Component c = e.getComponent();
            BasicToolBarUI.this.focusedCompIndex = BasicToolBarUI.this.toolBar.getComponentIndex(c);
        }

        public void focusLost(FocusEvent e) {
        }
    }
}

