#!/bin/sh
echo 'name: crypto-api
version: 0.8
id: crypto-api-0.8-43c4c4e96d2c0015b8cc766a3b046148

license: BSD3
copyright: Thomas DuBuisson <thomas.dubuisson@gmail.com>, Francisco Blas Izquierdo Riera (klondike) (see AUTHORS)
maintainer: Thomas DuBuisson <thomas.dubuisson@gmail.com>
stability: stable
homepage: http://trac.haskell.org/crypto-api/wiki
package-url:
description: A generic interface for cryptographic operations (hashes, ciphers, randomness).
             Maintainers of hash and cipher implementations are
             encouraged to add instances for the classes defined
             in Crypto.Classes.  Crypto users are similarly
             encouraged to use the interfaces defined in the Classes
             module.
             Any concepts or functions of general use to more than
             one cryptographic algorithm (ex: padding) is within
             scope of this package.
category: Data, Cryptography
author: Thomas DuBuisson <thomas.dubuisson@gmail.com>, Francisco Blas Izquierdo Riera (klondike)
pkgpath: security/hs-crypto-api
exposed: True
exposed-modules: Crypto.Classes Crypto.Types Crypto.HMAC
                 Crypto.Modes Crypto.Random Crypto.Padding
hidden-modules: Crypto.Util Crypto.CPoly
import-dirs: /usr/local/lib/ghc/crypto-api-0.8
library-dirs: /usr/local/lib/ghc/crypto-api-0.8
hs-libraries: HScrypto-api-0.8
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.3.0.2-f538acad67d0b6696484da310d5949cf
         base-4.3.1.0-ee15f259a627d341af7c80a17e8b0e66
         bytestring-0.9.1.10-4e62762ee9b2a5d0cc5bc2fbaaeefd53
         cereal-0.3.0.0-25883d7c37e4efd7c4c2505739809299
         entropy-0.2.1-787e84534945d3fd05c03fc51f7b2fee
         largeword-1.0.0-9cc91e4e2c2e306b494cededed1645a6
         tagged-0.2-b073b1397e3758a1ea33941d96025ee0
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-crypto-api-0.8/html/crypto-api.haddock
haddock-html: /usr/local/share/doc/hs-crypto-api-0.8/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
