/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.io.File;
import java.util.ArrayList;
import net.sourceforge.jnlp.cache.DirectoryNode;
import net.sourceforge.jnlp.util.FileUtils;

public final class CacheDirectory {
    private CacheDirectory() {
    }

    public static void getDirStructure(DirectoryNode root) {
        for (File f : root.getFile().listFiles()) {
            DirectoryNode node = new DirectoryNode(f.getName(), f, root);
            if (f.isDirectory() || !f.isDirectory() && !f.getName().endsWith(".info")) {
                root.addChild(node);
            }
            if (!f.isDirectory()) continue;
            CacheDirectory.getDirStructure(node);
        }
    }

    public static ArrayList<DirectoryNode> getLeafData(DirectoryNode root) {
        ArrayList<DirectoryNode> temp = new ArrayList<DirectoryNode>();
        for (DirectoryNode f : root.getChildren()) {
            if (f.isDir()) {
                temp.addAll(CacheDirectory.getLeafData(f));
                continue;
            }
            if (f.getName().endsWith(".info")) continue;
            temp.add(f);
        }
        return temp;
    }

    public static boolean cleanDir(File root) {
        boolean delete = true;
        for (File f : root.listFiles()) {
            if (f.isDirectory()) {
                CacheDirectory.cleanDir(f);
                continue;
            }
            delete = false;
        }
        if (delete) {
            System.out.println("Delete -- " + root);
        }
        return true;
    }

    public static void cleanParent(DirectoryNode fileNode) {
        DirectoryNode parent = fileNode.getParent();
        if (parent.getParent() == null) {
            return;
        }
        if (parent.getChildren().size() == 0) {
            FileUtils.deleteWithErrMesg(parent.getFile());
            parent.getParent().removeChild(parent);
            CacheDirectory.cleanParent(parent);
        }
    }
}

