/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.formatter.comment;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.jdt.internal.formatter.comment.CommentLine;
import org.eclipse.jdt.internal.formatter.comment.CommentRange;
import org.eclipse.jdt.internal.formatter.comment.CommentRegion;
import org.eclipse.jdt.internal.formatter.comment.ICommentAttributes;
import org.eclipse.jdt.internal.formatter.comment.IHtmlTagDelimiters;
import org.eclipse.jdt.internal.formatter.comment.IJavaDocTagConstants;
import org.eclipse.jdt.internal.formatter.comment.MultiCommentRegion;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class MultiCommentLine
extends CommentLine
implements ICommentAttributes,
IHtmlTagDelimiters,
IJavaDocTagConstants {
    public static final String MULTI_COMMENT_CONTENT_PREFIX = " * ";
    public static final String MULTI_COMMENT_END_PREFIX = " */";
    public static final String MULTI_COMMENT_START_PREFIX = "/* ";
    private String fReferenceIndentation = "";
    private static final Set fgTagLookup = new HashSet();

    static {
        int i = 0;
        while (i < JAVADOC_BREAK_TAGS.length) {
            fgTagLookup.add(new String(JAVADOC_BREAK_TAGS[i]));
            ++i;
        }
        i = 0;
        while (i < JAVADOC_SINGLE_BREAK_TAG.length) {
            fgTagLookup.add(new String(JAVADOC_SINGLE_BREAK_TAG[i]));
            ++i;
        }
        i = 0;
        while (i < JAVADOC_CODE_TAGS.length) {
            fgTagLookup.add(new String(JAVADOC_CODE_TAGS[i]));
            ++i;
        }
        i = 0;
        while (i < JAVADOC_IMMUTABLE_TAGS.length) {
            fgTagLookup.add(new String(JAVADOC_IMMUTABLE_TAGS[i]));
            ++i;
        }
        i = 0;
        while (i < JAVADOC_NEWLINE_TAGS.length) {
            fgTagLookup.add(new String(JAVADOC_NEWLINE_TAGS[i]));
            ++i;
        }
        i = 0;
        while (i < JAVADOC_SEPARATOR_TAGS.length) {
            fgTagLookup.add(new String(JAVADOC_SEPARATOR_TAGS[i]));
            ++i;
        }
    }

    protected MultiCommentLine(CommentRegion region) {
        super(region);
    }

    protected void adapt(CommentLine previous) {
        if (!(this.hasAttribute(2048) || this.hasAttribute(1024) || previous.hasAttribute(2))) {
            this.fReferenceIndentation = previous.getIndentationReference();
        }
    }

    protected void append(CommentRange range) {
        MultiCommentRegion parent = (MultiCommentRegion)this.getParent();
        if (range.hasAttribute(1024)) {
            this.setAttribute(1024);
        } else if (range.hasAttribute(2048)) {
            this.setAttribute(2048);
        } else if (range.hasAttribute(2)) {
            this.setAttribute(2);
        }
        int ranges = this.getSize();
        if (ranges == 1 && parent.isIndentRoots()) {
            CommentRange first = this.getFirst();
            String common = String.valueOf(parent.getText(first.getOffset(), first.getLength())) + " ";
            if (this.hasAttribute(2048)) {
                this.fReferenceIndentation = common;
            } else if (this.hasAttribute(1024)) {
                this.fReferenceIndentation = parent.isIndentDescriptions() ? "\t" + common : common;
            }
        }
        super.append(range);
    }

    protected String getContentPrefix() {
        return MULTI_COMMENT_CONTENT_PREFIX;
    }

    protected String getEndingPrefix() {
        return MULTI_COMMENT_END_PREFIX;
    }

    protected final String getIndentationReference() {
        return this.fReferenceIndentation;
    }

    protected String getStartingPrefix() {
        return MULTI_COMMENT_START_PREFIX;
    }

    protected void scanLine(int line) {
        CommentRegion parent = this.getParent();
        String start = this.getStartingPrefix().trim();
        String end = this.getEndingPrefix().trim();
        String content = this.getContentPrefix().trim();
        int lines = parent.getSize();
        CommentRange range = this.getFirst();
        int offset = 0;
        int postfix = 0;
        String text = parent.getText(range.getOffset(), range.getLength());
        if (line == 0) {
            offset = text.indexOf(start);
            if (offset >= 0 && text.substring(0, offset).trim().length() != 0) {
                offset = -1;
            }
            if (offset >= 0) {
                range.trimBegin(offset += start.length());
                postfix = text.lastIndexOf(end);
                if (postfix >= 0 && text.substring(postfix + end.length()).trim().length() != 0) {
                    postfix = -1;
                }
                if (postfix >= offset) {
                    range.setLength(postfix - offset);
                } else {
                    postfix = text.lastIndexOf(content);
                    if (postfix >= 0 && text.substring(postfix + content.length()).trim().length() != 0) {
                        postfix = -1;
                    }
                    if (postfix >= offset) {
                        range.setLength(postfix - offset);
                        parent.setBorder(2);
                        if (postfix > offset) {
                            text = parent.getText(range.getOffset(), range.getLength());
                            IRegion region = this.trimLine(text, content);
                            range.move(region.getOffset());
                            range.setLength(region.getLength());
                        }
                    }
                }
            }
        } else if (line == lines - 1) {
            offset = text.indexOf(content);
            if (offset >= 0 && text.substring(0, offset).trim().length() != 0) {
                offset = -1;
            }
            if ((postfix = text.lastIndexOf(end)) >= 0 && text.substring(postfix + end.length()).trim().length() != 0) {
                postfix = -1;
            }
            if (offset >= 0 && offset == postfix) {
                range.setLength(0);
            } else {
                IRegion region;
                if (offset >= 0) {
                    range.trimBegin(offset + content.length());
                }
                if (postfix >= 0) {
                    range.trimEnd(-end.length());
                }
                if ((region = this.trimLine(text = parent.getText(range.getOffset(), range.getLength()), content)).getOffset() != 0 || region.getLength() != text.length()) {
                    range.move(region.getOffset());
                    range.setLength(region.getLength());
                    parent.setBorder(2);
                    parent.setBorder(1);
                }
            }
        } else {
            offset = text.indexOf(content);
            if (offset >= 0 && text.substring(0, offset).trim().length() != 0) {
                offset = -1;
            }
            if (offset >= 0) {
                range.trimBegin(offset += content.length());
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void tokenizeLine(int line) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[DOLOOP]], but top level block is 2[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isValidTag(String tag) {
        if (tag.startsWith("/")) {
            tag = tag.substring(1, tag.length());
        }
        tag = tag.trim();
        int i = 0;
        while (i < tag.length() && !ScannerHelper.isWhitespace(tag.charAt(i))) {
            ++i;
        }
        tag = tag.substring(0, i);
        return this.isTagName(tag.toLowerCase());
    }

    private boolean isTagName(String tag) {
        return fgTagLookup.contains(tag);
    }

    protected final IRegion trimLine(String line, String trimmable) {
        int trim = trimmable.length();
        int offset = 0;
        int length = line.length() - trim;
        while (line.startsWith(trimmable, offset)) {
            offset += trim;
        }
        while (line.startsWith(trimmable, length)) {
            length -= trim;
        }
        return new Region(offset, length + trim);
    }
}

