/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.idea.maven.embedder.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenIndexException;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.sonatype.nexus.index.ArtifactContextProducer;
import org.sonatype.nexus.index.NexusIndexer;
import org.sonatype.nexus.index.updater.IndexUpdater;

public class MavenIndices {
    private final MavenEmbedderWrapper myEmbedder;
    private final NexusIndexer myIndexer;
    private final IndexUpdater myUpdater;
    private final ArtifactContextProducer myArtifactContextProducer;
    private final File myIndicesDir;
    private final MavenIndex.IndexListener myListener;
    private final List<MavenIndex> myIndices = new ArrayList<MavenIndex>();
    private static final Object ourDirectoryLock = new Object();

    public MavenIndices(MavenEmbedderWrapper embedder, File indicesDir, MavenIndex.IndexListener listener) {
        this.myEmbedder = embedder;
        this.myIndicesDir = indicesDir;
        this.myListener = listener;
        this.myIndexer = this.myEmbedder.getComponent(NexusIndexer.class);
        this.myUpdater = this.myEmbedder.getComponent(IndexUpdater.class);
        this.myArtifactContextProducer = this.myEmbedder.getComponent(ArtifactContextProducer.class);
        this.load();
    }

    private void load() {
        if (!this.myIndicesDir.exists()) {
            return;
        }
        File[] indices = this.myIndicesDir.listFiles();
        if (indices == null) {
            return;
        }
        for (File each : indices) {
            if (!each.isDirectory()) continue;
            try {
                MavenIndex index = new MavenIndex(this.myIndexer, this.myArtifactContextProducer, each, this.myListener);
                if (this.find(index.getRepositoryId(), index.getRepositoryPathOrUrl(), index.getKind()) != null) {
                    index.close();
                    FileUtil.delete((File)each);
                    continue;
                }
                this.myIndices.add(index);
            }
            catch (Exception e) {
                FileUtil.delete((File)each);
                MavenLog.LOG.warn((Throwable)e);
            }
        }
    }

    public NexusIndexer getIndexer() {
        return this.myIndexer;
    }

    public synchronized void close() {
        for (MavenIndex each : this.myIndices) {
            each.close();
        }
        this.myIndices.clear();
    }

    public synchronized List<MavenIndex> getIndices() {
        return new ArrayList<MavenIndex>(this.myIndices);
    }

    public synchronized MavenIndex add(String repositoryId, String repositoryPathOrUrl, MavenIndex.Kind kind) throws MavenIndexException {
        MavenIndex index = this.find(repositoryId, repositoryPathOrUrl, kind);
        if (index != null) {
            return index;
        }
        File dir = this.getAvailableIndexDir();
        index = new MavenIndex(this.myIndexer, this.myArtifactContextProducer, dir, repositoryId, repositoryPathOrUrl, kind, this.myListener);
        this.myIndices.add(index);
        return index;
    }

    public MavenIndex find(String repositoryId, String repositoryPathOrUrl, MavenIndex.Kind kind) {
        for (MavenIndex each : this.myIndices) {
            if (!each.isFor(kind, repositoryId, repositoryPathOrUrl)) continue;
            return each;
        }
        return null;
    }

    private File getAvailableIndexDir() {
        return MavenIndices.findAvailableDir(this.myIndicesDir, "Index", 1000);
    }

    static File findAvailableDir(File parent, String prefix, int max) {
        Object object = ourDirectoryLock;
        synchronized (object) {
            for (int i = 0; i < max; ++i) {
                String name = prefix + i;
                File f = new File(parent, name);
                if (f.exists()) continue;
                f.mkdirs();
                assert (f.exists());
                return f;
            }
            throw new RuntimeException("No available dir found");
        }
    }

    public void updateOrRepair(MavenIndex index, MavenEmbedderWrapper embedderToUse, boolean fullUpdate, ProgressIndicator progress) throws ProcessCanceledException {
        index.updateOrRepair(embedderToUse, this.myUpdater, fullUpdate, progress);
    }
}

