/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import javax.swing.JComponent;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.MavenIcons;
import org.jetbrains.idea.maven.utils.SimpleProjectComponent;

public class MavenImportNotifier
extends SimpleProjectComponent {
    private static final Key<NotifierPanel> PANEL_KEY = new Key(NotifierPanel.class.getName());
    private final FileEditorManager myFileEditorManager;
    private final MavenProjectsManager myMavenProjectsManager;
    private final MergingUpdateQueue myUpdatesQueue;

    public MavenImportNotifier(Project p, FileEditorManager fileEditorManager, MavenProjectsManager mavenProjectsManager) {
        super(p);
        this.myFileEditorManager = fileEditorManager;
        this.myMavenProjectsManager = mavenProjectsManager;
        this.myUpdatesQueue = new MergingUpdateQueue(this.getComponentName(), 500, false, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.myProject);
        this.myMavenProjectsManager.addManagerListener(new MavenProjectsManager.Listener(){

            @Override
            public void activated() {
                MavenImportNotifier.this.init();
                MavenImportNotifier.this.scheduleUpdate();
            }

            @Override
            public void scheduledImportsChanged() {
                MavenImportNotifier.this.scheduleUpdate();
            }
        });
    }

    private void init() {
        this.myFileEditorManager.addFileEditorManagerListener((FileEditorManagerListener)new FileEditorManagerAdapter(){

            public void fileOpened(FileEditorManager source, VirtualFile file) {
                for (FileEditor each : source.getEditors(file)) {
                    MavenImportNotifier.this.updateNotification(file, each);
                }
            }
        }, (Disposable)this.myProject);
        this.myUpdatesQueue.activate();
    }

    private void scheduleUpdate() {
        this.myUpdatesQueue.queue(new Update(this.myUpdatesQueue){

            public void run() {
                MavenImportNotifier.this.updateNotifications();
            }
        });
    }

    private void updateNotifications() {
        for (VirtualFile f : this.myFileEditorManager.getOpenFiles()) {
            for (FileEditor e : this.myFileEditorManager.getEditors(f)) {
                this.updateNotification(f, e);
            }
        }
    }

    private void updateNotification(VirtualFile file, FileEditor editor) {
        if (this.myMavenProjectsManager.getImportingSettings().isImportAutomatically() || !this.myMavenProjectsManager.hasScheduledImports()) {
            JComponent panel = (JComponent)editor.getUserData(PANEL_KEY);
            if (panel == null) {
                return;
            }
            this.myFileEditorManager.removeTopComponent(editor, panel);
            editor.putUserData(PANEL_KEY, null);
            return;
        }
        MavenProject project = this.myMavenProjectsManager.findContainingProject(file);
        if (project == null) {
            return;
        }
        NotifierPanel panel = (NotifierPanel)((Object)editor.getUserData(PANEL_KEY));
        if (panel == null) {
            panel = new NotifierPanel();
            editor.putUserData(PANEL_KEY, (Object)panel);
            this.myFileEditorManager.addTopComponent(editor, (JComponent)((Object)panel));
        }
        panel.update();
    }

    private class NotifierPanel
    extends EditorNotificationPanel {
        private NotifierPanel() {
            this.myLabel.setIcon(MavenIcons.MAVEN_ICON);
            this.createActionLabel(ProjectBundle.message("maven.project.import.changed", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    MavenImportNotifier.this.myMavenProjectsManager.performScheduledImport();
                }
            });
            this.createActionLabel(ProjectBundle.message("maven.project.import.enable.auto", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    MavenImportNotifier.this.myMavenProjectsManager.getImportingSettings().setImportAutomatically(true);
                }
            });
        }

        public void update() {
            int projectsCount = MavenImportNotifier.this.myMavenProjectsManager.getScheduledProjectsCount();
            String s = projectsCount == 0 ? ProjectBundle.message("maven.project.something.changed", new Object[0]) : ProjectBundle.message("maven.project.changed", projectsCount, projectsCount == 1 ? " is" : "s are");
            this.myLabel.setText(s);
            this.myLabel.setToolTipText(s);
        }
    }
}

