/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.quickfix;

import com.intellij.codeInsight.daemon.impl.HectorComponent;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.ant.AntBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntChangeContextFix
extends BaseIntentionAction {
    public AntChangeContextFix() {
        this.setText(AntBundle.message("intention.configure.highlighting.text", new Object[0]));
    }

    @NotNull
    public final String getFamilyName() {
        String string = AntBundle.message("intention.configure.highlighting.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/ant/quickfix/AntChangeContextFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/quickfix/AntChangeContextFix.isAvailable must not be null");
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/quickfix/AntChangeContextFix.invoke must not be null");
        }
        final HectorComponent component = new HectorComponent(file);
        final JComponent focusComponent = AntChangeContextFix.findComponentToFocus((JComponent)component);
        component.showComponent(JBPopupFactory.getInstance().guessBestPopupLocation(editor));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                (focusComponent != null ? focusComponent : component).requestFocus();
            }
        });
    }

    @Nullable
    private static JComponent findComponentToFocus(JComponent component) {
        if (component.getClientProperty("AntContextsComboBox") != null) {
            return component;
        }
        for (Component child : component.getComponents()) {
            JComponent found;
            if (!(child instanceof JComponent) || (found = AntChangeContextFix.findComponentToFocus((JComponent)child)) == null) continue;
            return found;
        }
        return null;
    }
}

