/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.ConflictState;
import org.jetbrains.idea.svn.ConflictedSvnChange;
import org.jetbrains.idea.svn.StatusReceiver;
import org.jetbrains.idea.svn.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.SvnChangedFile;
import org.jetbrains.idea.svn.SvnContentRevision;
import org.jetbrains.idea.svn.SvnLocallyDeletedChange;
import org.jetbrains.idea.svn.SvnStatusConvertor;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;

class SvnChangeProviderContext
implements StatusReceiver {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.idea.svn.SvnChangeProviderContext");
    private final ChangelistBuilder myChangelistBuilder;
    private final SVNStatusClient myStatusClient;
    private List<SvnChangedFile> myCopiedFiles = null;
    private final List<SvnChangedFile> myDeletedFiles = new ArrayList<SvnChangedFile>();
    private final Map<String, SVNStatus> myTreeConflicted;
    private Map<FilePath, String> myCopyFromURLs = null;
    private final SvnVcs myVcs;
    private final SvnBranchConfigurationManager myBranchConfigurationManager;
    private final ProgressIndicator myProgress;

    public SvnChangeProviderContext(SvnVcs vcs, ChangelistBuilder changelistBuilder, ProgressIndicator progress) {
        this.myVcs = vcs;
        this.myStatusClient = vcs.createStatusClient();
        this.myChangelistBuilder = changelistBuilder;
        this.myProgress = progress;
        this.myTreeConflicted = new HashMap<String, SVNStatus>();
        this.myBranchConfigurationManager = SvnBranchConfigurationManager.getInstance(this.myVcs.getProject());
    }

    @Override
    public void process(FilePath path, SVNStatus status, boolean isInnerCopyRoot) throws SVNException {
        this.processStatusFirstPass(path, status);
    }

    @Override
    public void processIgnored(VirtualFile vFile) {
        this.myChangelistBuilder.processIgnoredFile(vFile);
    }

    @Override
    public void processUnversioned(VirtualFile vFile) {
        this.myChangelistBuilder.processUnversionedFile(vFile);
    }

    public ChangelistBuilder getBuilder() {
        return this.myChangelistBuilder;
    }

    public SVNStatusClient getClient() {
        return this.myStatusClient;
    }

    public void reportTreeConflict(SVNStatus status) {
        this.myTreeConflicted.put(status.getFile().getAbsolutePath(), status);
    }

    @Nullable
    public SVNStatus getTreeConflictStatus(File file) {
        return this.myTreeConflicted.get(file.getAbsolutePath());
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<SvnChangedFile> getCopiedFiles() {
        List<Object> list;
        if (this.myCopiedFiles == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/SvnChangeProviderContext.getCopiedFiles must not return null");
            return list;
        }
        list = this.myCopiedFiles;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/SvnChangeProviderContext.getCopiedFiles must not return null");
    }

    public List<SvnChangedFile> getDeletedFiles() {
        return this.myDeletedFiles;
    }

    public boolean isDeleted(FilePath path) {
        for (SvnChangedFile deletedFile : this.myDeletedFiles) {
            if (!Comparing.equal((Object)path, (Object)deletedFile.getFilePath())) continue;
            return true;
        }
        return false;
    }

    public boolean isCanceled() {
        return this.myProgress != null && this.myProgress.isCanceled();
    }

    @Nullable
    public String getParentCopyFromURL(FilePath filePath) {
        if (this.myCopyFromURLs == null) {
            return null;
        }
        StringBuilder relPathBuilder = new StringBuilder();
        while (filePath != null) {
            String copyFromURL = this.myCopyFromURLs.get(filePath);
            if (copyFromURL != null) {
                return copyFromURL + relPathBuilder.toString();
            }
            relPathBuilder.insert(0, "/" + filePath.getName());
            filePath = filePath.getParentPath();
        }
        return null;
    }

    public void addCopiedFile(FilePath filePath, SVNStatus status, String copyFromURL) {
        if (this.myCopiedFiles == null) {
            this.myCopiedFiles = new ArrayList<SvnChangedFile>();
        }
        this.myCopiedFiles.add(new SvnChangedFile(filePath, status, copyFromURL));
        String url = status.getCopyFromURL();
        if (url != null) {
            this.addCopyFromURL(filePath, url);
        }
    }

    public void addCopyFromURL(FilePath filePath, String url) {
        if (this.myCopyFromURLs == null) {
            this.myCopyFromURLs = new HashMap<FilePath, String>();
        }
        this.myCopyFromURLs.put(filePath, url);
    }

    void processStatusFirstPass(FilePath filePath, SVNStatus status) throws SVNException {
        SVNLock lock;
        if (status == null) {
            return;
        }
        if (status.getRemoteLock() != null) {
            lock = status.getRemoteLock();
            this.myChangelistBuilder.processLogicallyLockedFolder(filePath.getVirtualFile(), new LogicalLock(false, lock.getOwner(), lock.getComment(), lock.getCreationDate(), lock.getExpirationDate()));
        }
        if (status.getLocalLock() != null) {
            lock = status.getLocalLock();
            this.myChangelistBuilder.processLogicallyLockedFolder(filePath.getVirtualFile(), new LogicalLock(true, lock.getOwner(), lock.getComment(), lock.getCreationDate(), lock.getExpirationDate()));
        }
        if (filePath.isDirectory() && status.isLocked()) {
            this.myChangelistBuilder.processLockedFolder(filePath.getVirtualFile());
        }
        if (status.getContentsStatus() == SVNStatusType.STATUS_ADDED && status.getCopyFromURL() != null) {
            this.addCopiedFile(filePath, status, status.getCopyFromURL());
        } else if (status.getContentsStatus() == SVNStatusType.STATUS_DELETED) {
            this.myDeletedFiles.add(new SvnChangedFile(filePath, status));
        } else {
            String parentCopyFromURL = this.getParentCopyFromURL(filePath);
            if (parentCopyFromURL != null) {
                this.addCopiedFile(filePath, status, parentCopyFromURL);
            } else {
                this.processStatus(filePath, status);
            }
        }
    }

    void processStatus(FilePath filePath, SVNStatus status) throws SVNException {
        SvnChangeProviderContext.loadEntriesFile(filePath);
        if (status != null) {
            FileStatus fStatus = SvnStatusConvertor.convertStatus(status);
            SVNStatusType statusType = status.getContentsStatus();
            SVNStatusType propStatus = status.getPropertiesStatus();
            if (statusType == SVNStatusType.STATUS_UNVERSIONED || statusType == SVNStatusType.UNKNOWN) {
                VirtualFile file = filePath.getVirtualFile();
                if (file != null) {
                    this.myChangelistBuilder.processUnversionedFile(file);
                }
            } else if (statusType == SVNStatusType.STATUS_CONFLICTED || statusType == SVNStatusType.STATUS_MODIFIED || statusType == SVNStatusType.STATUS_REPLACED || propStatus == SVNStatusType.STATUS_MODIFIED || propStatus == SVNStatusType.STATUS_CONFLICTED) {
                this.myChangelistBuilder.processChangeInList(this.createChange(SvnContentRevision.create(this.myVcs, filePath, status.getCommittedRevision()), CurrentContentRevision.create((FilePath)filePath), fStatus, status), SvnChangeProviderContext.changeListNameFromStatus(status), SvnVcs.getKey());
                this.checkSwitched(filePath, this.myChangelistBuilder, status, fStatus);
            } else if (statusType == SVNStatusType.STATUS_ADDED) {
                this.myChangelistBuilder.processChangeInList(this.createChange(null, CurrentContentRevision.create((FilePath)filePath), fStatus, status), SvnChangeProviderContext.changeListNameFromStatus(status), SvnVcs.getKey());
            } else if (statusType == SVNStatusType.STATUS_DELETED) {
                this.myChangelistBuilder.processChangeInList(this.createChange(SvnContentRevision.create(this.myVcs, filePath, status.getCommittedRevision()), null, fStatus, status), SvnChangeProviderContext.changeListNameFromStatus(status), SvnVcs.getKey());
            } else if (statusType == SVNStatusType.STATUS_MISSING) {
                this.myChangelistBuilder.processLocallyDeletedFile(this.createLocallyDeletedChange(filePath, status));
            } else if (statusType == SVNStatusType.STATUS_IGNORED) {
                this.myChangelistBuilder.processIgnoredFile(filePath.getVirtualFile());
            } else if (!(status.isCopied() || fStatus != FileStatus.NOT_CHANGED && fStatus != FileStatus.SWITCHED || statusType == SVNStatusType.STATUS_NONE)) {
                VirtualFile file = filePath.getVirtualFile();
                if (file != null && FileDocumentManager.getInstance().isFileModifiedAndDocumentUnsaved(file)) {
                    this.myChangelistBuilder.processChangeInList(this.createChange(SvnContentRevision.create(this.myVcs, filePath, status.getCommittedRevision()), CurrentContentRevision.create((FilePath)filePath), FileStatus.MODIFIED, status), SvnChangeProviderContext.changeListNameFromStatus(status), SvnVcs.getKey());
                }
                this.checkSwitched(filePath, this.myChangelistBuilder, status, fStatus);
            }
        }
    }

    private void checkSwitched(FilePath filePath, ChangelistBuilder builder, SVNStatus status, FileStatus convertedStatus) {
        if (status.isSwitched() || convertedStatus == FileStatus.SWITCHED) {
            VirtualFile virtualFile = filePath.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            String switchUrl = status.getURL().toString();
            VirtualFile vcsRoot = ProjectLevelVcsManager.getInstance((Project)this.myVcs.getProject()).getVcsRootFor(virtualFile);
            if (vcsRoot != null) {
                String baseUrl = null;
                try {
                    baseUrl = this.myBranchConfigurationManager.get(vcsRoot).getBaseName(switchUrl);
                }
                catch (VcsException e) {
                    LOG.info((Throwable)e);
                }
                builder.processSwitchedFile(virtualFile, baseUrl == null ? switchUrl : baseUrl, true);
            }
        }
    }

    private static void loadEntriesFile(FilePath filePath) {
        FilePath parentPath = filePath.getParentPath();
        if (parentPath == null) {
            return;
        }
        File svnSubdirectory = new File(parentPath.getIOFile(), SvnUtil.SVN_ADMIN_DIR_NAME);
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        VirtualFile file = localFileSystem.refreshAndFindFileByIoFile(svnSubdirectory);
        if (file != null) {
            localFileSystem.refreshAndFindFileByIoFile(new File(svnSubdirectory, "entries"));
        }
        if (filePath.isDirectory() && (file = localFileSystem.refreshAndFindFileByIoFile(svnSubdirectory = new File(filePath.getPath(), SvnUtil.SVN_ADMIN_DIR_NAME))) != null) {
            localFileSystem.refreshAndFindFileByIoFile(new File(svnSubdirectory, "entries"));
        }
    }

    Change createMovedChange(ContentRevision before, ContentRevision after, SVNStatus copiedStatus, SVNStatus deletedStatus) {
        return new ConflictedSvnChange(before, after, ConflictState.mergeState(this.getState(copiedStatus), this.getState(deletedStatus)), copiedStatus != null && copiedStatus.getTreeConflict() != null ? after.getFile() : before.getFile());
    }

    private Change createChange(ContentRevision before, ContentRevision after, FileStatus fStatus, SVNStatus svnStatus) {
        return new ConflictedSvnChange(before, after, fStatus, this.getState(svnStatus), after == null ? before.getFile() : after.getFile());
    }

    private LocallyDeletedChange createLocallyDeletedChange(@NotNull FilePath filePath, SVNStatus status) {
        if (filePath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/SvnChangeProviderContext.createLocallyDeletedChange must not be null");
        }
        return new SvnLocallyDeletedChange(filePath, this.getState(status));
    }

    private ConflictState getState(@Nullable SVNStatus svnStatus) {
        boolean propertyConflict;
        if (svnStatus == null) {
            return ConflictState.none;
        }
        boolean treeConflict = svnStatus.getTreeConflict() != null;
        boolean textConflict = SVNStatusType.STATUS_CONFLICTED == svnStatus.getContentsStatus();
        boolean bl = propertyConflict = SVNStatusType.STATUS_CONFLICTED == svnStatus.getPropertiesStatus();
        if (treeConflict) {
            this.reportTreeConflict(svnStatus);
        }
        return ConflictState.getInstance(treeConflict, textConflict, propertyConflict);
    }

    @Nullable
    private static String changeListNameFromStatus(SVNStatus status) {
        if (WorkingCopyFormat.getInstance(status.getWorkingCopyFormat()).supportsChangelists() && SVNNodeKind.FILE.equals(status.getKind())) {
            String clName = status.getChangelistName();
            return clName == null ? null : clName;
        }
        return null;
    }
}

