/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListsListener;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import java.awt.Color;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.dialogs.WCInfoWithBranches;
import org.jetbrains.idea.svn.dialogs.WCPaths;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.mergeinfo.MergeinfoCached;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;

public class MergeInfoHolder {
    private final DecoratorManager myManager;
    private final Consumer<Boolean> myMixedRevisionsConsumer;
    private final SvnMergeInfoCache myMergeInfoCache;
    private static final String ourIntegratedText = SvnBundle.message("committed.changes.merge.status.integrated.text", new Object[0]);
    private static final String ourNotIntegratedText = SvnBundle.message("committed.changes.merge.status.not.integrated.text", new Object[0]);
    private static final SimpleTextAttributes ourNotIntegratedAttributes = new SimpleTextAttributes(1, Color.RED);
    private static final SimpleTextAttributes ourIntegratedAttributes = new SimpleTextAttributes(1, Color.GREEN);
    private static final SimpleTextAttributes ourRefreshAttributes = new SimpleTextAttributes(1, Color.GRAY);
    private final Map<Pair<String, String>, MergeinfoCached> myCachedMap;
    private final Getter<WCInfoWithBranches> myRootGetter;
    private final Getter<WCInfoWithBranches.Branch> myBranchGetter;
    private final Getter<String> myWcPathGetter;
    private final Getter<Boolean> myEnabledHolder;
    private final MyDecorator myDecorator;

    public MergeInfoHolder(Project project, DecoratorManager manager, Getter<WCInfoWithBranches> rootGetter, Getter<WCInfoWithBranches.Branch> branchGetter, Getter<String> wcPathGetter, Getter<Boolean> enabledHolder, Consumer<Boolean> mixedRevisionsConsumer) {
        this.myRootGetter = rootGetter;
        this.myBranchGetter = branchGetter;
        this.myWcPathGetter = wcPathGetter;
        this.myEnabledHolder = enabledHolder;
        this.myManager = manager;
        this.myMixedRevisionsConsumer = mixedRevisionsConsumer;
        this.myMergeInfoCache = SvnMergeInfoCache.getInstance(project);
        this.myCachedMap = new HashMap<Pair<String, String>, MergeinfoCached>();
        this.myDecorator = new MyDecorator();
    }

    private MergeinfoCached getCurrentCache() {
        return this.myCachedMap.get(MergeInfoHolder.createKey((WCPaths)this.myRootGetter.get(), (WCInfoWithBranches.Branch)this.myBranchGetter.get()));
    }

    private boolean enabledAndGettersFilled(boolean ignoreEnabled) {
        if (!ignoreEnabled && !Boolean.TRUE.equals(this.myEnabledHolder.get())) {
            return false;
        }
        return this.myRootGetter.get() != null && this.myBranchGetter.get() != null && this.myWcPathGetter.get() != null;
    }

    public boolean refreshEnabled(boolean ignoreEnabled) {
        return this.enabledAndGettersFilled(ignoreEnabled) && this.getCurrentCache() == null;
    }

    private static Pair<String, String> createKey(WCPaths root, WCInfoWithBranches.Branch branch) {
        return new Pair((Object)root.getPath(), (Object)branch.getUrl());
    }

    public void refresh(boolean ignoreEnabled) {
        CommittedChangeListsListener refresher = this.createRefresher(ignoreEnabled);
        if (refresher != null) {
            this.myManager.reportLoadedLists((CommittedChangeListsListener)new MyRefresher());
        }
        this.myManager.repaintTree();
    }

    @Nullable
    public CommittedChangeListsListener createRefresher(boolean ignoreEnabled) {
        if (this.refreshEnabled(ignoreEnabled)) {
            MergeinfoCached state = this.myMergeInfoCache.getCachedState((WCPaths)this.myRootGetter.get(), (String)this.myWcPathGetter.get());
            this.myCachedMap.put(MergeInfoHolder.createKey((WCPaths)this.myRootGetter.get(), (WCInfoWithBranches.Branch)this.myBranchGetter.get()), state == null ? new MergeinfoCached() : new MergeinfoCached(new HashMap<Long, SvnMergeInfoCache.MergeCheckResult>(state.getMap()), state.getCopyRevision()));
            this.myMergeInfoCache.clear((WCPaths)this.myRootGetter.get(), (String)this.myWcPathGetter.get());
            return new MyRefresher();
        }
        return null;
    }

    public ListChecker getDecorator() {
        return this.myDecorator;
    }

    public void updateMixedRevisionsForPanel() {
        this.myMixedRevisionsConsumer.consume((Object)this.myMergeInfoCache.isMixedRevisions((WCInfoWithBranches)this.myRootGetter.get(), (String)this.myWcPathGetter.get()));
    }

    class MyDecorator
    implements ListChecker {
        MyDecorator() {
        }

        private ListMergeStatus convert(SvnMergeInfoCache.MergeCheckResult result, boolean refreshing) {
            if (result != null) {
                if (SvnMergeInfoCache.MergeCheckResult.MERGED.equals((Object)result)) {
                    return ListMergeStatus.MERGED;
                }
                if (SvnMergeInfoCache.MergeCheckResult.COMMON.equals((Object)result)) {
                    return ListMergeStatus.COMMON;
                }
                return ListMergeStatus.NOT_MERGED;
            }
            if (refreshing) {
                return ListMergeStatus.REFRESHING;
            }
            return ListMergeStatus.ALIEN;
        }

        @Override
        public ListMergeStatus check(CommittedChangeList list, boolean ignoreEnabled) {
            if (!MergeInfoHolder.this.enabledAndGettersFilled(ignoreEnabled)) {
                return ListMergeStatus.ALIEN;
            }
            if (!(list instanceof SvnChangeList)) {
                return ListMergeStatus.ALIEN;
            }
            MergeinfoCached cachedState = MergeInfoHolder.this.getCurrentCache();
            if (cachedState != null) {
                if (cachedState.getCopyRevision() != -1L && cachedState.getCopyRevision() >= list.getNumber()) {
                    return ListMergeStatus.COMMON;
                }
                SvnMergeInfoCache.MergeCheckResult result = cachedState.getMap().get(list.getNumber());
                return this.convert(result, true);
            }
            MergeinfoCached state = MergeInfoHolder.this.myMergeInfoCache.getCachedState((WCPaths)MergeInfoHolder.this.myRootGetter.get(), (String)MergeInfoHolder.this.myWcPathGetter.get());
            if (state == null) {
                MergeInfoHolder.this.refresh(ignoreEnabled);
                return ListMergeStatus.REFRESHING;
            }
            if (state.getCopyRevision() != -1L && state.getCopyRevision() >= list.getNumber()) {
                return ListMergeStatus.COMMON;
            }
            return this.convert(state.getMap().get(list.getNumber()), false);
        }
    }

    public static interface ListChecker {
        public ListMergeStatus check(CommittedChangeList var1, boolean var2);
    }

    public static enum ListMergeStatus {
        COMMON(IconLoader.getIcon((String)"/icons/Common.png")),
        MERGED(IconLoader.getIcon((String)"/icons/Integrated.png")),
        NOT_MERGED(IconLoader.getIcon((String)"/icons/Notintegrated.png")),
        ALIEN(null),
        REFRESHING(IconLoader.getIcon((String)"/icons/IntegrationStatusUnknown.png"));

        private final Icon myIcon;

        private ListMergeStatus(Icon icon) {
            this.myIcon = icon;
        }

        public Icon getIcon() {
            return this.myIcon;
        }
    }

    private class MyRefresher
    implements CommittedChangeListsListener {
        private final WCInfoWithBranches myRefreshedRoot;
        private final WCInfoWithBranches.Branch myRefreshedBranch;
        private final String myBranchPath;

        private MyRefresher() {
            this.myRefreshedRoot = (WCInfoWithBranches)MergeInfoHolder.this.myRootGetter.get();
            this.myRefreshedBranch = (WCInfoWithBranches.Branch)MergeInfoHolder.this.myBranchGetter.get();
            this.myBranchPath = (String)MergeInfoHolder.this.myWcPathGetter.get();
        }

        public void onBeforeStartReport() {
        }

        public boolean report(CommittedChangeList list) {
            if (list instanceof SvnChangeList) {
                SvnChangeList svnList = (SvnChangeList)list;
                String wcPath = svnList.getWcPath() + File.separator;
                final SvnMergeInfoCache.MergeCheckResult checkState = MergeInfoHolder.this.myMergeInfoCache.getState(this.myRefreshedRoot, (SvnChangeList)list, this.myRefreshedBranch, this.myBranchPath);
                final long number = list.getNumber();
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MergeinfoCached cachedState = (MergeinfoCached)MergeInfoHolder.this.myCachedMap.get(MergeInfoHolder.createKey(MyRefresher.this.myRefreshedRoot, MyRefresher.this.myRefreshedBranch));
                        if (cachedState != null) {
                            cachedState.getMap().put(number, checkState);
                        }
                        MergeInfoHolder.this.myManager.repaintTree();
                    }
                });
            }
            return true;
        }

        public void onAfterEndReport() {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    MergeInfoHolder.this.myCachedMap.remove(MergeInfoHolder.createKey(MyRefresher.this.myRefreshedRoot, MyRefresher.this.myRefreshedBranch));
                    MergeInfoHolder.this.updateMixedRevisionsForPanel();
                    MergeInfoHolder.this.myManager.repaintTree();
                }
            });
        }
    }
}

