/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.util.Alarm;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class CodeStyleAbstractPanel
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.options.CodeStyleXmlPanel");
    private final Editor myEditor;
    private final CodeStyleSettings mySettings;
    private boolean myShouldUpdatePreview;
    protected static final int[] ourWrappings = new int[]{0, 1, 4, 2};
    private long myLastDocumentModificationStamp;
    private String myTextToReformat = null;
    private final UserActivityWatcher myUserActivityWatcher = new UserActivityWatcher();
    private final Alarm myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private CodeStyleSchemesModel myModel;
    private boolean mySomethingChanged = false;

    private synchronized void setSomethingChanged(boolean b) {
        this.mySomethingChanged = b;
    }

    private synchronized boolean isSomethingChanged() {
        return this.mySomethingChanged;
    }

    protected CodeStyleAbstractPanel(CodeStyleSettings settings) {
        this.mySettings = settings;
        this.myEditor = this.createEditor();
        this.myUpdateAlarm.setActivationComponent(this.myEditor.getComponent());
        this.myUserActivityWatcher.addUserActivityListener(new UserActivityListener(){

            public void stateChanged() {
                CodeStyleAbstractPanel.this.somethingChanged();
            }
        });
    }

    public void setModel(CodeStyleSchemesModel model) {
        this.myModel = model;
    }

    protected void somethingChanged() {
        if (this.myModel != null) {
            this.myModel.fireCurrentSettingsChanged();
        }
    }

    protected void addPanelToWatch(Component component) {
        this.myUserActivityWatcher.register(component);
    }

    private Editor createEditor() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        this.myTextToReformat = this.getPreviewText();
        Document editorDocument = editorFactory.createDocument((CharSequence)this.myTextToReformat);
        EditorEx editor = (EditorEx)editorFactory.createViewer(editorDocument);
        this.myLastDocumentModificationStamp = editor.getDocument().getModificationStamp();
        EditorSettings editorSettings = editor.getSettings();
        this.fillEditorSettings(editorSettings);
        this.updatePreviewHighlighter(editor);
        return editor;
    }

    private void updatePreviewHighlighter(EditorEx editor) {
        EditorColorsScheme scheme = editor.getColorsScheme();
        scheme.setColor(EditorColors.CARET_ROW_COLOR, null);
        editor.setHighlighter(this.createHighlighter(scheme));
    }

    protected void updatePreviewEditor() {
        this.myTextToReformat = this.getPreviewText();
        this.updatePreview();
        this.updatePreviewHighlighter((EditorEx)this.myEditor);
    }

    protected abstract EditorHighlighter createHighlighter(EditorColorsScheme var1);

    private void fillEditorSettings(EditorSettings editorSettings) {
        editorSettings.setWhitespacesShown(true);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setAdditionalColumnsCount(0);
        editorSettings.setAdditionalLinesCount(1);
        int rightMargin = this.getRightMargin();
        if (rightMargin > 0) {
            editorSettings.setRightMargin(rightMargin);
        }
    }

    protected abstract int getRightMargin();

    public final void updatePreview() {
        if (!this.myShouldUpdatePreview || !this.myEditor.getComponent().isShowing()) {
            return;
        }
        if (this.myLastDocumentModificationStamp != this.myEditor.getDocument().getModificationStamp()) {
            this.myTextToReformat = this.myEditor.getDocument().getText();
        }
        int currOffs = this.myEditor.getScrollingModel().getVerticalScrollOffset();
        final Project finalProject = this.getCurrentProject();
        CommandProcessor.getInstance().executeCommand(finalProject, new Runnable(){

            @Override
            public void run() {
                CodeStyleAbstractPanel.this.replaceText(finalProject);
            }
        }, null, null);
        this.myEditor.getSettings().setRightMargin(this.getRightMargin());
        this.myLastDocumentModificationStamp = this.myEditor.getDocument().getModificationStamp();
        this.myEditor.getScrollingModel().scrollVertically(currOffs);
    }

    private void replaceText(final Project project) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    PsiFile psiFile = CodeStyleAbstractPanel.this.createFileFromText(project, CodeStyleAbstractPanel.this.myTextToReformat);
                    CodeStyleAbstractPanel.this.prepareForReformat(psiFile);
                    CodeStyleAbstractPanel.this.apply(CodeStyleAbstractPanel.this.mySettings);
                    CodeStyleSettings clone = CodeStyleAbstractPanel.this.mySettings.clone();
                    if (CodeStyleAbstractPanel.this.getRightMargin() > 0) {
                        clone.RIGHT_MARGIN = CodeStyleAbstractPanel.this.getRightMargin();
                    }
                    CodeStyleSettingsManager.getInstance((Project)project).setTemporarySettings(clone);
                    PsiFile formatted = CodeStyleAbstractPanel.this.doReformat(project, psiFile);
                    CodeStyleSettingsManager.getInstance((Project)project).dropTemporarySettings();
                    CodeStyleAbstractPanel.this.myEditor.getSettings().setTabSize(clone.getTabSize(CodeStyleAbstractPanel.this.getFileType()));
                    Document document = CodeStyleAbstractPanel.this.myEditor.getDocument();
                    document.replaceString(0, document.getTextLength(), (CharSequence)formatted.getText());
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    protected abstract void prepareForReformat(PsiFile var1);

    protected PsiFile createFileFromText(Project project, String text) {
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("a." + this.getFileTypeExtension(this.getFileType()), this.getFileType(), (CharSequence)text, LocalTimeCounter.currentTime(), true);
        return psiFile;
    }

    protected PsiFile doReformat(Project project, PsiFile psiFile) {
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiFile);
        return psiFile;
    }

    protected Project getCurrentProject() {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        return project;
    }

    @NotNull
    protected abstract FileType getFileType();

    @NonNls
    protected abstract String getPreviewText();

    public abstract void apply(CodeStyleSettings var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset(CodeStyleSettings settings) {
        this.myShouldUpdatePreview = false;
        try {
            this.resetImpl(settings);
        }
        finally {
            this.myShouldUpdatePreview = true;
        }
    }

    protected static int getIndexForWrapping(int value) {
        for (int i = 0; i < ourWrappings.length; ++i) {
            int ourWrapping = ourWrappings[i];
            if (ourWrapping != value) continue;
            return i;
        }
        LOG.assertTrue(false);
        return 0;
    }

    public abstract boolean isModified(CodeStyleSettings var1);

    public abstract JComponent getPanel();

    public void dispose() {
        this.myUpdateAlarm.cancelAllRequests();
        EditorFactory.getInstance().releaseEditor(this.myEditor);
    }

    protected abstract void resetImpl(CodeStyleSettings var1);

    protected static void fillWrappingCombo(JComboBox wrapCombo) {
        wrapCombo.addItem(ApplicationBundle.message((String)"combobox.codestyle.do.not.wrap", (Object[])new Object[0]));
        wrapCombo.addItem(ApplicationBundle.message((String)"combobox.codestyle.wrap.if.long", (Object[])new Object[0]));
        wrapCombo.addItem(ApplicationBundle.message((String)"combobox.codestyle.chop.down.if.long", (Object[])new Object[0]));
        wrapCombo.addItem(ApplicationBundle.message((String)"combobox.codestyle.wrap.always", (Object[])new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFromFile(Class resourceContainerClass, @NonNls String fileName) {
        try {
            StringBuffer result;
            InputStream stream = resourceContainerClass.getClassLoader().getResourceAsStream("codeStyle/preview/" + fileName);
            InputStreamReader reader = new InputStreamReader(stream);
            LineNumberReader lineNumberReader = new LineNumberReader(reader);
            try {
                String line;
                result = new StringBuffer();
                while ((line = lineNumberReader.readLine()) != null) {
                    result.append(line);
                    result.append("\n");
                }
            }
            finally {
                lineNumberReader.close();
            }
            return result.toString();
        }
        catch (IOException e) {
            return "";
        }
    }

    protected void installPreviewPanel(JPanel previewPanel) {
        previewPanel.setLayout(new BorderLayout());
        previewPanel.add((Component)this.myEditor.getComponent(), "Center");
    }

    @NonNls
    protected String getFileTypeExtension(FileType fileType) {
        return fileType.getDefaultExtension();
    }

    public void onSomethingChanged() {
        this.setSomethingChanged(true);
        UiNotifyConnector.doWhenFirstShown((JComponent)this.myEditor.getComponent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                CodeStyleAbstractPanel.this.addUpdatePreviewRequest();
            }
        });
    }

    private void addUpdatePreviewRequest() {
        this.myUpdateAlarm.addComponentRequest(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CodeStyleAbstractPanel.this.myUpdateAlarm.cancelAllRequests();
                    if (CodeStyleAbstractPanel.this.isSomethingChanged()) {
                        CodeStyleAbstractPanel.this.updatePreview();
                    }
                }
                finally {
                    CodeStyleAbstractPanel.this.setSomethingChanged(false);
                }
            }
        }, 300);
    }

    protected Editor getEditor() {
        return this.myEditor;
    }
}

